/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.progress.StepsProgressIndicator;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import git4idea.DialogManager;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitRebaseCommandResult;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.GitRebaseStatus;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.GitSuccessfulRebase;
import git4idea.rebase.conflict.GitRebaseMergeDialogCustomizerKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseProcess {
    private static final Logger LOG = Logger.getInstance(GitRebaseProcess.class);
    private final NotificationAction ABORT_ACTION;
    private final NotificationAction CONTINUE_ACTION;
    private final NotificationAction RETRY_ACTION;
    private final NotificationAction VIEW_STASH_ACTION;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitRebaseSpec myRebaseSpec;
    @Nullable
    private final GitRebaseResumeMode myCustomMode;
    @NotNull
    private final GitChangesSaver mySaver;
    @NotNull
    private final ProgressManager myProgressManager;
    @NotNull
    private final VcsDirtyScopeManager myDirtyScopeManager;

    public GitRebaseProcess(@NotNull Project project, @NotNull GitRebaseSpec rebaseSpec, @Nullable GitRebaseResumeMode customMode) {
        if (project == null) {
            GitRebaseProcess.$$$reportNull$$$0(0);
        }
        if (rebaseSpec == null) {
            GitRebaseProcess.$$$reportNull$$$0(1);
        }
        this.ABORT_ACTION = NotificationAction.createSimpleExpiring((String)GitBundle.message("rebase.notification.action.abort.text", new Object[0]), () -> this.abort());
        this.CONTINUE_ACTION = NotificationAction.createSimpleExpiring((String)GitBundle.message("rebase.notification.action.continue.text", new Object[0]), () -> this.retry(GitBundle.message("rebase.progress.indicator.continue.title", new Object[0])));
        this.RETRY_ACTION = NotificationAction.createSimpleExpiring((String)GitBundle.message("rebase.notification.action.retry.text", new Object[0]), () -> this.retry(GitBundle.message("rebase.progress.indicator.retry.title", new Object[0])));
        this.myProject = project;
        this.myRebaseSpec = rebaseSpec;
        this.myCustomMode = customMode;
        this.mySaver = rebaseSpec.getSaver();
        this.myGit = Git.getInstance();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myProgressManager = ProgressManager.getInstance();
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.VIEW_STASH_ACTION = NotificationAction.createSimple((String)this.mySaver.getSaveMethod().selectBundleMessage(GitBundle.message("rebase.notification.action.view.stash.text", new Object[0]), GitBundle.message("rebase.notification.action.view.shelf.text", new Object[0])), () -> this.mySaver.showSavedChanges());
    }

    public void rebase() {
        if (this.checkForRebasingPublishedCommits()) {
            new GitFreezingProcess(this.myProject, GitBundle.message("rebase.git.operation.name", new Object[0]), this::doRebase).execute();
        }
    }

    private void doRebase() {
        LOG.info("Started rebase");
        LOG.debug("Started rebase with the following spec: " + this.myRebaseSpec);
        LinkedHashMap<GitRepository, GitRebaseStatus> statuses = new LinkedHashMap<GitRepository, GitRebaseStatus>(this.myRebaseSpec.getStatuses());
        List<GitRepository> repositoriesToRebase = this.myRepositoryManager.sortByDependency(this.myRebaseSpec.getIncompleteRepositories());
        if (repositoriesToRebase.isEmpty()) {
            LOG.info("Nothing to rebase");
            return;
        }
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)GitBundle.message("activity.name.rebase", new Object[0]));){
            GitRebaseStatus.Type latestStatus;
            if (!this.saveDirtyRootsInitially(repositoriesToRebase)) {
                return;
            }
            GitRepository latestRepository = null;
            ProgressIndicator showingIndicator = this.myProgressManager.getProgressIndicator();
            StepsProgressIndicator indicator = new StepsProgressIndicator((ProgressIndicator)(showingIndicator != null ? showingIndicator : new EmptyProgressIndicator()), repositoriesToRebase.size());
            indicator.setIndeterminate(false);
            for (GitRepository repository : repositoriesToRebase) {
                GitRebaseResumeMode customMode = null;
                if (repository == this.myRebaseSpec.getOngoingRebase()) {
                    customMode = this.myCustomMode == null ? GitRebaseResumeMode.CONTINUE : this.myCustomMode;
                }
                Hash startHash = GitUtil.getHead(repository);
                GitRebaseStatus rebaseStatus = this.rebaseSingleRoot(repository, customMode, GitRebaseProcess.getSuccessfulRepositories(statuses), (ProgressIndicator)indicator);
                indicator.nextStep();
                repository.update();
                if (customMode == GitRebaseResumeMode.CONTINUE) {
                    this.myDirtyScopeManager.dirDirtyRecursively(repository.getRoot());
                }
                latestRepository = repository;
                statuses.put(repository, rebaseStatus);
                GitUtil.refreshChangedVfs(repository, startHash);
                if (rebaseStatus.getType() == GitRebaseStatus.Type.SUCCESS) continue;
                break;
            }
            if ((latestStatus = ((GitRebaseStatus)statuses.get(latestRepository)).getType()) == GitRebaseStatus.Type.SUCCESS || latestStatus == GitRebaseStatus.Type.NOT_STARTED) {
                LOG.debug("Rebase completed successfully.");
                this.mySaver.load();
            }
            if (latestStatus == GitRebaseStatus.Type.SUCCESS) {
                this.notifySuccess();
            }
            this.saveUpdatedSpec(statuses);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e) {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
            ExceptionUtil.rethrowUnchecked((Throwable)e);
        }
    }

    private void saveUpdatedSpec(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseProcess.$$$reportNull$$$0(2);
        }
        if (this.myRebaseSpec.shouldBeSaved()) {
            GitRebaseSpec newRebaseInfo = this.myRebaseSpec.cloneWithNewStatuses(statuses);
            this.myRepositoryManager.setOngoingRebaseSpec(newRebaseInfo);
        } else {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
        }
    }

    @NotNull
    private GitRebaseStatus rebaseSingleRoot(@NotNull GitRepository repository, @Nullable GitRebaseResumeMode customMode, @NotNull Map<GitRepository, GitSuccessfulRebase> alreadyRebased, @NotNull ProgressIndicator indicator) {
        GitRebaseStatus.Type type;
        boolean somethingRebased;
        GitCommandResult result2;
        String repoName;
        block17: {
            ResolveConflictResult resolveResult;
            if (repository == null) {
                GitRebaseProcess.$$$reportNull$$$0(3);
            }
            if (alreadyRebased == null) {
                GitRebaseProcess.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                GitRebaseProcess.$$$reportNull$$$0(5);
            }
            VirtualFile root = repository.getRoot();
            repoName = DvcsUtil.getShortRepositoryName((Repository)repository);
            LOG.info("Rebasing root " + repoName + ", mode: " + ObjectUtils.notNull((Object)((Object)customMode), (Object)"standard"));
            boolean retryWhenDirty = false;
            int commitsToRebase = 0;
            try {
                GitRebaseParams params = this.myRebaseSpec.getParams();
                if (params != null) {
                    String upstream = params.getUpstream();
                    String branch = params.getBranch();
                    commitsToRebase = GitRebaseUtils.getNumberOfCommitsToRebase(repository, upstream, branch);
                }
            }
            catch (VcsException e) {
                LOG.warn("Couldn't get the number of commits to rebase", (Throwable)e);
            }
            GitRebaseProgressListener progressListener = new GitRebaseProgressListener(commitsToRebase, indicator);
            while (true) {
                GitRebaseProblemDetector rebaseDetector = new GitRebaseProblemDetector();
                GitUntrackedFilesOverwrittenByOperationDetector untrackedDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                GitRebaseCommandResult rebaseCommandResult = this.callRebase(repository, customMode, rebaseDetector, untrackedDetector, progressListener);
                result2 = rebaseCommandResult.getCommandResult();
                boolean bl = somethingRebased = customMode != null || progressListener.currentCommit > 1;
                if (rebaseCommandResult.wasCancelledInCommitList()) {
                    GitRebaseStatus gitRebaseStatus = GitRebaseStatus.notStarted();
                    if (gitRebaseStatus == null) {
                        GitRebaseProcess.$$$reportNull$$$0(6);
                    }
                    return gitRebaseStatus;
                }
                if (rebaseCommandResult.wasCancelledInCommitMessage()) {
                    this.showStoppedForEditingMessage();
                    return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED);
                }
                if (result2.success()) {
                    if (rebaseDetector.hasStoppedForEditing()) {
                        this.showStoppedForEditingMessage();
                        return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED);
                    }
                    LOG.debug("Successfully rebased " + repoName);
                    return new GitSuccessfulRebase();
                }
                if (rebaseDetector.isDirtyTree() && customMode == null && !retryWhenDirty) {
                    LOG.debug("Dirty tree detected in " + repoName);
                    String saveError = this.saveLocalChanges(Collections.singleton(repository.getRoot()));
                    if (saveError == null) {
                        retryWhenDirty = true;
                        continue;
                    }
                    LOG.warn(String.format("Couldn't %s root %s: %s", this.mySaver.getSaveMethod() == GitSaveChangesPolicy.SHELVE ? "shelve" : "stash", repository.getRoot(), saveError));
                    this.showFatalError(saveError, repository, somethingRebased, alreadyRebased.keySet());
                    GitRebaseStatus.Type type2 = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                    return new GitRebaseStatus(type2);
                }
                if (untrackedDetector.wasMessageDetected()) {
                    LOG.info("Untracked files detected in " + repoName);
                    this.showUntrackedFilesError(untrackedDetector.getRelativeFilePaths(), repository, somethingRebased, alreadyRebased.keySet());
                    type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                    return new GitRebaseStatus(type);
                }
                if (rebaseDetector.isNoChangeError()) {
                    LOG.info("'No changes' situation detected in " + repoName);
                    customMode = GitRebaseResumeMode.SKIP;
                    continue;
                }
                if (!rebaseDetector.isMergeConflict()) break block17;
                LOG.info("Merge conflict in " + repoName);
                resolveResult = this.showConflictResolver(repository, false);
                if (resolveResult != ResolveConflictResult.ALL_RESOLVED) break;
                customMode = GitRebaseResumeMode.CONTINUE;
            }
            if (resolveResult == ResolveConflictResult.NOTHING_TO_MERGE) {
                LOG.info("Unmerged changes while rebasing root " + repoName + ": " + result2.getErrorOutputAsJoinedString());
                this.showFatalError(result2.getErrorOutputAsHtmlString(), repository, somethingRebased, alreadyRebased.keySet());
                GitRebaseStatus.Type type3 = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                return new GitRebaseStatus(type3);
            }
            this.notifyNotAllConflictsResolved(repository);
            return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED);
        }
        LOG.info("Error rebasing root " + repoName + ": " + result2.getErrorOutputAsJoinedString());
        this.showFatalError(result2.getErrorOutputAsHtmlString(), repository, somethingRebased, alreadyRebased.keySet());
        type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
        return new GitRebaseStatus(type);
    }

    @NotNull
    private GitRebaseCommandResult callRebase(@NotNull GitRepository repository, @Nullable GitRebaseResumeMode mode, GitLineHandlerListener ... listeners) {
        if (repository == null) {
            GitRebaseProcess.$$$reportNull$$$0(7);
        }
        if (listeners == null) {
            GitRebaseProcess.$$$reportNull$$$0(8);
        }
        if (mode == null) {
            GitRebaseParams params = Objects.requireNonNull(this.myRebaseSpec.getParams());
            GitRebaseCommandResult gitRebaseCommandResult = this.myGit.rebase(repository, params, listeners);
            if (gitRebaseCommandResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(9);
            }
            return gitRebaseCommandResult;
        }
        if (mode == GitRebaseResumeMode.SKIP) {
            GitRebaseCommandResult gitRebaseCommandResult = this.myGit.rebaseSkip(repository, listeners);
            if (gitRebaseCommandResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(10);
            }
            return gitRebaseCommandResult;
        }
        LOG.assertTrue(mode == GitRebaseResumeMode.CONTINUE, (Object)("Unexpected rebase mode: " + mode));
        GitRebaseCommandResult gitRebaseCommandResult = this.myGit.rebaseContinue(repository, listeners);
        if (gitRebaseCommandResult == null) {
            GitRebaseProcess.$$$reportNull$$$0(11);
        }
        return gitRebaseCommandResult;
    }

    @VisibleForTesting
    @NotNull
    protected Collection<GitRepository> getDirtyRoots(@NotNull Collection<GitRepository> repositories2) {
        if (repositories2 == null) {
            GitRebaseProcess.$$$reportNull$$$0(12);
        }
        Collection<GitRepository> collection = this.findRootsWithLocalChanges(repositories2);
        if (collection == null) {
            GitRebaseProcess.$$$reportNull$$$0(13);
        }
        return collection;
    }

    private boolean saveDirtyRootsInitially(@NotNull List<? extends GitRepository> repositories2) {
        List repositoriesToSave;
        if (repositories2 == null) {
            GitRebaseProcess.$$$reportNull$$$0(14);
        }
        if ((repositoriesToSave = ContainerUtil.filter(repositories2, repository -> !repository.equals(this.myRebaseSpec.getOngoingRebase()))).isEmpty()) {
            return true;
        }
        Collection<VirtualFile> rootsToSave = GitUtil.getRootsFromRepositories(this.getDirtyRoots(repositoriesToSave));
        String error = this.saveLocalChanges(rootsToSave);
        if (error != null) {
            this.myNotifier.notifyError("git.rebase.not.started", GitBundle.message("rebase.notification.not.started.title", new Object[0]), error);
            return false;
        }
        return true;
    }

    @Nullable
    @Nls
    private String saveLocalChanges(@NotNull Collection<? extends VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            GitRebaseProcess.$$$reportNull$$$0(15);
        }
        try {
            this.mySaver.saveLocalChanges(rootsToSave);
            return null;
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            String message = this.mySaver.getSaveMethod().selectBundleMessage(GitBundle.message("rebase.notification.failed.stash.text", new Object[0]), GitBundle.message("rebase.notification.failed.shelf.text", new Object[0]));
            return new HtmlBuilder().append(message).br().appendRaw(e.getMessage()).toString();
        }
    }

    private Collection<GitRepository> findRootsWithLocalChanges(@NotNull Collection<GitRepository> repositories2) {
        if (repositories2 == null) {
            GitRebaseProcess.$$$reportNull$$$0(16);
        }
        return ContainerUtil.filter(repositories2, repository -> this.myChangeListManager.haveChangesUnder(repository.getRoot()) != ThreeState.NO);
    }

    @RequiresBackgroundThread
    protected void notifySuccess() {
        String baseBranch;
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        String rebasedBranch = GitRebaseProcess.getCommonCurrentBranchNameIfAllTheSame(this.myRebaseSpec.getAllRepositories());
        GitRebaseParams params = this.myRebaseSpec.getParams();
        String string = params == null ? null : (baseBranch = params.getUpstream() != null ? (String)ObjectUtils.notNull((Object)params.getNewBase(), (Object)params.getUpstream()) : params.getNewBase());
        if ("HEAD".equals(baseBranch)) {
            baseBranch = GitRebaseProcess.getItemIfAllTheSame(this.myRebaseSpec.getInitialBranchNames().values(), baseBranch);
        }
        String message = GitSuccessfulRebase.formatMessage(rebasedBranch, baseBranch, params != null && params.getBranch() != null);
        this.myNotifier.notifyMinorInfo("git.rebase.successful", GitBundle.message("rebase.notification.successful.title", new Object[0]), message);
    }

    @Nullable
    private static String getCommonCurrentBranchNameIfAllTheSame(@NotNull Collection<? extends GitRepository> repositories2) {
        if (repositories2 == null) {
            GitRebaseProcess.$$$reportNull$$$0(17);
        }
        return GitRebaseProcess.getItemIfAllTheSame(ContainerUtil.map(repositories2, Repository::getCurrentBranchName), null);
    }

    @Contract(value="_, !null -> !null")
    private static <T> T getItemIfAllTheSame(@NotNull Collection<? extends T> collection, @Nullable T defaultItem) {
        if (collection == null) {
            GitRebaseProcess.$$$reportNull$$$0(18);
        }
        return (T)(new HashSet<T>(collection).size() == 1 ? ContainerUtil.getFirstItem(collection) : defaultItem);
    }

    private void notifyNotAllConflictsResolved(@NotNull GitRepository conflictingRepository) {
        if (conflictingRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(19);
        }
        String description2 = GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        Notification notification2 = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(GitBundle.message("rebase.notification.conflict.title", new Object[0]), description2, NotificationType.WARNING).setDisplayId("git.rebase.stopped.due.to.conflicts").addAction((AnAction)this.createResolveNotificationAction(conflictingRepository)).addAction((AnAction)this.CONTINUE_ACTION).addAction((AnAction)this.ABORT_ACTION);
        if (this.mySaver.wereChangesSaved()) {
            notification2.addAction((AnAction)this.VIEW_STASH_ACTION);
        }
        this.myNotifier.notify(notification2);
    }

    @NotNull
    private ResolveConflictResult showConflictResolver(@NotNull GitRepository conflicting, boolean calledFromNotification) {
        if (conflicting == null) {
            GitRebaseProcess.$$$reportNull$$$0(20);
        }
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject).setMergeDialogCustomizer(GitRebaseMergeDialogCustomizerKt.createRebaseDialogCustomizer(conflicting, this.myRebaseSpec)).setReverse(true);
        RebaseConflictResolver conflictResolver = new RebaseConflictResolver(this.myProject, conflicting, params, calledFromNotification);
        boolean allResolved = conflictResolver.merge();
        if (conflictResolver.myWasNothingToMerge) {
            ResolveConflictResult resolveConflictResult = ResolveConflictResult.NOTHING_TO_MERGE;
            if (resolveConflictResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(21);
            }
            return resolveConflictResult;
        }
        if (allResolved) {
            ResolveConflictResult resolveConflictResult = ResolveConflictResult.ALL_RESOLVED;
            if (resolveConflictResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(22);
            }
            return resolveConflictResult;
        }
        ResolveConflictResult resolveConflictResult = ResolveConflictResult.UNRESOLVED_REMAIN;
        if (resolveConflictResult == null) {
            GitRebaseProcess.$$$reportNull$$$0(23);
        }
        return resolveConflictResult;
    }

    private void showStoppedForEditingMessage() {
        Notification notification2 = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(GitBundle.message("rebase.notification.editing.title", new Object[0]), "", NotificationType.INFORMATION).setDisplayId("git.rebase.stopped.for.editing").addAction((AnAction)this.CONTINUE_ACTION).addAction((AnAction)this.ABORT_ACTION);
        this.myNotifier.notify(notification2);
    }

    private void showFatalError(@NotNull @Nls String error, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful) {
        if (error == null) {
            GitRebaseProcess.$$$reportNull$$$0(24);
        }
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(25);
        }
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(26);
        }
        HtmlBuilder descriptionBuilder = new HtmlBuilder();
        if (this.myRepositoryManager.moreThanOneRoot()) {
            descriptionBuilder.append(DvcsUtil.getShortRepositoryName((Repository)currentRepository) + ": ");
        }
        descriptionBuilder.appendRaw(error).br();
        descriptionBuilder.appendRaw(GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver));
        String title = this.myRebaseSpec.getOngoingRebase() == null ? GitBundle.message("rebase.notification.failed.rebase.title", new Object[0]) : GitBundle.message("rebase.notification.failed.continue.title", new Object[0]);
        Notification notification2 = VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, descriptionBuilder.toString(), NotificationType.ERROR).setDisplayId("git.rebase.failed").addAction((AnAction)this.RETRY_ACTION);
        if (somethingWasRebased || !successful.isEmpty()) {
            notification2.addAction((AnAction)this.ABORT_ACTION);
        }
        if (this.mySaver.wereChangesSaved()) {
            notification2.addAction((AnAction)this.VIEW_STASH_ACTION);
        }
        this.myNotifier.notify(notification2);
    }

    private void showUntrackedFilesError(@NotNull Set<String> untrackedPaths, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful) {
        if (untrackedPaths == null) {
            GitRebaseProcess.$$$reportNull$$$0(27);
        }
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(28);
        }
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(29);
        }
        String message = GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        ArrayList<NotificationAction> actions2 = new ArrayList<NotificationAction>();
        actions2.add(this.RETRY_ACTION);
        if (somethingWasRebased || !successful.isEmpty()) {
            actions2.add(this.ABORT_ACTION);
        }
        if (this.mySaver.wereChangesSaved()) {
            actions2.add(this.VIEW_STASH_ACTION);
        }
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, currentRepository.getRoot(), untrackedPaths, GitBundle.message("rebase.git.operation.name", new Object[0]), message, null, actions2.toArray(new NotificationAction[0]));
    }

    @NotNull
    private static Map<GitRepository, GitSuccessfulRebase> getSuccessfulRepositories(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseProcess.$$$reportNull$$$0(30);
        }
        LinkedHashMap<GitRepository, GitSuccessfulRebase> map2 = new LinkedHashMap<GitRepository, GitSuccessfulRebase>();
        for (GitRepository repository : statuses.keySet()) {
            GitRebaseStatus status = statuses.get(repository);
            if (!(status instanceof GitSuccessfulRebase)) continue;
            map2.put(repository, (GitSuccessfulRebase)status);
        }
        LinkedHashMap<GitRepository, GitSuccessfulRebase> linkedHashMap = map2;
        if (linkedHashMap == null) {
            GitRebaseProcess.$$$reportNull$$$0(31);
        }
        return linkedHashMap;
    }

    private boolean checkForRebasingPublishedCommits() {
        if (this.myCustomMode != null || this.myRebaseSpec.getOngoingRebase() != null) {
            return true;
        }
        if (this.myRebaseSpec.getParams() == null) {
            LOG.error("Shouldn't happen. Spec: " + this.myRebaseSpec);
            return true;
        }
        String upstream = this.myRebaseSpec.getParams().getUpstream();
        for (GitRepository repository : this.myRebaseSpec.getAllRepositories()) {
            if (repository.getCurrentBranchName() == null) {
                LOG.error("No current branch in " + repository);
                return true;
            }
            String rebasingBranch = (String)ObjectUtils.notNull((Object)this.myRebaseSpec.getParams().getBranch(), (Object)repository.getCurrentBranchName());
            if (!this.isRebasingPublishedCommit(repository, upstream, rebasingBranch)) continue;
            return GitRebaseProcess.askIfShouldRebasePublishedCommit();
        }
        return true;
    }

    private boolean isRebasingPublishedCommit(@NotNull GitRepository repository, @Nullable String baseBranch, @NotNull String rebasingBranch) {
        if (repository == null) {
            GitRebaseProcess.$$$reportNull$$$0(32);
        }
        if (rebasingBranch == null) {
            GitRebaseProcess.$$$reportNull$$$0(33);
        }
        try {
            String range = GitRebaseUtils.getCommitsRangeToRebase(baseBranch, rebasingBranch);
            List<? extends TimedVcsCommit> commits2 = GitHistoryUtils.collectTimedCommits(this.myProject, repository.getRoot(), range);
            return ContainerUtil.exists(commits2, commit -> GitProtectedBranchesKt.isCommitPublished(repository, (Hash)commit.getId()));
        }
        catch (VcsException e) {
            LOG.error("Couldn't collect commits", (Throwable)e);
            return true;
        }
    }

    private static boolean askIfShouldRebasePublishedCommit() {
        Ref rebaseAnyway = Ref.create((Object)false);
        String message = new HtmlBuilder().append(GitBundle.message("rebase.confirmation.dialog.published.commits.message.first", new Object[0])).br().append(GitBundle.message("rebase.confirmation.dialog.published.commits.message.second", new Object[0])).wrapWith(HtmlChunk.html()).toString();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            int answer = DialogManager.showMessage(message, GitBundle.message("rebase.confirmation.dialog.published.commits.title", new Object[0]), new String[]{GitBundle.message("rebase.confirmation.dialog.published.commits.button.rebase.text", new Object[0]), GitBundle.message("rebase.confirmation.dialog.published.commits.button.cancel.text", new Object[0])}, 1, 1, Messages.getWarningIcon(), null);
            rebaseAnyway.set((Object)(answer == 0 ? 1 : 0));
        });
        return (Boolean)rebaseAnyway.get();
    }

    @NotNull
    private NotificationAction createResolveNotificationAction(final @NotNull GitRepository currentRepository) {
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(34);
        }
        NotificationAction notificationAction = NotificationAction.create((String)GitBundle.message("action.NotificationAction.text.resolve", new Object[0]), (e, notification2) -> this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, GitBundle.message("rebase.progress.indicator.conflicts.collecting.title", new Object[0]), (Notification)notification2){
            final /* synthetic */ Notification val$notification;
            {
                this.val$notification = notification2;
                super(arg0, arg1);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitRebaseProcess.this.resolveConflicts(currentRepository, this.val$notification);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$1", "run"));
            }
        }));
        if (notificationAction == null) {
            GitRebaseProcess.$$$reportNull$$$0(35);
        }
        return notificationAction;
    }

    private void resolveConflicts(@NotNull GitRepository currentRepository, @NotNull Notification notification2) {
        ResolveConflictResult result2;
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(36);
        }
        if (notification2 == null) {
            GitRebaseProcess.$$$reportNull$$$0(37);
        }
        if ((result2 = this.showConflictResolver(currentRepository, true)) == ResolveConflictResult.NOTHING_TO_MERGE) {
            ApplicationManager.getApplication().invokeLater(() -> {
                boolean continueRebase = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)GitBundle.message("rebase.notification.all.conflicts.resolved.title", new Object[0]), (String)GitBundle.message("rebase.notification.all.conflicts.resolved.text", new Object[0])).yesText(GitBundle.message("rebase.notification.all.conflicts.resolved.continue.rebase.action.text", new Object[0]))).noText(CommonBundle.getCancelButtonText())).ask(this.myProject);
                if (continueRebase) {
                    this.retry(GitBundle.message("rebase.progress.indicator.continue.title", new Object[0]));
                    notification2.expire();
                }
            });
        }
    }

    private void abort() {
        this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, GitBundle.message("rebase.progress.indicator.aborting.title", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitRebaseUtils.abort(this.myProject, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$2", "run"));
            }
        });
    }

    private void retry(@NotNull @Nls String processTitle) {
        if (processTitle == null) {
            GitRebaseProcess.$$$reportNull$$$0(38);
        }
        this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, processTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                GitRebaseUtils.continueRebase(this.myProject);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$3", "run"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 10, 11, 13, 21, 22, 23, 31, 35 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseSpec";
                break;
            }
            case 2: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statuses";
                break;
            }
            case 3: 
            case 7: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyRebased";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitRebaseProcess";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictingRepository";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicting";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 25: 
            case 28: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRepository";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successful";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untrackedPaths";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebasingBranch";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitRebaseProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseSingleRoot";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "callRebase";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyRoots";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "showConflictResolver";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessfulRepositories";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolveNotificationAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveUpdatedSpec";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rebaseSingleRoot";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 21: 
            case 22: 
            case 23: 
            case 31: 
            case 35: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "callRebase";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDirtyRoots";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveDirtyRootsInitially";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "saveLocalChanges";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findRootsWithLocalChanges";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCommonCurrentBranchNameIfAllTheSame";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getItemIfAllTheSame";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "notifyNotAllConflictsResolved";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showConflictResolver";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "showFatalError";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesError";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSuccessfulRepositories";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isRebasingPublishedCommit";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createResolveNotificationAction";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "resolveConflicts";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "retry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 10, 11, 13, 21, 22, 23, 31, 35 -> new IllegalStateException(string);
        };
    }

    private static class GitRebaseProgressListener
    implements GitLineHandlerListener {
        @NonNls
        private static final Pattern REBASING_PATTERN = Pattern.compile("^Rebasing \\((\\d+)/(\\d+)\\)$");
        @NonNls
        private static final String APPLYING_PREFIX = "Applying: ";
        private int currentCommit;
        private final int myCommitsToRebase;
        @NotNull
        private final ProgressIndicator myIndicator;

        GitRebaseProgressListener(int commitsToRebase, @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                GitRebaseProgressListener.$$$reportNull$$$0(0);
            }
            this.currentCommit = 0;
            this.myCommitsToRebase = commitsToRebase;
            this.myIndicator = indicator;
        }

        @Override
        public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
            Matcher matcher;
            if (line == null) {
                GitRebaseProgressListener.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                GitRebaseProgressListener.$$$reportNull$$$0(2);
            }
            if ((matcher = REBASING_PATTERN.matcher(line)).matches()) {
                this.currentCommit = Integer.parseInt(matcher.group(1));
            } else if (StringUtil.startsWith((CharSequence)line, (CharSequence)APPLYING_PREFIX)) {
                ++this.currentCommit;
            }
            if (this.myCommitsToRebase != 0) {
                this.myIndicator.setFraction((double)this.currentCommit / (double)this.myCommitsToRebase);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "git4idea/rebase/GitRebaseProcess$GitRebaseProgressListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onLineAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum ResolveConflictResult {
        ALL_RESOLVED,
        NOTHING_TO_MERGE,
        UNRESOLVED_REMAIN;

    }

    private class RebaseConflictResolver
    extends GitConflictResolver {
        private final boolean myCalledFromNotification;
        private boolean myWasNothingToMerge;

        RebaseConflictResolver(@NotNull Project project, @NotNull GitRepository repository, GitConflictResolver.Params params, boolean calledFromNotification) {
            if (project == null) {
                RebaseConflictResolver.$$$reportNull$$$0(0);
            }
            if (repository == null) {
                RebaseConflictResolver.$$$reportNull$$$0(1);
            }
            if (params == null) {
                RebaseConflictResolver.$$$reportNull$$$0(2);
            }
            super(project, Collections.singleton(repository.getRoot()), params);
            this.myCalledFromNotification = calledFromNotification;
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }

        @Override
        @RequiresBackgroundThread
        protected boolean proceedAfterAllMerged() {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            if (this.myCalledFromNotification) {
                GitRebaseProcess.this.retry(GitBundle.message("rebase.progress.indicator.continue.title", new Object[0]));
            }
            return true;
        }

        @Override
        protected boolean proceedIfNothingToMerge() {
            this.myWasNothingToMerge = true;
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repository";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "params";
                    break;
                }
            }
            objectArray[1] = "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

