/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitFileRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitFileHistory;
import git4idea.history.GitLogFullRecord;
import git4idea.history.GitLogOutputSplitter;
import git4idea.history.GitLogParser;
import git4idea.log.GitLogProvider;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 &2\u00020\u0001:\u0001&B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJD\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0006\u001a\u00020\u00072\u000b\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0015\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010\u0016J-\u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00182\u000b\u0010\u0019\u001a\u00070\u0012\u00a2\u0006\u0002\b\u00132\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J5\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001c0\u001e2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0015\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010 JU\u0010!\u001a\u0004\u0018\u00010\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u00122\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001c0\u001e2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0015\"\u00020\u0012H\u0002\u00a2\u0006\u0002\u0010%R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lgit4idea/history/GitFileHistory;", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "startingRevision", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;)V", "Lorg/jetbrains/annotations/NotNull;", "createLogHandler", "Lgit4idea/commands/GitLineHandler;", "parser", "Lgit4idea/history/GitLogParser;", "Lgit4idea/history/GitLogFullRecord;", "lastCommit", "", "Lorg/jetbrains/annotations/NonNls;", "parameters", "", "(Lgit4idea/history/GitLogParser;Lcom/intellij/openapi/vcs/FilePath;Ljava/lang/String;[Ljava/lang/String;)Lgit4idea/commands/GitLineHandler;", "getFirstCommitParentAndPathIfRename", "Lkotlin/Pair;", "commit", "filePath", "load", "", "consumer", "Lkotlin/Function1;", "Lgit4idea/GitFileRevision;", "(Lkotlin/jvm/functions/Function1;[Ljava/lang/String;)V", "runGitLog", "logParser", "startPath", "startRevision", "(Lgit4idea/history/GitLogParser;Lcom/intellij/openapi/vcs/FilePath;Ljava/lang/String;Lkotlin/jvm/functions/Function1;[Ljava/lang/String;)Ljava/lang/String;", "Companion", "intellij.vcs.git"})
public final class GitFileHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final VcsRevisionNumber startingRevision;
    @NotNull
    private final FilePath path;

    private GitFileHistory(Project project, VirtualFile root, FilePath path, VcsRevisionNumber startingRevision) {
        this.project = project;
        this.root = root;
        this.startingRevision = startingRevision;
        FilePath filePath = VcsUtil.getLastCommitPath((Project)this.project, (FilePath)path);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getLastCommitPath(project, path)");
        this.path = filePath;
    }

    private final void load(Function1<? super GitFileRevision, Unit> consumer2, String ... parameters) throws VcsException {
        GitLogParser<GitLogFullRecord> logParser = Companion.createLogParser$intellij_vcs_git(this.project);
        String startRevision = this.startingRevision.asString();
        FilePath startPath = this.path;
        while (startRevision != null) {
            Pair<String, FilePath> firstCommitParentAndPath;
            String lastCommit;
            if (this.runGitLog(logParser, startPath, startRevision, consumer2, Arrays.copyOf(parameters, parameters.length)) == null) {
                return;
            }
            if (this.getFirstCommitParentAndPathIfRename(lastCommit, startPath) == null) {
                return;
            }
            startRevision = (String)firstCommitParentAndPath.getFirst();
            startPath = (FilePath)firstCommitParentAndPath.getSecond();
        }
    }

    private final String runGitLog(GitLogParser<GitLogFullRecord> logParser, FilePath startPath, String startRevision, Function1<? super GitFileRevision, Unit> consumer2, String ... parameters) throws VcsException {
        GitLineHandler handler = this.createLogHandler(logParser, startPath, startRevision, Arrays.copyOf(parameters, parameters.length));
        Ref.BooleanRef skipFurtherOutput = new Ref.BooleanRef();
        Ref.ObjectRef lastCommit = new Ref.ObjectRef();
        GitLogOutputSplitter<Object> splitter2 = new GitLogOutputSplitter<Object>(handler, logParser, arg_0 -> GitFileHistory.runGitLog$lambda$0((Function1)new Function1<GitLogFullRecord, Unit>(skipFurtherOutput, this, startPath, (Ref.ObjectRef<String>)lastCommit, consumer2){
            final /* synthetic */ Ref.BooleanRef $skipFurtherOutput;
            final /* synthetic */ GitFileHistory this$0;
            final /* synthetic */ FilePath $startPath;
            final /* synthetic */ Ref.ObjectRef<String> $lastCommit;
            final /* synthetic */ Function1<GitFileRevision, Unit> $consumer;
            {
                this.$skipFurtherOutput = $skipFurtherOutput;
                this.this$0 = $receiver;
                this.$startPath = $startPath;
                this.$lastCommit = $lastCommit;
                this.$consumer = $consumer;
                super(1);
            }

            public final void invoke(GitLogFullRecord record) {
                if (this.$skipFurtherOutput.element) {
                    return;
                }
                List<VcsFileStatusInfo> list2 = record.getStatusInfos();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"record.statusInfos");
                VcsFileStatusInfo vcsFileStatusInfo = (VcsFileStatusInfo)CollectionsKt.firstOrNull(list2);
                if ((vcsFileStatusInfo != null ? vcsFileStatusInfo.getType() : null) == Change.Type.NEW && !GitFileHistory.access$getPath$p(this.this$0).isDirectory()) {
                    this.$skipFurtherOutput.element = true;
                }
                Project project = GitFileHistory.access$getProject$p(this.this$0);
                VirtualFile virtualFile = GitFileHistory.access$getRoot$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)record, (String)"record");
                GitFileRevision revision = GitFileHistory.Companion.createGitFileRevision$intellij_vcs_git(project, virtualFile, record, this.$startPath);
                this.$lastCommit.element = record.getHash();
                this.$consumer.invoke((Object)revision);
            }
        }, arg_0));
        Git.getInstance().runCommandWithoutCollectingOutput(handler);
        splitter2.reportErrors();
        return (String)lastCommit.element;
    }

    private final Pair<String, FilePath> getFirstCommitParentAndPathIfRename(String commit, FilePath filePath) throws VcsException {
        GitLineHandler h = new GitLineHandler(this.project, this.root, GitCommand.SHOW);
        GitLogParser.GitLogOption[] gitLogOptionArray = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS};
        GitLogParser<GitLogFullRecord> gitLogParser = GitLogParser.createDefaultParser(this.project, GitLogParser.NameStatus.STATUS, gitLogOptionArray);
        Intrinsics.checkNotNullExpressionValue(gitLogParser, (String)"createDefaultParser(proj\u2026    GitLogOption.PARENTS)");
        GitLogParser<GitLogFullRecord> parser = gitLogParser;
        h.setStdoutSuppressed(true);
        String[] stringArray = new String[]{"-M", "-m", "--follow", "--name-status", parser.getPretty(), "--encoding=UTF-8", commit};
        h.addParameters(stringArray);
        h.endOptions();
        stringArray = new FilePath[]{filePath};
        h.addRelativePaths((FilePath[])stringArray);
        String string = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().runCommand(h).getOutputOrThrow()");
        String output = string;
        List<GitLogFullRecord> list2 = parser.parse(output);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"parser.parse(output)");
        List<GitLogFullRecord> records = list2;
        if (records.isEmpty()) {
            return null;
        }
        int n = records.size();
        for (int i = 0; i < n; ++i) {
            List<Change> changes;
            GitLogFullRecord record = records.get(i);
            Intrinsics.checkNotNullExpressionValue(record.parseChanges(this.project, this.root), (String)"record.parseChanges(project, root)");
            for (Change change : changes) {
                if (!change.isMoved() && !change.isRenamed()) continue;
                ContentRevision contentRevision = change.getAfterRevision();
                Intrinsics.checkNotNull((Object)contentRevision);
                if (!Intrinsics.areEqual((Object)filePath, (Object)contentRevision.getFile())) continue;
                String[] stringArray2 = record.getParentsHashes();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"record.parentsHashes");
                String[] parents = stringArray2;
                String parent = !(parents.length == 0) ? parents[i] : null;
                ContentRevision contentRevision2 = change.getBeforeRevision();
                Intrinsics.checkNotNull((Object)contentRevision2);
                FilePath filePath2 = contentRevision2.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"change.beforeRevision!!.file");
                return new Pair((Object)parent, (Object)filePath2);
            }
        }
        return null;
    }

    private final GitLineHandler createLogHandler(GitLogParser<GitLogFullRecord> parser, FilePath path, String lastCommit, String ... parameters) {
        GitLineHandler h = new GitLineHandler(this.project, this.root, GitCommand.LOG);
        h.setStdoutSuppressed(true);
        String[] stringArray = new String[]{"--name-status", parser.getPretty(), "--encoding=UTF-8", lastCommit};
        h.addParameters(stringArray);
        if (GitVersionSpecialty.FULL_HISTORY_SIMPLIFY_MERGES_WORKS_CORRECTLY.existsIn(this.project) && Registry.is((String)"git.file.history.full")) {
            stringArray = new String[]{"--full-history", "--simplify-merges"};
            h.addParameters(stringArray);
        }
        if (!(parameters.length == 0)) {
            h.addParameters(Arrays.copyOf(parameters, parameters.length));
        }
        h.endOptions();
        stringArray = new FilePath[]{path};
        h.addRelativePaths((FilePath[])stringArray);
        return h;
    }

    private static final void runGitLog$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @JvmStatic
    public static final void loadHistory(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingFrom, @NotNull Consumer<? super GitFileRevision> consumer2, @NotNull Consumer<? super VcsException> exceptionConsumer, String ... parameters) {
        Companion.loadHistory(project, path, startingFrom, consumer2, exceptionConsumer, parameters);
    }

    @JvmStatic
    @NotNull
    public static final List<VcsFileRevision> collectHistoryForRevision(@NotNull Project project, @NotNull FilePath path, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
        return Companion.collectHistoryForRevision(project, path, startingFrom, parameters);
    }

    @JvmStatic
    @NotNull
    public static final List<VcsFileRevision> collectHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        return Companion.collectHistory(project, path, parameters);
    }

    public static final /* synthetic */ FilePath access$getPath$p(GitFileHistory $this) {
        return $this.path;
    }

    public static final /* synthetic */ Project access$getProject$p(GitFileHistory $this) {
        return $this.project;
    }

    public static final /* synthetic */ VirtualFile access$getRoot$p(GitFileHistory $this) {
        return $this.root;
    }

    public /* synthetic */ GitFileHistory(Project project, VirtualFile root, FilePath path, VcsRevisionNumber startingRevision, DefaultConstructorMarker $constructor_marker) {
        this(project, root, path, startingRevision);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J7\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010\rJ?\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0019J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001cJO\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u001e0 2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010!J[\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u000e\u0010\u001f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\"2\u000e\u0010#\u001a\n\u0012\u0006\b\u0000\u0012\u00020$0\"2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0007\u00a2\u0006\u0002\u0010%J\u0016\u0010\u0018\u001a\u0004\u0018\u00010\t*\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a8\u0006&"}, d2={"Lgit4idea/history/GitFileHistory$Companion;", "", "()V", "collectHistory", "", "Lcom/intellij/openapi/vcs/history/VcsFileRevision;", "project", "Lcom/intellij/openapi/project/Project;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "parameters", "", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;[Ljava/lang/String;)Ljava/util/List;", "collectHistoryForRevision", "startingFrom", "Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;[Ljava/lang/String;)Ljava/util/List;", "createGitFileRevision", "Lgit4idea/GitFileRevision;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "record", "Lgit4idea/history/GitLogFullRecord;", "filePath", "createGitFileRevision$intellij_vcs_git", "createLogParser", "Lgit4idea/history/GitLogParser;", "createLogParser$intellij_vcs_git", "loadHistory", "", "consumer", "Lkotlin/Function1;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Lkotlin/jvm/functions/Function1;[Ljava/lang/String;)V", "Ljava/util/function/Consumer;", "exceptionConsumer", "Lcom/intellij/openapi/vcs/VcsException;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/history/VcsRevisionNumber;Ljava/util/function/Consumer;Ljava/util/function/Consumer;[Ljava/lang/String;)V", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final FilePath filePath(GitLogFullRecord $this$filePath, VirtualFile root) {
            List<VcsFileStatusInfo> list2 = $this$filePath.getStatusInfos();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"statusInfos");
            VcsFileStatusInfo vcsFileStatusInfo = (VcsFileStatusInfo)CollectionsKt.firstOrNull(list2);
            if (vcsFileStatusInfo == null) {
                return null;
            }
            VcsFileStatusInfo statusInfo = vcsFileStatusInfo;
            String string = root.getPath();
            String string2 = statusInfo.getSecondPath();
            if (string2 == null) {
                string2 = statusInfo.getFirstPath();
            }
            return VcsUtil.getFilePath((String)(string + "/" + string2), (boolean)false);
        }

        @NotNull
        public final GitFileRevision createGitFileRevision$intellij_vcs_git(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLogFullRecord record, @NotNull FilePath filePath) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            GitRevisionNumber revision = new GitRevisionNumber(record.getHash(), record.getDate());
            Couple couple = Couple.of((Object)record.getAuthorName(), (Object)record.getAuthorEmail());
            Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"of(record.authorName, record.authorEmail)");
            Couple authorPair = couple;
            Couple couple2 = Couple.of((Object)record.getCommitterName(), (Object)record.getCommitterEmail());
            Intrinsics.checkNotNullExpressionValue((Object)couple2, (String)"of(record.committerName, record.committerEmail)");
            Couple committerPair = couple2;
            String[] stringArray = record.getParentsHashes();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"record.parentsHashes");
            String[] stringArray2 = stringArray;
            List parents = CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray2, stringArray2.length));
            FilePath filePath2 = this.filePath(record, root);
            if (filePath2 == null) {
                filePath2 = filePath;
            }
            FilePath revisionPath = filePath2;
            List<VcsFileStatusInfo> list2 = record.getStatusInfos();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"record.statusInfos");
            VcsFileStatusInfo vcsFileStatusInfo = (VcsFileStatusInfo)CollectionsKt.firstOrNull(list2);
            boolean deleted = (vcsFileStatusInfo != null ? vcsFileStatusInfo.getType() : null) == Change.Type.DELETED;
            return new GitFileRevision(project, root, revisionPath, revision, (Couple<Couple<String>>)Couple.of((Object)authorPair, (Object)committerPair), record.getFullMessage(), null, new Date(record.getAuthorTimeStamp()), parents, deleted);
        }

        @NotNull
        public final GitLogParser<GitLogFullRecord> createLogParser$intellij_vcs_git(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GitLogParser.GitLogOption[] gitLogOptionArray = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.AUTHOR_TIME};
            GitLogParser<GitLogFullRecord> gitLogParser = GitLogParser.createDefaultParser(project, GitLogParser.NameStatus.STATUS, gitLogOptionArray);
            Intrinsics.checkNotNullExpressionValue(gitLogParser, (String)"createDefaultParser(proj\u2026GitLogOption.AUTHOR_TIME)");
            return gitLogParser;
        }

        private final void loadHistory(Project project, FilePath path, VcsRevisionNumber startingFrom, Function1<? super GitFileRevision, Unit> consumer2, String ... parameters) {
            VirtualFile virtualFile = GitUtil.getRootForFile(project, path);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRootForFile(project, path)");
            VirtualFile detectedRoot = virtualFile;
            VirtualFile virtualFile2 = GitLogProvider.getCorrectedVcsRoot(GitRepositoryManager.getInstance(project), detectedRoot, path);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getCorrectedVcsRoot(GitR\u2026ect), detectedRoot, path)");
            VirtualFile repositoryRoot = virtualFile2;
            VcsRevisionNumber vcsRevisionNumber = startingFrom;
            if (vcsRevisionNumber == null) {
                vcsRevisionNumber = (VcsRevisionNumber)GitRevisionNumber.HEAD;
            }
            VcsRevisionNumber revision = vcsRevisionNumber;
            Intrinsics.checkNotNullExpressionValue((Object)revision, (String)"revision");
            new GitFileHistory(project, repositoryRoot, path, revision, null).load((Function1<? super GitFileRevision, Unit>)consumer2, Arrays.copyOf(parameters, parameters.length));
        }

        @JvmStatic
        public final void loadHistory(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingFrom, @NotNull Consumer<? super GitFileRevision> consumer2, @NotNull Consumer<? super VcsException> exceptionConsumer, String ... parameters) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
            Intrinsics.checkNotNullParameter(exceptionConsumer, (String)"exceptionConsumer");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            try {
                this.loadHistory(project, path, startingFrom, (Function1<? super GitFileRevision, Unit>)((Function1)new Function1<GitFileRevision, Unit>(consumer2){

                    public final void invoke(@NotNull GitFileRevision p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        ((Consumer)this.receiver).accept(p0);
                    }
                }), Arrays.copyOf(parameters, parameters.length));
            }
            catch (VcsException e) {
                exceptionConsumer.accept(e);
            }
        }

        @JvmStatic
        @NotNull
        public final List<VcsFileRevision> collectHistoryForRevision(@NotNull Project project, @NotNull FilePath path, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)startingFrom, (String)"startingFrom");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            List revisions = new ArrayList();
            this.loadHistory(project, path, startingFrom, (Function1<? super GitFileRevision, Unit>)((Function1)new Function1<VcsFileRevision, Unit>((Object)revisions){

                public final void invoke(@NotNull VcsFileRevision p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((List)collectHistoryForRevision.1.access$getReceiver$p(this)).add(p0);
                }

                public static final /* synthetic */ Object access$getReceiver$p(collectHistoryForRevision.1 $this) {
                    return $this.receiver;
                }
            }), Arrays.copyOf(parameters, parameters.length));
            return revisions;
        }

        @JvmStatic
        @NotNull
        public final List<VcsFileRevision> collectHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            GitRevisionNumber gitRevisionNumber = GitRevisionNumber.HEAD;
            Intrinsics.checkNotNullExpressionValue((Object)gitRevisionNumber, (String)"HEAD");
            return this.collectHistoryForRevision(project, path, (VcsRevisionNumber)gitRevisionNumber, Arrays.copyOf(parameters, parameters.length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

