/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileSystemItemFilter;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ui.SimpleTextAttributes;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MavenModuleDirectoryNode
extends PsiDirectoryNode {
    @NlsSafe
    private final String myModuleShortName;
    private final boolean appendModuleName;

    MavenModuleDirectoryNode(Project project2, @NotNull PsiDirectory psiDirectory, ViewSettings settings, String moduleShortName, PsiFileSystemItemFilter filter) {
        if (psiDirectory == null) {
            MavenModuleDirectoryNode.$$$reportNull$$$0(0);
        }
        super(project2, psiDirectory, settings, filter);
        this.myModuleShortName = moduleShortName;
        VirtualFile directoryFile = psiDirectory.getVirtualFile();
        this.appendModuleName = StringUtil.isNotEmpty((String)this.myModuleShortName) && !StringUtil.equalsIgnoreCase((CharSequence)this.myModuleShortName.replace("-", ""), (CharSequence)directoryFile.getName().replace("-", ""));
    }

    protected boolean shouldShowModuleName() {
        return !this.appendModuleName || MavenModuleDirectoryNode.canRealModuleNameBeHidden();
    }

    protected void updateImpl(@NotNull PresentationData data2) {
        if (data2 == null) {
            MavenModuleDirectoryNode.$$$reportNull$$$0(1);
        }
        super.updateImpl(data2);
        if (this.appendModuleName) {
            if (!MavenModuleDirectoryNode.canRealModuleNameBeHidden()) {
                data2.addText("[" + this.myModuleShortName + "]", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            }
        } else {
            List fragments = data2.getColoredText();
            PresentableNodeDescriptor.ColoredFragment fragment = (PresentableNodeDescriptor.ColoredFragment)fragments.iterator().next();
            data2.clearText();
            data2.addText(fragment.getText().trim(), SimpleTextAttributes.merge((SimpleTextAttributes)fragment.getAttributes(), (SimpleTextAttributes)SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/MavenModuleDirectoryNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

