/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import java.io.File;
import java.util.Collection;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.MavenIndexerWrapper;
import org.jetbrains.idea.maven.server.MavenServerConnector;
import org.jetbrains.idea.maven.server.MavenServerConnectorImpl;

public interface MavenServerManager
extends Disposable {
    public static final String BUNDLED_MAVEN_2 = "Bundled (Maven 2)";
    public static final String BUNDLED_MAVEN_3 = "Bundled (Maven 3)";
    public static final String BUNDLED_MAVEN_4 = "Bundled (Maven 4)";
    public static final String WRAPPED_MAVEN = "Use Maven wrapper";

    public Collection<MavenServerConnector> getAllConnectors();

    public void restartMavenConnectors(Project var1, boolean var2, Predicate<MavenServerConnector> var3);

    public MavenServerConnector getConnector(@NotNull Project var1, @NotNull String var2);

    public boolean shutdownConnector(MavenServerConnector var1, boolean var2);

    public void shutdown(boolean var1);

    public File getMavenEventListener();

    @Deprecated
    @NotNull
    default public MavenEmbedderWrapper createEmbedder(Project project2, boolean alwaysOnline, @Nullable String ignoredWorkingDirectory, @NotNull String multiModuleProjectDirectory) {
        if (multiModuleProjectDirectory == null) {
            MavenServerManager.$$$reportNull$$$0(0);
        }
        MavenEmbedderWrapper mavenEmbedderWrapper = this.createEmbedder(project2, alwaysOnline, multiModuleProjectDirectory);
        if (mavenEmbedderWrapper == null) {
            MavenServerManager.$$$reportNull$$$0(1);
        }
        return mavenEmbedderWrapper;
    }

    @NotNull
    public MavenEmbedderWrapper createEmbedder(Project var1, boolean var2, @NotNull String var3);

    public MavenIndexerWrapper createIndexer(@NotNull Project var1);

    public static MavenServerManager getInstance() {
        return (MavenServerManager)ApplicationManager.getApplication().getService(MavenServerManager.class);
    }

    @Nullable
    public static MavenServerManager getInstanceIfCreated() {
        return (MavenServerManager)ApplicationManager.getApplication().getServiceIfCreated(MavenServerManager.class);
    }

    @Deprecated(forRemoval=true)
    @Nullable
    default public String getCurrentMavenVersion() {
        return null;
    }

    default public boolean isUseMaven2() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiModuleProjectDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/server/MavenServerManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/server/MavenServerManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmbedder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEmbedder";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static class MavenServerConnectorFactoryImpl
    implements MavenServerConnectorFactory {
        @Override
        @NotNull
        public MavenServerConnector create(@NotNull Project project2, @NotNull Sdk jdk2, @NotNull String vmOptions, @Nullable Integer debugPort, @NotNull MavenDistribution mavenDistribution, @NotNull String multimoduleDirectory) {
            if (project2 == null) {
                MavenServerConnectorFactoryImpl.$$$reportNull$$$0(0);
            }
            if (jdk2 == null) {
                MavenServerConnectorFactoryImpl.$$$reportNull$$$0(1);
            }
            if (vmOptions == null) {
                MavenServerConnectorFactoryImpl.$$$reportNull$$$0(2);
            }
            if (mavenDistribution == null) {
                MavenServerConnectorFactoryImpl.$$$reportNull$$$0(3);
            }
            if (multimoduleDirectory == null) {
                MavenServerConnectorFactoryImpl.$$$reportNull$$$0(4);
            }
            return new MavenServerConnectorImpl(project2, jdk2, vmOptions, debugPort, mavenDistribution, multimoduleDirectory);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "jdk";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vmOptions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mavenDistribution";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "multimoduleDirectory";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/server/MavenServerManager$MavenServerConnectorFactoryImpl";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @ApiStatus.Internal
    public static interface MavenServerConnectorFactory {
        @NotNull
        public MavenServerConnector create(@NotNull Project var1, @NotNull Sdk var2, @NotNull String var3, @Nullable Integer var4, @NotNull MavenDistribution var5, @NotNull String var6);
    }
}

