/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.config.MavenConfig;
import org.jetbrains.idea.maven.config.MavenConfigParser;
import org.jetbrains.idea.maven.config.MavenConfigSettings;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

public class MavenGeneralSettings
implements Cloneable {
    private transient Project myProject;
    private boolean workOffline = false;
    private String mavenHome = "Bundled (Maven 3)";
    private String mavenSettingsFile = "";
    private String overriddenLocalRepository = "";
    private boolean printErrorStackTraces = false;
    private boolean usePluginRegistry = false;
    private boolean nonRecursive = false;
    private boolean alwaysUpdateSnapshots = false;
    private boolean showDialogWithAdvancedSettings = false;
    private boolean useMavenConfig = true;
    private String threads;
    private boolean emulateTerminal = false;
    private MavenExecutionOptions.LoggingLevel outputLevel = MavenExecutionOptions.LoggingLevel.INFO;
    MavenExecutionOptions.ChecksumPolicy checksumPolicy = MavenExecutionOptions.ChecksumPolicy.NOT_SET;
    private MavenExecutionOptions.FailureMode failureBehavior = MavenExecutionOptions.FailureMode.NOT_SET;
    private transient File myEffectiveLocalRepositoryCache;
    private transient File myEffectiveLocalHomeCache;
    private transient VirtualFile myEffectiveSuperPomCache;
    private transient Set<String> myDefaultPluginsCache;
    private transient MavenConfig mavenConfigCache;
    private int myBulkUpdateLevel = 0;
    private List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public MavenGeneralSettings() {
    }

    public MavenGeneralSettings(Project project2) {
        this.myProject = project2;
    }

    public void setProject(Project project2) {
        this.myProject = project2;
    }

    public void beginUpdate() {
        ++this.myBulkUpdateLevel;
    }

    public void endUpdate() {
        if (--this.myBulkUpdateLevel == 0) {
            this.changed();
        }
    }

    public void changed() {
        this.changed(true);
    }

    public void changed(boolean fireUpdate) {
        if (this.myBulkUpdateLevel > 0) {
            return;
        }
        this.myEffectiveLocalRepositoryCache = null;
        this.myDefaultPluginsCache = null;
        this.myEffectiveLocalHomeCache = null;
        this.myEffectiveSuperPomCache = null;
        this.mavenConfigCache = null;
        if (fireUpdate) {
            this.fireChanged();
        }
    }

    @Property
    @NotNull
    public MavenExecutionOptions.ChecksumPolicy getChecksumPolicy() {
        MavenExecutionOptions.ChecksumPolicy checksumPolicy = this.checksumPolicy;
        if (checksumPolicy == null) {
            MavenGeneralSettings.$$$reportNull$$$0(0);
        }
        return checksumPolicy;
    }

    public void setChecksumPolicy(MavenExecutionOptions.ChecksumPolicy value) {
        if (value == null) {
            return;
        }
        if (!Comparing.equal((Object)((Object)this.checksumPolicy), (Object)((Object)value))) {
            this.checksumPolicy = value;
            this.changed();
        }
    }

    @Property
    @NotNull
    public MavenExecutionOptions.FailureMode getFailureBehavior() {
        MavenExecutionOptions.FailureMode failureMode = this.failureBehavior;
        if (failureMode == null) {
            MavenGeneralSettings.$$$reportNull$$$0(1);
        }
        return failureMode;
    }

    public void setFailureBehavior(MavenExecutionOptions.FailureMode value) {
        if (value == null) {
            return;
        }
        if (!Comparing.equal((Object)((Object)this.failureBehavior), (Object)((Object)value))) {
            this.failureBehavior = value;
            this.changed();
        }
    }

    @Transient
    @Deprecated(forRemoval=true)
    @NotNull
    public MavenExecutionOptions.LoggingLevel getLoggingLevel() {
        MavenExecutionOptions.LoggingLevel loggingLevel = this.getOutputLevel();
        if (loggingLevel == null) {
            MavenGeneralSettings.$$$reportNull$$$0(2);
        }
        return loggingLevel;
    }

    @Property
    @NotNull
    public MavenExecutionOptions.LoggingLevel getOutputLevel() {
        MavenExecutionOptions.LoggingLevel loggingLevel = this.outputLevel;
        if (loggingLevel == null) {
            MavenGeneralSettings.$$$reportNull$$$0(3);
        }
        return loggingLevel;
    }

    public void setOutputLevel(MavenExecutionOptions.LoggingLevel value) {
        if (value == null) {
            return;
        }
        if (!Comparing.equal((Object)((Object)this.outputLevel), (Object)((Object)value))) {
            this.outputLevel = value;
            this.changed();
        }
    }

    public boolean isWorkOffline() {
        return this.workOffline;
    }

    public void setWorkOffline(boolean value) {
        if (!Comparing.equal((Object)this.workOffline, (Object)value)) {
            this.workOffline = value;
            this.changed();
        }
    }

    @NotNull
    public String getMavenHome() {
        String string = this.mavenHome;
        if (string == null) {
            MavenGeneralSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setMavenHome(@NotNull String mavenHome) {
        if (mavenHome == null) {
            MavenGeneralSettings.$$$reportNull$$$0(5);
        }
        this.setMavenHome(mavenHome, true);
    }

    @TestOnly
    public void setMavenHomeNoFire(@NotNull String mavenHome) {
        if (mavenHome == null) {
            MavenGeneralSettings.$$$reportNull$$$0(6);
        }
        this.setMavenHome(mavenHome, false);
    }

    private void setMavenHome(@NotNull String mavenHome, boolean fireChanged) {
        if (mavenHome == null) {
            MavenGeneralSettings.$$$reportNull$$$0(7);
        }
        File mavenHomeDirectory = MavenUtil.resolveMavenHomeDirectory(mavenHome);
        File bundledMavenHomeDirectory = MavenUtil.resolveMavenHomeDirectory("Bundled (Maven 3)");
        String mavenHomeToSet = mavenHome;
        if (FileUtil.filesEqual((File)mavenHomeDirectory, (File)bundledMavenHomeDirectory)) {
            mavenHomeToSet = "Bundled (Maven 3)";
        }
        if (!Objects.equals(this.mavenHome, mavenHomeToSet)) {
            this.mavenHome = mavenHomeToSet;
            this.myDefaultPluginsCache = null;
            if (fireChanged) {
                this.changed();
            }
        }
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public File getEffectiveMavenHome() {
        if (this.myEffectiveLocalHomeCache == null) {
            this.myEffectiveLocalHomeCache = MavenWslUtil.resolveMavenHome(this.myProject, this.getMavenHome());
        }
        return this.myEffectiveLocalHomeCache;
    }

    @NotNull
    public String getUserSettingsFile() {
        String string = this.mavenSettingsFile;
        if (string == null) {
            MavenGeneralSettings.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setUserSettingsFile(@Nullable String mavenSettingsFile) {
        if (mavenSettingsFile == null) {
            return;
        }
        if (!Objects.equals(this.mavenSettingsFile, mavenSettingsFile)) {
            this.mavenSettingsFile = mavenSettingsFile;
            this.changed();
        }
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public File getEffectiveUserSettingsIoFile() {
        return MavenWslUtil.getUserSettings(this.myProject, this.getUserSettingsFile(), this.getMavenConfig());
    }

    @Deprecated
    @Nullable
    public File getEffectiveGlobalSettingsIoFile() {
        return MavenWslUtil.getGlobalSettings(this.myProject, this.getMavenHome(), this.getMavenConfig());
    }

    @Deprecated
    @Nullable
    public VirtualFile getEffectiveUserSettingsFile() {
        File file = this.getEffectiveUserSettingsIoFile();
        return file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    @Deprecated
    public List<VirtualFile> getEffectiveSettingsFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(2);
        VirtualFile file = this.getEffectiveUserSettingsFile();
        if (file != null) {
            result2.add(file);
        }
        if ((file = this.getEffectiveGlobalSettingsFile()) != null) {
            result2.add(file);
        }
        return result2;
    }

    @Deprecated
    @Nullable
    public VirtualFile getEffectiveGlobalSettingsFile() {
        File file = this.getEffectiveGlobalSettingsIoFile();
        return file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    @NotNull
    public String getLocalRepository() {
        String string = this.overriddenLocalRepository;
        if (string == null) {
            MavenGeneralSettings.$$$reportNull$$$0(9);
        }
        return string;
    }

    public void setLocalRepository(@Nullable String overriddenLocalRepository) {
        if (overriddenLocalRepository == null) {
            return;
        }
        if (!Objects.equals(this.overriddenLocalRepository, overriddenLocalRepository)) {
            this.overriddenLocalRepository = overriddenLocalRepository;
            if (this.myProject != null) {
                MavenUtil.restartMavenConnectors(this.myProject, false);
            }
            this.changed();
        }
    }

    @Deprecated(forRemoval=true)
    public File getEffectiveLocalRepository() {
        File result2 = this.myEffectiveLocalRepositoryCache;
        if (result2 != null) {
            return result2;
        }
        this.myEffectiveLocalRepositoryCache = result2 = MavenWslUtil.getLocalRepo(this.myProject, this.overriddenLocalRepository, this.mavenHome, this.mavenSettingsFile, this.getMavenConfig());
        return result2;
    }

    @Deprecated
    @Nullable
    public VirtualFile getEffectiveSuperPom() {
        VirtualFile result2 = this.myEffectiveSuperPomCache;
        if (result2 != null && result2.isValid()) {
            return result2;
        }
        this.myEffectiveSuperPomCache = result2 = MavenUtil.resolveSuperPomFile(this.getEffectiveMavenHome());
        return result2;
    }

    public boolean isDefaultPlugin(String groupId, String artifactId) {
        return this.getDefaultPlugins().contains(groupId + ":" + artifactId);
    }

    private Set<String> getDefaultPlugins() {
        Set<String> result2 = this.myDefaultPluginsCache;
        if (result2 != null) {
            return result2;
        }
        result2 = new HashSet<String>();
        VirtualFile effectiveSuperPom = this.getEffectiveSuperPom();
        if (effectiveSuperPom != null) {
            Element superProject = MavenJDOMUtil.read(effectiveSuperPom, null);
            for (Element each : MavenJDOMUtil.findChildrenByPath(superProject, "build.pluginManagement.plugins", "plugin")) {
                String groupId = MavenJDOMUtil.findChildValueByPath(each, "groupId", "org.apache.maven.plugins");
                String artifactId = MavenJDOMUtil.findChildValueByPath(each, "artifactId", null);
                result2.add(groupId + ":" + artifactId);
            }
        }
        this.myDefaultPluginsCache = result2;
        return result2;
    }

    public boolean isPrintErrorStackTraces() {
        return this.printErrorStackTraces;
    }

    public void setPrintErrorStackTraces(boolean value) {
        if (!Comparing.equal((Object)this.printErrorStackTraces, (Object)value)) {
            this.printErrorStackTraces = value;
            this.changed();
        }
    }

    public boolean isUsePluginRegistry() {
        return this.usePluginRegistry;
    }

    public void setUsePluginRegistry(boolean value) {
        if (!Comparing.equal((Object)this.usePluginRegistry, (Object)value)) {
            this.usePluginRegistry = value;
            this.changed();
        }
    }

    public boolean isUseMavenConfig() {
        return this.useMavenConfig;
    }

    public void setUseMavenConfig(boolean value) {
        if (!Comparing.equal((Object)this.useMavenConfig, (Object)value)) {
            this.useMavenConfig = value;
            this.changed();
        }
    }

    public boolean isAlwaysUpdateSnapshots() {
        return this.alwaysUpdateSnapshots;
    }

    public void setAlwaysUpdateSnapshots(boolean value) {
        if (!Comparing.equal((Object)this.alwaysUpdateSnapshots, (Object)value)) {
            this.alwaysUpdateSnapshots = value;
            this.changed();
        }
    }

    public boolean isShowDialogWithAdvancedSettings() {
        return this.showDialogWithAdvancedSettings;
    }

    public void setShowDialogWithAdvancedSettings(boolean value) {
        if (!Comparing.equal((Object)this.showDialogWithAdvancedSettings, (Object)value)) {
            this.showDialogWithAdvancedSettings = value;
            this.changed();
        }
    }

    public boolean isNonRecursive() {
        return this.nonRecursive;
    }

    public void setNonRecursive(boolean value) {
        if (!Comparing.equal((Object)this.nonRecursive, (Object)value)) {
            this.nonRecursive = value;
            this.changed();
        }
    }

    @Nullable
    public String getThreads() {
        return this.threads;
    }

    public void setThreads(@Nullable String value) {
        String nullizeValue = StringUtil.nullize((String)value);
        if (!Objects.equals(this.threads, nullizeValue)) {
            this.threads = nullizeValue;
            this.changed();
        }
    }

    public boolean isEmulateTerminal() {
        return this.emulateTerminal;
    }

    public void setEmulateTerminal(boolean emulateTerminal) {
        if (!Comparing.equal((Object)this.emulateTerminal, (Object)emulateTerminal)) {
            this.emulateTerminal = emulateTerminal;
            this.changed();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenGeneralSettings that = (MavenGeneralSettings)o;
        if (this.nonRecursive != that.nonRecursive) {
            return false;
        }
        if (this.outputLevel != that.outputLevel) {
            return false;
        }
        if (this.alwaysUpdateSnapshots != that.alwaysUpdateSnapshots) {
            return false;
        }
        if (this.showDialogWithAdvancedSettings != that.showDialogWithAdvancedSettings) {
            return false;
        }
        if (this.printErrorStackTraces != that.printErrorStackTraces) {
            return false;
        }
        if (this.usePluginRegistry != that.usePluginRegistry) {
            return false;
        }
        if (this.useMavenConfig != that.useMavenConfig) {
            return false;
        }
        if (this.workOffline != that.workOffline) {
            return false;
        }
        if (!this.checksumPolicy.equals((Object)that.checksumPolicy)) {
            return false;
        }
        if (!this.failureBehavior.equals((Object)that.failureBehavior)) {
            return false;
        }
        if (!this.overriddenLocalRepository.equals(that.overriddenLocalRepository)) {
            return false;
        }
        if (!this.mavenHome.equals(that.mavenHome)) {
            return false;
        }
        if (!this.mavenSettingsFile.equals(that.mavenSettingsFile)) {
            return false;
        }
        if (!Objects.equals(this.threads, that.threads)) {
            return false;
        }
        return this.emulateTerminal == that.emulateTerminal;
    }

    public int hashCode() {
        int result2 = this.workOffline ? 1 : 0;
        result2 = 31 * result2 + this.mavenHome.hashCode();
        result2 = 31 * result2 + this.mavenSettingsFile.hashCode();
        result2 = 31 * result2 + this.overriddenLocalRepository.hashCode();
        result2 = 31 * result2 + (this.printErrorStackTraces ? 1 : 0);
        result2 = 31 * result2 + (this.usePluginRegistry ? 1 : 0);
        result2 = 31 * result2 + (this.useMavenConfig ? 1 : 0);
        result2 = 31 * result2 + (this.nonRecursive ? 1 : 0);
        result2 = 31 * result2 + this.outputLevel.hashCode();
        result2 = 31 * result2 + this.checksumPolicy.hashCode();
        result2 = 31 * result2 + this.failureBehavior.hashCode();
        result2 = 31 * result2 + (this.emulateTerminal ? 1 : 0);
        return result2;
    }

    public MavenGeneralSettings clone() {
        try {
            MavenGeneralSettings result2 = (MavenGeneralSettings)super.clone();
            result2.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            result2.myBulkUpdateLevel = 0;
            result2.setProject(this.myProject);
            return result2;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void addListener(Listener l, Disposable parentDisposable) {
        this.addListener(l);
        Disposer.register((Disposable)parentDisposable, () -> this.removeListener(l));
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void removeListener(Listener l) {
        this.myListeners.remove(l);
    }

    public void copyListeners(MavenGeneralSettings another) {
        this.myListeners.addAll(another.myListeners);
    }

    @Transient
    public void updateFromMavenConfig(@NotNull List<VirtualFile> mavenRootProjects) {
        MavenConfig config;
        if (mavenRootProjects == null) {
            MavenGeneralSettings.$$$reportNull$$$0(10);
        }
        if (mavenRootProjects.isEmpty() || !this.useMavenConfig) {
            return;
        }
        this.mavenConfigCache = null;
        VirtualFile file = mavenRootProjects.get(0);
        this.mavenConfigCache = config = MavenConfigParser.parse(file.isDirectory() ? file.getPath() : file.getParent().getPath());
        if (config == null) {
            return;
        }
        MavenExecutionOptions.ChecksumPolicy checksumConfig = Objects.requireNonNullElse(config.getChecksumPolicy(), MavenExecutionOptions.ChecksumPolicy.NOT_SET);
        boolean needUpdate = !Objects.equals((Object)checksumConfig, (Object)this.checksumPolicy);
        this.checksumPolicy = checksumConfig;
        MavenExecutionOptions.FailureMode failureBehaviorConfig = Objects.requireNonNullElse(config.getFailureMode(), MavenExecutionOptions.FailureMode.NOT_SET);
        needUpdate = needUpdate || !Objects.equals((Object)this.failureBehavior, (Object)failureBehaviorConfig);
        this.failureBehavior = failureBehaviorConfig;
        MavenExecutionOptions.LoggingLevel outputLevelConfig = Objects.requireNonNullElse(config.getOutputLevel(), MavenExecutionOptions.LoggingLevel.INFO);
        needUpdate = needUpdate || !Objects.equals((Object)this.outputLevel, (Object)outputLevelConfig);
        this.outputLevel = outputLevelConfig;
        Boolean offlineConfig = config.hasOption(MavenConfigSettings.OFFLINE);
        needUpdate = needUpdate || !Objects.equals(this.workOffline, offlineConfig);
        this.workOffline = offlineConfig;
        Boolean stackTracesConfig = config.hasOption(MavenConfigSettings.ERRORS);
        needUpdate = needUpdate || !Objects.equals(this.printErrorStackTraces, stackTracesConfig);
        this.printErrorStackTraces = stackTracesConfig;
        Boolean updateSnapshotsConfig = config.hasOption(MavenConfigSettings.UPDATE_SNAPSHOTS);
        needUpdate = needUpdate || !Objects.equals(this.alwaysUpdateSnapshots, updateSnapshotsConfig);
        this.alwaysUpdateSnapshots = updateSnapshotsConfig;
        Boolean nonRecursiveConfig = config.hasOption(MavenConfigSettings.NON_RECURSIVE);
        needUpdate = needUpdate || !Objects.equals(this.nonRecursive, nonRecursiveConfig);
        this.nonRecursive = nonRecursiveConfig;
        String threadsConfig = StringUtil.nullize((String)config.getOptionValue(MavenConfigSettings.THREADS));
        needUpdate = needUpdate || !Objects.equals(StringUtil.nullize((String)this.threads), threadsConfig);
        this.threads = threadsConfig;
        if (needUpdate) {
            this.changed(false);
        }
        this.mavenConfigCache = config;
    }

    @Transient
    public MavenConfig getMavenConfig() {
        MavenProjectsManager instance;
        if (!this.useMavenConfig) {
            return null;
        }
        if (this.mavenConfigCache != null) {
            return this.mavenConfigCache;
        }
        MavenProjectsManager mavenProjectsManager = instance = this.myProject != null ? MavenProjectsManager.getInstance(this.myProject) : null;
        if (instance == null) {
            return null;
        }
        List<VirtualFile> files2 = MavenUtil.collectFiles(instance.getRootProjects());
        if (files2.isEmpty()) {
            files2 = instance.getProjectsTree().getExistingManagedFiles();
        }
        this.updateFromMavenConfig(files2);
        return this.mavenConfigCache;
    }

    private void fireChanged() {
        for (Listener each : this.myListeners) {
            each.changed();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 5, 6, 7, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenGeneralSettings";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenHome";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenRootProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChecksumPolicy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailureBehavior";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggingLevel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputLevel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenHome";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenGeneralSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserSettingsFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepository";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setMavenHome";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setMavenHomeNoFire";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateFromMavenConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 5, 6, 7, 10 -> new IllegalArgumentException(string);
        };
    }

    public static interface Listener {
        public void changed();
    }
}

