/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.maven3;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.roots.ui.distribution.DistributionInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.MavenVersionAwareSupportExtension;
import org.jetbrains.idea.maven.maven3.Bundled3DistributionInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.server.MavenServer;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.intellij.build.dependencies.BuildDependenciesCommunityRoot;
import org.jetbrains.intellij.build.impl.BundledMavenDownloader;

final class Maven3Support
implements MavenVersionAwareSupportExtension {
    Maven3Support() {
    }

    @Override
    public boolean isSupportedByExtension(@Nullable File mavenHome) {
        String version2 = MavenUtil.getMavenVersion(mavenHome);
        return StringUtil.compareVersionNumbers((String)version2, (String)"3") >= 0 && StringUtil.compareVersionNumbers((String)version2, (String)"4") < 0;
    }

    @Override
    @Nullable
    public File getMavenHomeFile(@Nullable String mavenHome) {
        if (mavenHome == null) {
            return null;
        }
        if (StringUtil.equals((CharSequence)"Bundled (Maven 3)", (CharSequence)mavenHome) || StringUtil.equals((CharSequence)MavenProjectBundle.message("maven.bundled.version.3.title", new Object[0]), (CharSequence)mavenHome)) {
            return MavenDistributionsCache.resolveEmbeddedMavenHome().getMavenHome().toFile();
        }
        return null;
    }

    @Override
    @Nullable
    public String asMavenHome(DistributionInfo distribution) {
        if (distribution instanceof Bundled3DistributionInfo) {
            return "Bundled (Maven 3)";
        }
        return null;
    }

    @Override
    @Nullable
    public DistributionInfo asDistributionInfo(String mavenHome) {
        if (StringUtil.equals((CharSequence)"Bundled (Maven 3)", (CharSequence)mavenHome)) {
            return new Bundled3DistributionInfo(MavenDistributionsCache.resolveEmbeddedMavenHome().getVersion());
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> supportedBundles() {
        List<String> list = Collections.singletonList("Bundled (Maven 3)");
        if (list == null) {
            Maven3Support.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public List<File> collectClassPathAndLibsFolder(@NotNull MavenDistribution distribution) {
        if (distribution == null) {
            Maven3Support.$$$reportNull$$$0(1);
        }
        File pluginFileOrDir = new File(PathUtil.getJarPathForClass(MavenServerManager.class));
        String root = pluginFileOrDir.getParent();
        ArrayList<File> classpath = new ArrayList<File>();
        if (pluginFileOrDir.isDirectory()) {
            MavenLog.LOG.debug("collecting classpath for local run");
            Maven3Support.prepareClassPathForLocalRunAndUnitTests(distribution.getVersion(), classpath, root);
        } else {
            MavenLog.LOG.debug("collecting classpath for production");
            Maven3Support.prepareClassPathForProduction(distribution.getVersion(), classpath, root);
        }
        Maven3Support.addMavenLibs(classpath, distribution.getMavenHome().toFile());
        MavenLog.LOG.debug("Collected classpath = ", new Object[]{classpath});
        ArrayList<File> arrayList = classpath;
        if (arrayList == null) {
            Maven3Support.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static void prepareClassPathForProduction(@NotNull String mavenVersion, List<File> classpath, String root) {
        if (mavenVersion == null) {
            Maven3Support.$$$reportNull$$$0(3);
        }
        classpath.add(new File(PathUtil.getJarPathForClass(MavenId.class)));
        classpath.add(new File(PathUtil.getJarPathForClass(MavenServer.class)));
        classpath.add(new File(root, "maven3-server-common.jar"));
        Maven3Support.addDir(classpath, new File(root, "maven3-server-lib"), f -> true);
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.1") < 0) {
            classpath.add(new File(root, "maven30-server.jar"));
        } else {
            classpath.add(new File(root, "maven3-server.jar"));
            if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
                classpath.add(new File(root, "maven36-server.jar"));
            }
        }
    }

    private static void prepareClassPathForLocalRunAndUnitTests(@NotNull String mavenVersion, List<File> classpath, String root) {
        if (mavenVersion == null) {
            Maven3Support.$$$reportNull$$$0(4);
        }
        BuildDependenciesCommunityRoot communityRoot = new BuildDependenciesCommunityRoot(Path.of(PathManager.getCommunityHomePath(), new String[0]));
        BundledMavenDownloader.INSTANCE.downloadMaven3LibsSync(communityRoot);
        classpath.add(new File(PathUtil.getJarPathForClass(MavenId.class)));
        classpath.add(new File(root, "intellij.maven.server"));
        File parentFile = MavenUtil.getMavenPluginParentFile();
        classpath.add(new File(root, "intellij.maven.server.m3.common"));
        Maven3Support.addDir(classpath, new File(parentFile, "maven3-server-common/lib"), f -> true);
        if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.1") < 0) {
            classpath.add(new File(root, "intellij.maven.server.m30.impl"));
        } else {
            classpath.add(new File(root, "intellij.maven.server.m3.impl"));
            if (StringUtil.compareVersionNumbers((String)mavenVersion, (String)"3.6") >= 0) {
                classpath.add(new File(root, "intellij.maven.server.m36.impl"));
            }
        }
    }

    private static void addMavenLibs(List<File> classpath, File mavenHome) {
        Maven3Support.addDir(classpath, new File(mavenHome, "lib"), f -> !f.getName().contains("maven-slf4j-provider"));
        File bootFolder = new File(mavenHome, "boot");
        File[] classworldsJars = bootFolder.listFiles((dir2, name) -> StringUtil.contains((CharSequence)name, (CharSequence)"classworlds"));
        if (classworldsJars != null) {
            Collections.addAll(classpath, classworldsJars);
        }
    }

    private static void addDir(List<File> classpath, File dir2, Predicate<File> filter) {
        File[] files2 = dir2.listFiles();
        if (files2 == null) {
            return;
        }
        for (File jar : files2) {
            if (!jar.isFile() || !jar.getName().endsWith(".jar") || !filter.test(jar)) continue;
            classpath.add(jar);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/maven3/Maven3Support";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distribution";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "supportedBundles";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/maven3/Maven3Support";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassPathAndLibsFolder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPathAndLibsFolder";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForProduction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "prepareClassPathForLocalRunAndUnitTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

