/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.workspace.jps.serialization.impl.ModulePath;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.maven.importing.MavenLegacyModuleImporter;
import org.jetbrains.idea.maven.importing.MavenModuleNameMapper;
import org.jetbrains.idea.maven.importing.MavenProjectImporterLegacyBase;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterLegacyImpl;
import org.jetbrains.idea.maven.importing.StandardMavenModuleType;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenModelsProvider;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.statistics.MavenImportCollector;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@ApiStatus.Internal
@ApiStatus.Obsolete
public class MavenProjectLegacyImporter
extends MavenProjectImporterLegacyBase {
    private static final Logger LOG = Logger.getInstance(MavenProjectLegacyImporter.class);
    private final Map<VirtualFile, Module> myFileToModuleMapping;
    private volatile Set<MavenProject> myAllProjects;
    private final boolean myImportModuleGroupsRequired;
    private Module myPreviewModule;
    private final List<Module> myCreatedModules;
    private final Map<MavenProject, Module> myMavenProjectToModule;
    private final Map<MavenProject, String> myMavenProjectToModuleName;
    private final Map<MavenProject, String> myMavenProjectToModulePath;
    private static Boolean answerToDeleteObsoleteModulesQuestion = null;

    MavenProjectLegacyImporter(@NotNull Project p, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges, boolean importModuleGroupsRequired, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull MavenImportingSettings importingSettings, @Nullable Module previewModule) {
        if (p == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(0);
        }
        if (projectsTree == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(1);
        }
        if (projectsToImportWithChanges == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(3);
        }
        if (importingSettings == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(4);
        }
        super(p, projectsTree, importingSettings, projectsToImportWithChanges, modelsProvider);
        this.myCreatedModules = new ArrayList<Module>();
        this.myMavenProjectToModule = new HashMap<MavenProject, Module>();
        this.myMavenProjectToModuleName = new HashMap<MavenProject, String>();
        this.myMavenProjectToModulePath = new HashMap<MavenProject, String>();
        this.myFileToModuleMapping = MavenProjectLegacyImporter.getFileToModuleMapping(p, previewModule, modelsProvider);
        this.myImportModuleGroupsRequired = importModuleGroupsRequired;
        this.myPreviewModule = previewModule;
    }

    @Override
    @Nullable
    public List<MavenProjectsProcessorTask> importProject() {
        MavenLog.LOG.info("Importing Maven project using Legacy API");
        ArrayList<MavenProjectsProcessorTask> postTasks = new ArrayList<MavenProjectsProcessorTask>();
        StructuredIdeActivity activity2 = MavenImportCollector.LEGACY_IMPORT.started(this.myProject);
        this.myAllProjects = new LinkedHashSet<MavenProject>(this.myProjectsTree.getProjects());
        this.myAllProjects.addAll(this.myProjectsToImportWithChanges.keySet());
        boolean hasChanges = this.deleteIncompatibleModules();
        this.myProjectsToImportWithChanges = this.collectProjectsToImport(this.myProjectsToImportWithChanges);
        this.mapMavenProjectsToModulesAndNames();
        if (this.myProject.isDisposed()) {
            return null;
        }
        boolean projectsHaveChanges = this.projectsToImportHaveChanges(this.myProjectsToImportWithChanges.values());
        ArrayList<MavenLegacyModuleImporter.ExtensionImporter> extensionImporters = new ArrayList<MavenLegacyModuleImporter.ExtensionImporter>();
        if (projectsHaveChanges) {
            hasChanges = true;
            StructuredIdeActivity createModulesPhase = MavenImportCollector.LEGACY_CREATE_MODULES_PHASE.startedWithParent(this.myProject, activity2);
            extensionImporters.addAll(this.importModules());
            MavenProjectLegacyImporter.scheduleRefreshResolvedArtifacts(postTasks, this.myProjectsToImportWithChanges.keySet());
            createModulesPhase.finished();
        }
        if (projectsHaveChanges || this.myImportModuleGroupsRequired) {
            hasChanges = true;
            this.configModuleGroups();
        }
        if (this.myProject.isDisposed()) {
            return null;
        }
        List<Module> obsoleteModules = this.collectObsoleteModules();
        boolean isDeleteObsoleteModules = this.isDeleteObsoleteModules(obsoleteModules);
        if (hasChanges |= isDeleteObsoleteModules) {
            StructuredIdeActivity deleteObsoletePhase = MavenImportCollector.LEGACY_DELETE_OBSOLETE_PHASE.startedWithParent(this.myProject, activity2);
            MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
                this.setMavenizedModules(obsoleteModules, false);
                ArrayList<Module> toDelete = new ArrayList<Module>();
                if (this.myPreviewModule != null) {
                    toDelete.add(this.myPreviewModule);
                    this.myPreviewModule = null;
                }
                if (isDeleteObsoleteModules) {
                    toDelete.addAll(obsoleteModules);
                }
                this.deleteModules(toDelete);
                this.removeUnusedProjectLibraries();
                this.myModelsProvider.commit();
                if (projectsHaveChanges) {
                    MavenProjectLegacyImporter.removeOutdatedCompilerConfigSettings(this.myProject);
                }
                if (projectsHaveChanges) {
                    this.setMavenizedModules(ContainerUtil.map(this.myProjectsToImportWithChanges.keySet(), this.myMavenProjectToModule::get), true);
                }
            }));
            deleteObsoletePhase.finished();
            StructuredIdeActivity importersPhase = MavenImportCollector.LEGACY_IMPORTERS_PHASE.startedWithParent(this.myProject, activity2);
            MavenProjectLegacyImporter.importExtensions(this.myProject, this.myIdeModifiableModelsProvider, extensionImporters, postTasks, importersPhase);
            importersPhase.finished();
        } else {
            this.finalizeImport(obsoleteModules);
        }
        activity2.finished(() -> List.of(MavenImportCollector.NUMBER_OF_MODULES.with((Object)this.myMavenProjectToModule.size())));
        return postTasks;
    }

    protected boolean projectsToImportHaveChanges(Collection<MavenProjectChanges> changes) {
        for (MavenProjectChanges each : changes) {
            if (!each.hasChanges()) continue;
            return true;
        }
        return false;
    }

    private Map<MavenProject, MavenProjectChanges> collectProjectsToImport(Map<MavenProject, MavenProjectChanges> projectsToImport) {
        HashMap<MavenProject, MavenProjectChanges> result2 = new HashMap<MavenProject, MavenProjectChanges>(projectsToImport);
        result2.putAll(this.collectNewlyCreatedProjects());
        Set allProjectsToImport = result2.keySet();
        Set<MavenProject> selectedProjectsToImport = this.selectProjectsToImport(allProjectsToImport);
        Iterator it = allProjectsToImport.iterator();
        while (it.hasNext()) {
            if (selectedProjectsToImport.contains(it.next())) continue;
            it.remove();
        }
        return result2;
    }

    private Map<MavenProject, MavenProjectChanges> collectNewlyCreatedProjects() {
        HashMap<MavenProject, MavenProjectChanges> result2 = new HashMap<MavenProject, MavenProjectChanges>();
        for (MavenProject each : this.myAllProjects) {
            Module module2 = this.myFileToModuleMapping.get(each.getFile());
            if (module2 != null) continue;
            result2.put(each, MavenProjectChanges.ALL);
        }
        return result2;
    }

    private boolean deleteIncompatibleModules() {
        Pair<List<Pair<MavenProject, Module>>, List<Pair<MavenProject, Module>>> incompatible = this.collectIncompatibleModulesWithProjects();
        List incompatibleMavenized = (List)incompatible.first;
        List incompatibleNotMavenized = (List)incompatible.second;
        if (incompatibleMavenized.isEmpty() && incompatibleNotMavenized.isEmpty()) {
            return false;
        }
        boolean changed = false;
        for (Pair each : incompatibleMavenized) {
            this.myFileToModuleMapping.remove(((MavenProject)each.first).getFile());
            this.myModuleModel.disposeModule((Module)each.second);
            changed = true;
        }
        if (incompatibleNotMavenized.isEmpty()) {
            return changed;
        }
        int[] result2 = new int[]{0};
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            MavenUtil.invokeAndWait(this.myProject, this.myModelsProvider.getModalityStateForQuestionDialogs(), () -> {
                String message = MavenProjectBundle.message("maven.import.incompatible.modules", incompatibleNotMavenized.size(), MavenProjectLegacyImporter.formatProjectsWithModules(incompatibleNotMavenized));
                String[] options = new String[]{MavenProjectBundle.message("maven.import.incompatible.modules.recreate", new Object[0]), MavenProjectBundle.message("maven.import.incompatible.modules.ignore", new Object[0])};
                result2[0] = Messages.showOkCancelDialog((Project)this.myProject, (String)message, (String)MavenProjectBundle.message("maven.project.import.title", new Object[0]), (String)options[0], (String)options[1], (Icon)Messages.getQuestionIcon());
            });
        }
        if (result2[0] == 0) {
            for (Pair each : incompatibleNotMavenized) {
                this.myFileToModuleMapping.remove(((MavenProject)each.first).getFile());
                this.myModuleModel.disposeModule((Module)each.second);
            }
            changed = true;
        } else {
            this.myProjectsTree.setIgnoredState(MavenUtil.collectFirsts(incompatibleNotMavenized), true, true);
        }
        return changed;
    }

    private Pair<List<Pair<MavenProject, Module>>, List<Pair<MavenProject, Module>>> collectIncompatibleModulesWithProjects() {
        ArrayList<Pair> incompatibleMavenized = new ArrayList<Pair>();
        ArrayList incompatibleNotMavenized = new ArrayList();
        for (MavenProject each : this.myAllProjects) {
            Module module2 = this.myFileToModuleMapping.get(each.getFile());
            if (module2 == null || !this.shouldCreateModuleFor(each) || ModuleType.get((Module)module2).equals(each.getModuleType())) continue;
            (MavenUtil.isMavenizedModule(module2) ? incompatibleMavenized : incompatibleNotMavenized).add(Pair.create((Object)each, (Object)module2));
        }
        return Pair.create(incompatibleMavenized, incompatibleNotMavenized);
    }

    private static String formatProjectsWithModules(List<Pair<MavenProject, Module>> projectsWithModules) {
        return StringUtil.join(projectsWithModules, each -> {
            MavenProject project2 = (MavenProject)each.first;
            Module module2 = (Module)each.second;
            return ModuleType.get((Module)module2).getName() + " '" + module2.getName() + "' for Maven project " + project2.getMavenId().getDisplayString();
        }, (String)"<br>");
    }

    private void deleteModules(@NotNull List<Module> modules) {
        if (modules == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(5);
        }
        for (Module each : modules) {
            if (each.isDisposed()) continue;
            this.myModuleModel.disposeModule(each);
        }
    }

    @TestOnly
    public static void setAnswerToDeleteObsoleteModulesQuestion(boolean answer) {
        answerToDeleteObsoleteModulesQuestion = answer;
    }

    @TestOnly
    public static Boolean getAnswerToDeleteObsoleteModulesQuestion() {
        return answerToDeleteObsoleteModulesQuestion;
    }

    private boolean isDeleteObsoleteModules(@NotNull List<Module> obsoleteModules) {
        if (obsoleteModules == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(6);
        }
        if (obsoleteModules.isEmpty()) {
            return false;
        }
        String message = MavenProjectBundle.message("maven.import.message.delete.obsolete", MavenProjectLegacyImporter.formatModules(obsoleteModules));
        MavenLog.LOG.warn("Asking about deleting obsolete modules. " + message);
        if (null != answerToDeleteObsoleteModulesQuestion) {
            Boolean delete = answerToDeleteObsoleteModulesQuestion;
            MavenLog.LOG.warn("This should only happen in tests. Delete obsolete modules: " + delete);
            answerToDeleteObsoleteModulesQuestion = null;
            return delete;
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() || MavenUtil.isMavenUnitTestModeEnabled()) {
            int[] result2 = new int[1];
            MavenUtil.invokeAndWait(this.myProject, this.myModelsProvider.getModalityStateForQuestionDialogs(), () -> {
                result2[0] = Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)MavenProjectBundle.message("maven.project.import.title", new Object[0]), (Icon)Messages.getQuestionIcon());
            });
            if (result2[0] == 1) {
                return false;
            }
        }
        return true;
    }

    private List<Module> collectObsoleteModules() {
        ArrayList remainingModules = new ArrayList();
        Collections.addAll(remainingModules, this.myModuleModel.getModules());
        for (MavenProject each : this.selectProjectsToImport(this.myAllProjects)) {
            remainingModules.remove(this.myMavenProjectToModule.get(each));
        }
        ArrayList<Module> obsolete = new ArrayList<Module>();
        MavenProjectsManager manager = MavenProjectsManager.getInstance(this.myProject);
        for (Module each : remainingModules) {
            if (!manager.isMavenizedModule(each) || this.myPreviewModule == each) continue;
            obsolete.add(each);
        }
        return obsolete;
    }

    private static String formatModules(Collection<Module> modules) {
        StringBuilder res = new StringBuilder();
        int i2 = 0;
        for (Module module2 : modules) {
            res.append('\'').append(module2.getName()).append("'\n");
            if (++i2 <= 20) continue;
            break;
        }
        if (i2 > 20) {
            res.append("\n ... and other ").append(modules.size() - 20).append(" modules");
        }
        return res.toString();
    }

    private void mapMavenProjectsToModulesAndNames() {
        for (MavenProject each : this.myAllProjects) {
            Module module2 = this.myFileToModuleMapping.get(each.getFile());
            if (module2 == null) continue;
            this.myMavenProjectToModule.put(each, module2);
        }
        MavenModuleNameMapper.map(this.myAllProjects, this.myMavenProjectToModule, this.myMavenProjectToModuleName, this.myMavenProjectToModulePath, this.myImportingSettings.getDedicatedModuleDir());
    }

    private List<MavenLegacyModuleImporter.ExtensionImporter> importModules() {
        Map projectsWithChanges2 = this.myProjectsToImportWithChanges;
        HashSet<MavenProject> projectsWithNewlyCreatedModules = new HashSet<MavenProject>();
        if (projectsWithChanges2.size() > 0 && null != this.myPreviewModule) {
            this.deleteModules(List.of(this.myPreviewModule));
            this.myPreviewModule = null;
        }
        for (MavenProject each : projectsWithChanges2.keySet()) {
            if (!this.ensureModuleCreated(each)) continue;
            projectsWithNewlyCreatedModules.add(each);
        }
        ArrayList<MavenLegacyModuleImporter.ExtensionImporter> extensionImporters = new ArrayList<MavenLegacyModuleImporter.ExtensionImporter>();
        for (Map.Entry each : projectsWithChanges2.entrySet()) {
            MavenProject project2 = (MavenProject)each.getKey();
            Module module2 = this.myMavenProjectToModule.get(project2);
            boolean isNewModule = projectsWithNewlyCreatedModules.contains(project2);
            MavenId mavenId = project2.getMavenId();
            this.myModelsProvider.registerModulePublication(module2, (ProjectCoordinate)new ProjectId(mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion()));
            MavenLegacyModuleImporter moduleImporter = this.createModuleImporter(module2, project2, (MavenProjectChanges)each.getValue());
            ContainerUtil.addIfNotNull(extensionImporters, (Object)this.createExtensionImporterIfApplicable(project2, module2, (MavenProjectChanges)each.getValue()));
            MavenRootModelAdapter rootModelAdapter = new MavenRootModelAdapter(new MavenRootModelAdapterLegacyImpl(project2, module2, this.myModelsProvider));
            rootModelAdapter.init(isNewModule);
            moduleImporter.config(rootModelAdapter);
        }
        for (MavenProject project3 : this.myAllProjects) {
            Module module3;
            if (projectsWithChanges2.containsKey(project3) || (module3 = this.myMavenProjectToModule.get(project3)) == null) continue;
            ContainerUtil.addIfNotNull(extensionImporters, (Object)this.createExtensionImporterIfApplicable(project3, module3, MavenProjectChanges.NONE));
        }
        return extensionImporters;
    }

    private boolean ensureModuleCreated(MavenProject project2) {
        Module existingModule = this.myMavenProjectToModule.get(project2);
        if (existingModule != null && existingModule != this.myPreviewModule) {
            this.myCreatedModules.add(existingModule);
            return false;
        }
        String path = this.myMavenProjectToModulePath.get(project2);
        String moduleName = ModulePath.Companion.getModuleNameByFilePath(path);
        this.deleteExistingImlFile(path);
        this.deleteExistingModuleByName(moduleName);
        Module module2 = this.myModuleModel.newModule(path, project2.getModuleType().getId());
        this.myMavenProjectToModule.put(project2, module2);
        this.myCreatedModules.add(module2);
        return true;
    }

    private void deleteExistingModuleByName(String name) {
        Module module2 = this.myModuleModel.findModuleByName(name);
        if (module2 != null) {
            this.myModuleModel.disposeModule(module2);
        }
    }

    private void deleteExistingImlFile(final String path) {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, new Runnable(){

            @Override
            public void run() {
                try {
                    VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                    if (file != null) {
                        file.delete((Object)this);
                    }
                }
                catch (IOException e) {
                    MavenLog.LOG.warn("Cannot delete existing iml file: " + path, (Throwable)e);
                }
            }
        });
    }

    private MavenLegacyModuleImporter createModuleImporter(@NotNull Module module2, @NotNull MavenProject mavenProject2, @NotNull MavenProjectChanges changes) {
        if (module2 == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(7);
        }
        if (mavenProject2 == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(8);
        }
        if (changes == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(9);
        }
        return new MavenLegacyModuleImporter(module2, this.myProjectsTree, mavenProject2, this.myMavenProjectToModuleName, this.myImportingSettings, this.myModelsProvider);
    }

    @Nullable
    private MavenLegacyModuleImporter.ExtensionImporter createExtensionImporterIfApplicable(@NotNull MavenProject mavenProject2, @NotNull Module module2, @NotNull MavenProjectChanges changes) {
        if (mavenProject2 == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(10);
        }
        if (module2 == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(11);
        }
        if (changes == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(12);
        }
        return MavenLegacyModuleImporter.ExtensionImporter.createIfApplicable(mavenProject2, module2, mavenProject2.isAggregator() ? StandardMavenModuleType.AGGREGATOR : StandardMavenModuleType.SINGLE_MODULE, this.myProjectsTree, changes, this.myMavenProjectToModuleName, false);
    }

    private void configModuleGroups() {
        if (!this.myImportingSettings.isCreateModuleGroups()) {
            return;
        }
        final Stack groups = new Stack();
        final boolean createTopLevelGroup = this.myProjectsTree.getRootProjects().size() > 1;
        this.myProjectsTree.visit(new MavenProjectsTree.SimpleVisitor(){
            int depth = 0;

            @Override
            public boolean shouldVisit(MavenProject project2) {
                return MavenProjectLegacyImporter.this.myMavenProjectToModuleName.containsKey(project2);
            }

            @Override
            public void visit(MavenProject each) {
                ++this.depth;
                String name = MavenProjectLegacyImporter.this.myMavenProjectToModuleName.get(each);
                if (this.shouldCreateGroup(each)) {
                    groups.push((Object)MavenProjectBundle.message("module.group.name", name));
                }
                if (!MavenProjectLegacyImporter.this.shouldCreateModuleFor(each)) {
                    return;
                }
                Module module2 = MavenProjectLegacyImporter.this.myModuleModel.findModuleByName(name);
                if (module2 == null) {
                    return;
                }
                MavenProjectLegacyImporter.this.myModuleModel.setModuleGroupPath(module2, groups.isEmpty() ? null : ArrayUtilRt.toStringArray((Collection)groups));
            }

            @Override
            public void leave(MavenProject each) {
                if (this.shouldCreateGroup(each)) {
                    groups.pop();
                }
                --this.depth;
            }

            private boolean shouldCreateGroup(MavenProject project2) {
                return !MavenProjectLegacyImporter.this.myProjectsTree.getModules(project2).isEmpty() && (createTopLevelGroup || this.depth > 1);
            }
        });
    }

    private boolean removeUnusedProjectLibraries() {
        HashSet unusedLibraries = new HashSet();
        Collections.addAll(unusedLibraries, this.myModelsProvider.getAllLibraries());
        for (ModuleRootModel eachModel : this.collectModuleModels()) {
            for (OrderEntry eachEntry : eachModel.getOrderEntries()) {
                if (!(eachEntry instanceof LibraryOrderEntry)) continue;
                unusedLibraries.remove(((LibraryOrderEntry)eachEntry).getLibrary());
            }
        }
        boolean removed = false;
        for (Library each : unusedLibraries) {
            if (MavenProjectLegacyImporter.isDisposed(each) || !MavenRootModelAdapter.isMavenLibrary(each)) continue;
            if (!MavenRootModelAdapter.isChangedByUser(each)) {
                this.myModelsProvider.removeLibrary(each);
                removed = true;
                continue;
            }
            MavenImportCollector.HAS_USER_MODIFIED_IMPORTED_LIBRARY.log(this.myProject);
        }
        return removed;
    }

    private static boolean isDisposed(Library library) {
        return library instanceof LibraryEx && ((LibraryEx)library).isDisposed();
    }

    private Collection<ModuleRootModel> collectModuleModels() {
        HashMap<Module, ModifiableRootModel> rootModels = new HashMap<Module, ModifiableRootModel>();
        for (MavenProject each : this.myProjectsToImportWithChanges.keySet()) {
            Module module2 = this.myMavenProjectToModule.get(each);
            ModifiableRootModel rootModel = this.myModelsProvider.getModifiableRootModel(module2);
            rootModels.put(module2, rootModel);
        }
        for (Module each : this.myModuleModel.getModules()) {
            if (rootModels.containsKey(each)) continue;
            rootModels.put(each, this.myModelsProvider.getModifiableRootModel(each));
        }
        return rootModels.values();
    }

    @Override
    @NotNull
    public List<Module> createdModules() {
        List<Module> list = this.myCreatedModules;
        if (list == null) {
            MavenProjectLegacyImporter.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static Map<VirtualFile, Module> getFileToModuleMapping(Project project2, final Module myPreviewModule, final IdeModifiableModelsProvider modelsProvider) {
        return MavenProjectsManager.getInstance(project2).getFileToModuleMapping(new MavenModelsProvider(){

            @Override
            public Module[] getModules() {
                return (Module[])ArrayUtil.remove((Object[])modelsProvider.getModules(), (Object)myPreviewModule);
            }

            @Override
            public VirtualFile[] getContentRoots(Module module2) {
                return modelsProvider.getContentRoots(module2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsToImportWithChanges";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importingSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obsoleteModules";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenProjectLegacyImporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenProjectLegacyImporter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createdModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteModules";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDeleteObsoleteModules";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createModuleImporter";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createExtensionImporterIfApplicable";
                break;
            }
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13 -> new IllegalStateException(string);
        };
    }
}

