/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.io.URLUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenEncodingConfigurator;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.model.MavenResource;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u001e\u0010\u001d\u001a\u00020\u00062\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/idea/maven/importing/MavenEncodingConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "()V", "PREPARED_MAPPER", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/idea/maven/importing/MavenEncodingConfigurator$EncodingMapper;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "afterModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$AppliedModelContext;", "beforeModelApplied", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "fillResourceEncoding", "project", "Lcom/intellij/openapi/project/Project;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "encodingMapper", "fillSourceEncoding", "getCharset", "Ljava/nio/charset/Charset;", "name", "", "isApplicable", "", "isMigratedToConfigurator", "mapEncodings", "mavenProjects", "Lkotlin/sequences/Sequence;", "postProcess", "module", "Lcom/intellij/openapi/module/Module;", "changes", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "modifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "EncodingMapper", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenEncodingConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenEncodingConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenEncodingConfigurator\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1295#2,2:128\n1#3:130\n1549#4:131\n1620#4,3:132\n1855#4,2:135\n1855#4,2:137\n*S KotlinDebug\n*F\n+ 1 MavenEncodingConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenEncodingConfigurator\n*L\n58#1:128,2\n107#1:131\n107#1:132,3\n107#1:135,2\n114#1:137,2\n*E\n"})
public final class MavenEncodingConfigurator
extends MavenImporter
implements MavenWorkspaceConfigurator {
    @NotNull
    private final Key<EncodingMapper> PREPARED_MAPPER;

    public MavenEncodingConfigurator() {
        super("", "");
        Key key = Key.create((String)"ENCODING_MAPPER");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create<EncodingMapper>(\"ENCODING_MAPPER\")");
        this.PREPARED_MAPPER = key;
    }

    @Override
    public boolean isApplicable(@NotNull MavenProject mavenProject2) {
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        return true;
    }

    @Override
    public boolean isMigratedToConfigurator() {
        return true;
    }

    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Sequence allMavenProjects2 = SequencesKt.map((Sequence)SequencesKt.filter(context2.getMavenProjectsWithModules(), (Function1)beforeModelApplied.allMavenProjects.1.INSTANCE), (Function1)beforeModelApplied.allMavenProjects.2.INSTANCE);
        EncodingMapper mapper = this.mapEncodings((Sequence<? extends MavenProject>)allMavenProjects2, context2.getProject());
        this.PREPARED_MAPPER.set((UserDataHolder)context2, (Object)mapper);
    }

    @Override
    public void afterModelApplied(@NotNull MavenWorkspaceConfigurator.AppliedModelContext context2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            EncodingMapper encodingMapper = (EncodingMapper)this.PREPARED_MAPPER.get((UserDataHolder)context2);
            if (encodingMapper == null) break block0;
            encodingMapper.applyCollectedInfo();
        }
    }

    @Override
    public void postProcess(@NotNull Module module2, @NotNull MavenProject mavenProject2, @NotNull MavenProjectChanges changes, @NotNull IdeModifiableModelsProvider modifiableModelsProvider) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)modifiableModelsProvider, (String)"modifiableModelsProvider");
        Object[] objectArray = new MavenProject[]{mavenProject2};
        Sequence sequence = SequencesKt.sequenceOf((Object[])objectArray);
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        this.mapEncodings((Sequence<? extends MavenProject>)sequence, project2).applyCollectedInfo();
    }

    private final EncodingMapper mapEncodings(Sequence<? extends MavenProject> mavenProjects2, Project project2) {
        EncodingMapper encodingMapper = new EncodingMapper(project2);
        Sequence<? extends MavenProject> $this$forEach$iv = mavenProjects2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MavenProject mavenProject2 = (MavenProject)element$iv;
            boolean bl = false;
            ReadAction.compute(() -> MavenEncodingConfigurator.mapEncodings$lambda$2$lambda$0(this, mavenProject2, encodingMapper));
            ReadAction.compute(() -> MavenEncodingConfigurator.mapEncodings$lambda$2$lambda$1(this, project2, mavenProject2, encodingMapper));
        }
        return encodingMapper;
    }

    /*
     * WARNING - void declaration
     */
    private final void fillResourceEncoding(Project project2, MavenProject mavenProject2, EncodingMapper encodingMapper) {
        block3: {
            Object object = mavenProject2.getResourceEncoding(project2);
            if (object == null) break block3;
            String p0 = object;
            boolean bl = false;
            Charset charset = this.getCharset(p0);
            object = charset;
            if (charset != null) {
                void $this$forEach$iv;
                void $this$mapTo$iv$iv;
                Object charset2 = object;
                boolean bl2 = false;
                List<MavenResource> list = mavenProject2.getResources();
                Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.resources");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    MavenResource mavenResource = (MavenResource)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getDirectory());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    encodingMapper.processDir(it, (Charset)charset2);
                }
            }
        }
    }

    private final void fillSourceEncoding(MavenProject mavenProject2, EncodingMapper encodingMapper) {
        block2: {
            Object object = mavenProject2.getSourceEncoding();
            if (object == null) break block2;
            String p0 = object;
            boolean bl = false;
            Charset charset = this.getCharset(p0);
            object = charset;
            if (charset != null) {
                Object charset2 = object;
                boolean bl2 = false;
                List<String> list = mavenProject2.getSources();
                Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.sources");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    encodingMapper.processDir(it, (Charset)charset2);
                }
            }
        }
    }

    private final Charset getCharset(String name) {
        try {
            return Charset.forName(name);
        }
        catch (UnsupportedCharsetException e) {
            MavenLog.LOG.warn("Charset " + name + " is not supported");
            return null;
        }
    }

    private static final Unit mapEncodings$lambda$2$lambda$0(MavenEncodingConfigurator this$0, MavenProject $mavenProject, EncodingMapper $encodingMapper) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$mavenProject, (String)"$mavenProject");
        Intrinsics.checkNotNullParameter((Object)$encodingMapper, (String)"$encodingMapper");
        this$0.fillSourceEncoding($mavenProject, $encodingMapper);
        return Unit.INSTANCE;
    }

    private static final Unit mapEncodings$lambda$2$lambda$1(MavenEncodingConfigurator this$0, Project $project, MavenProject $mavenProject, EncodingMapper $encodingMapper) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$mavenProject, (String)"$mavenProject");
        Intrinsics.checkNotNullParameter((Object)$encodingMapper, (String)"$encodingMapper");
        this$0.fillResourceEncoding($project, $mavenProject, $encodingMapper);
        return Unit.INSTANCE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\\\u0010\f\u001aP\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\t0\t\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\n0\n \u000e*%\u0012\u000e\b\u0001\u0012\n \u000e*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\n0\n0\u0010\u00a2\u0006\u0002\b\u000f0\r\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenEncodingConfigurator$EncodingMapper;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "encodingManager", "Lcom/intellij/openapi/vfs/encoding/EncodingProjectManagerImpl;", "newPointerMappings", "Ljava/util/LinkedHashMap;", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "Ljava/nio/charset/Charset;", "Lkotlin/collections/LinkedHashMap;", "oldPointerMappings", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "applyCollectedInfo", "", "processDir", "directory", "", "charset", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenEncodingConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenEncodingConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenEncodingConfigurator$EncodingMapper\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,127:1\n43#2,3:128\n43#2,3:131\n215#3,2:134\n*S KotlinDebug\n*F\n+ 1 MavenEncodingConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenEncodingConfigurator$EncodingMapper\n*L\n79#1:128,3\n82#1:131,3\n85#1:134,2\n*E\n"})
    private static final class EncodingMapper {
        @NotNull
        private final LinkedHashMap<VirtualFilePointer, Charset> newPointerMappings;
        @NotNull
        private final EncodingProjectManagerImpl encodingManager;
        @NotNull
        private final Map<? extends VirtualFilePointer, ? extends Charset> oldPointerMappings;

        public EncodingMapper(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            this.newPointerMappings = new LinkedHashMap();
            EncodingProjectManager encodingProjectManager = EncodingProjectManager.getInstance((Project)project2);
            Intrinsics.checkNotNull((Object)encodingProjectManager, (String)"null cannot be cast to non-null type com.intellij.openapi.vfs.encoding.EncodingProjectManagerImpl");
            this.encodingManager = (EncodingProjectManagerImpl)encodingProjectManager;
            Map map = this.encodingManager.getAllPointersMappings();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"encodingManager.allPointersMappings");
            this.oldPointerMappings = map;
        }

        public final void processDir(@NotNull String directory, @NotNull Charset charset) {
            VirtualFilePointer virtualFilePointer;
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            VirtualFile dirVfile = LocalFileSystem.getInstance().findFileByIoFile(new File(directory));
            if (dirVfile != null) {
                $i$f$service = false;
                serviceClass$iv = VirtualFilePointerManager.class;
                var8_6 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (var8_6 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                virtualFilePointer = ((VirtualFilePointerManager)var8_6).create(dirVfile, (Disposable)this.encodingManager, null);
            } else {
                $i$f$service = false;
                serviceClass$iv = VirtualFilePointerManager.class;
                var8_6 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (var8_6 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                virtualFilePointer = ((VirtualFilePointerManager)var8_6).create(VfsUtilCore.fileToUrl((File)new File(directory).getAbsoluteFile()), (Disposable)this.encodingManager, null);
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFilePointer, (String)"if (dirVfile != null) {\n\u2026ingManager, null)\n      }");
            VirtualFilePointer pointer = virtualFilePointer;
            ((Map)this.newPointerMappings).put(pointer, charset);
            Map map = this.encodingManager.getAllPointersMappings();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"encodingManager.allPointersMappings");
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                VirtualFilePointer filePointer = (VirtualFilePointer)it.getKey();
                if (!FileUtil.isAncestor((String)directory, (String)URLUtil.urlToPath((String)filePointer.getUrl()), (boolean)false)) continue;
                Map map2 = this.newPointerMappings;
                Intrinsics.checkNotNullExpressionValue((Object)filePointer, (String)"filePointer");
                map2.put(filePointer, charset);
            }
        }

        public final void applyCollectedInfo() {
            if (this.newPointerMappings.isEmpty()) {
                return;
            }
            Map pointerMapping = MapsKt.plus(this.oldPointerMappings, (Map)this.newPointerMappings);
            this.encodingManager.setPointerMapping(pointerMapping);
        }
    }
}

