/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.externalSystemIntegration.output.quickfixes;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public abstract class LanguageLevelQuickFix {
    protected final Project project;
    private final MavenProject mavenProject;

    public LanguageLevelQuickFix(@NotNull Project project2, @NotNull MavenProject mavenProject2) {
        if (project2 == null) {
            LanguageLevelQuickFix.$$$reportNull$$$0(0);
        }
        if (mavenProject2 == null) {
            LanguageLevelQuickFix.$$$reportNull$$$0(1);
        }
        this.project = project2;
        this.mavenProject = mavenProject2;
    }

    public void perform(@NotNull LanguageLevel level) {
        MavenDomProjectModel model;
        if (level == null) {
            LanguageLevelQuickFix.$$$reportNull$$$0(2);
        }
        if ((model = MavenDomUtil.getMavenDomProjectModel(this.project, this.mavenProject.getFile())) == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)this.project, (PsiFile[])new PsiFile[]{DomUtil.getFile((DomElement)model)}).run(() -> {
            XmlFile file;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.project);
            Document document = documentManager.getDocument((PsiFile)(file = DomUtil.getFile((DomElement)model)));
            if (document == null) {
                return;
            }
            documentManager.commitDocument(document);
            this.runLiveTemplate(document, model, level);
        });
    }

    protected MavenProject getMavenProject() {
        return this.mavenProject;
    }

    protected abstract void runLiveTemplate(@NotNull Document var1, @NotNull MavenDomProjectModel var2, @NotNull LanguageLevel var3);

    @NotNull
    protected static String setChildTagIfAbsent(@NotNull XmlTag tag, @NotNull String subTagName, @NotNull String value) {
        if (tag == null) {
            LanguageLevelQuickFix.$$$reportNull$$$0(3);
        }
        if (subTagName == null) {
            LanguageLevelQuickFix.$$$reportNull$$$0(4);
        }
        if (value == null) {
            LanguageLevelQuickFix.$$$reportNull$$$0(5);
        }
        XmlTag subTag = tag.findFirstSubTag(subTagName);
        String prevValue = "";
        if (subTag != null && StringUtil.isEmpty((String)subTag.getValue().getText())) {
            subTag.getValue().setText(value);
        } else if (subTag != null) {
            prevValue = subTag.getValue().getText();
        } else {
            XmlTag subT = tag.createChildTag(subTagName, tag.getNamespace(), value, false);
            tag.addSubTag(subT, false);
        }
        String string = prevValue;
        if (string == null) {
            LanguageLevelQuickFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    protected void runTemplate(@Nullable Template template, @NotNull XmlTag tagProperty) {
        if (tagProperty == null) {
            LanguageLevelQuickFix.$$$reportNull$$$0(7);
        }
        if (template == null) {
            return;
        }
        Editor editor = CodeInsightUtil.positionCursor((Project)this.project, (PsiFile)tagProperty.getContainingFile(), (PsiElement)tagProperty);
        if (editor == null) {
            return;
        }
        template.setToReformat(true);
        TemplateManager.getInstance((Project)this.project).startTemplate(editor, template, (TemplateEditingListener)new TemplateFinishedEditing());
    }

    protected static PsiElement getXmlTagPsiValue(@Nullable XmlTag tag) {
        if (tag == null) {
            return null;
        }
        return (PsiElement)ContainerUtil.find((Object[])tag.getChildren(), e -> e instanceof XmlText);
    }

    @NotNull
    protected static ConstantNode getExpression(@Nullable String prevValue, @NotNull String newValue) {
        if (newValue == null) {
            LanguageLevelQuickFix.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmptyOrSpaces((String)prevValue)) {
            ConstantNode constantNode = new ConstantNode(newValue).withLookupStrings(new String[]{newValue});
            if (constantNode == null) {
                LanguageLevelQuickFix.$$$reportNull$$$0(9);
            }
            return constantNode;
        }
        ConstantNode constantNode = new ConstantNode(newValue).withLookupStrings(new String[]{newValue, prevValue});
        if (constantNode == null) {
            LanguageLevelQuickFix.$$$reportNull$$$0(10);
        }
        return constantNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subTagName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/LanguageLevelQuickFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagProperty";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/LanguageLevelQuickFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setChildTagIfAbsent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setChildTagIfAbsent";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 10 -> new IllegalStateException(string);
        };
    }

    private class TemplateFinishedEditing
    extends TemplateEditingAdapter {
        private TemplateFinishedEditing() {
        }

        public void templateFinished(@NotNull Template template, boolean brokenOff) {
            if (template == null) {
                TemplateFinishedEditing.$$$reportNull$$$0(0);
            }
            MavenProjectsManager.getInstance(LanguageLevelQuickFix.this.project).forceUpdateProjects(Collections.singleton(LanguageLevelQuickFix.this.mavenProject));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "org/jetbrains/idea/maven/externalSystemIntegration/output/quickfixes/LanguageLevelQuickFix$TemplateFinishedEditing", "templateFinished"));
        }
    }
}

