/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.buildtool;

import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.impl.DerivedResultImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MessageEventUtilsKt;
import org.jetbrains.idea.maven.execution.DownloadBundle;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\"\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00012\b\b\u0001\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\r\u0010\u001a\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0002J\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0012J\u001e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006J\u0006\u0010\"\u001a\u00020\u0012J\u001a\u0010#\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00012\b\b\u0001\u0010\u0017\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\t\u001a*\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000b0\nj\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u000b`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenDownloadConsole;", "", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "hasErrors", "", "myProgressListener", "Lcom/intellij/build/BuildProgressListener;", "myStartedSet", "Ljava/util/LinkedHashSet;", "Lkotlin/Pair;", "", "Lkotlin/collections/LinkedHashSet;", "myTaskId", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Lorg/jetbrains/annotations/NotNull;", "addException", "", "e", "", "completeTask", "parentId", "taskName", "result", "Lcom/intellij/build/events/EventResult;", "createTaskId", "doFinish", "finishDownload", "finishDownloadTask", "startDownload", "progressListener", "downloadSources", "downloadDocs", "startDownloadTask", "startTask", "Companion", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenDownloadConsole.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenDownloadConsole.kt\norg/jetbrains/idea/maven/buildtool/MavenDownloadConsole\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1855#2,2:101\n*S KotlinDebug\n*F\n+ 1 MavenDownloadConsole.kt\norg/jetbrains/idea/maven/buildtool/MavenDownloadConsole\n*L\n73#1:101,2\n*E\n"})
public final class MavenDownloadConsole {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    private boolean hasErrors;
    @NotNull
    private ExternalSystemTaskId myTaskId;
    @NotNull
    private LinkedHashSet<Pair<Object, String>> myStartedSet;
    @NotNull
    private BuildProgressListener myProgressListener;

    public MavenDownloadConsole(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.myTaskId = this.createTaskId();
        this.myStartedSet = new LinkedHashSet();
        this.myProgressListener = MavenDownloadConsole::myProgressListener$lambda$0;
    }

    public final void startDownload(@NotNull BuildProgressListener progressListener, boolean downloadSources, boolean downloadDocs) {
        String string;
        Intrinsics.checkNotNullParameter((Object)progressListener, (String)"progressListener");
        this.hasErrors = false;
        this.myProgressListener = progressListener;
        this.myTaskId = this.createTaskId();
        String string2 = DownloadBundle.message("maven.download.title", new Object[0]);
        String string3 = this.myProject.getBasePath();
        Intrinsics.checkNotNull((Object)string3);
        DefaultBuildDescriptor descriptor2 = new DefaultBuildDescriptor((Object)this.myTaskId, string2, string3, System.currentTimeMillis());
        descriptor2.setActivateToolWindowWhenFailed(false);
        descriptor2.setActivateToolWindowWhenAdded(false);
        String message = "";
        if (downloadSources) {
            String string4 = downloadDocs ? DownloadBundle.message("maven.download.sources.and.docs", new Object[0]) : DownloadBundle.message("maven.download.sources", new Object[0]);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n      if (downloadDocs\u2026d.sources\")\n      }\n    }");
        } else {
            String string5 = DownloadBundle.message("maven.download.docs", new Object[0]);
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"{\n      DownloadBundle.m\u2026ven.download.docs\")\n    }");
        }
        message = string;
        this.myProgressListener.onEvent((Object)this.myTaskId, (BuildEvent)new StartBuildEventImpl((BuildDescriptor)descriptor2, message));
    }

    private final ExternalSystemTaskId createTaskId() {
        ExternalSystemTaskId externalSystemTaskId = ExternalSystemTaskId.create((ProjectSystemId)MavenUtil.SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.RESOLVE_PROJECT, (Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemTaskId, (String)"create(MavenUtil.SYSTEM_\u2026SOLVE_PROJECT, myProject)");
        return externalSystemTaskId;
    }

    public final void finishDownload() {
        org.jetbrains.idea.maven.buildtool.MavenDownloadConsole$Companion.debugLog$default(Companion, "Maven download: finishDownload", null, 2, null);
        this.doFinish();
    }

    public final void startDownloadTask() {
        String string = DownloadBundle.message("maven.download.task", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"maven.download.task\")");
        this.startTask(this.myTaskId, string);
    }

    public final void finishDownloadTask() {
        String string = DownloadBundle.message("maven.download.task", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"maven.download.task\")");
        this.completeTask(this.myTaskId, string, (EventResult)new SuccessResultImpl());
    }

    @ApiStatus.Internal
    public final void addException(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        MavenLog.LOG.warn(e);
        this.hasErrors = true;
        this.myProgressListener.onEvent((Object)this.myTaskId, (BuildEvent)MessageEventUtilsKt.createMessageEvent(this.myProject, this.myTaskId, e));
    }

    private final void doFinish() {
        List tasks = CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)this.myStartedSet));
        org.jetbrains.idea.maven.buildtool.MavenDownloadConsole$Companion.debugLog$default(Companion, "Tasks " + tasks + " are not completed! Force complete", null, 2, null);
        Iterable $this$forEach$iv = tasks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.completeTask(it.getFirst(), (String)it.getSecond(), (EventResult)new DerivedResultImpl());
        }
        this.myProgressListener.onEvent((Object)this.myTaskId, (BuildEvent)new FinishBuildEventImpl((Object)this.myTaskId, null, System.currentTimeMillis(), "", this.hasErrors ? (EventResult)new FailureResultImpl() : (EventResult)new DerivedResultImpl()));
    }

    private final void startTask(Object parentId, @NlsSafe String taskName) {
        org.jetbrains.idea.maven.buildtool.MavenDownloadConsole$Companion.debugLog$default(Companion, "Maven download: start " + taskName, null, 2, null);
        if (this.myStartedSet.add((Pair<Object, String>)TuplesKt.to((Object)parentId, (Object)taskName))) {
            this.myProgressListener.onEvent((Object)this.myTaskId, (BuildEvent)new StartEventImpl((Object)taskName, parentId, System.currentTimeMillis(), taskName));
        }
    }

    private final void completeTask(Object parentId, @NlsSafe String taskName, EventResult result2) {
        this.hasErrors = this.hasErrors || result2 instanceof FailureResultImpl;
        org.jetbrains.idea.maven.buildtool.MavenDownloadConsole$Companion.debugLog$default(Companion, "Maven download: complete " + taskName + " with " + result2, null, 2, null);
        if (this.myStartedSet.remove(TuplesKt.to((Object)parentId, (Object)taskName))) {
            this.myProgressListener.onEvent((Object)this.myTaskId, (BuildEvent)new FinishEventImpl((Object)taskName, parentId, System.currentTimeMillis(), taskName, result2));
        }
    }

    private static final void myProgressListener$lambda$0(Object object, BuildEvent buildEvent) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)buildEvent, (String)"<anonymous parameter 1>");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/buildtool/MavenDownloadConsole$Companion;", "", "()V", "debugLog", "", "s", "", "exception", "", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        private final void debugLog(String s, Throwable exception) {
            MavenLog.LOG.debug(s, exception);
        }

        static /* synthetic */ void debugLog$default(Companion companion, String string, Throwable throwable, int n, Object object) {
            if ((n & 2) != 0) {
                throwable = null;
            }
            companion.debugLog(string, throwable);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

