/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.common;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.completion.ml.common.ContextSimilarityUtil;
import com.intellij.openapi.util.Key;
import com.intellij.textMatching.SimilarityScorer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J(\u0010\u000e\u001a\u00020\u000f*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J>\u0010\u0013\u001a\u00020\u000f*\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/completion/ml/common/ContextSimilarityFeatures;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getName", "addFeature", "", "name", "value", "", "setSimilarityFeatures", "baseName", "key", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/textMatching/SimilarityScorer;", "lookupString", "intellij.completionMlRanking"})
public final class ContextSimilarityFeatures
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "common_similarity";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
        Map features2 = new LinkedHashMap();
        Key<SimilarityScorer> key = ContextSimilarityUtil.INSTANCE.getLINE_SIMILARITY_SCORER_KEY();
        String string = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.lookupString");
        this.setSimilarityFeatures(features2, "line", key, string, contextFeatures);
        Key<SimilarityScorer> key2 = ContextSimilarityUtil.INSTANCE.getPARENT_SIMILARITY_SCORER_KEY();
        String string2 = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"element.lookupString");
        this.setSimilarityFeatures(features2, "parent", key2, string2, contextFeatures);
        return features2;
    }

    private final void setSimilarityFeatures(Map<String, MLFeatureValue> $this$setSimilarityFeatures, String baseName, Key<SimilarityScorer> key, String lookupString, ContextFeatures contextFeatures) {
        block0: {
            SimilarityScorer similarityScorer = (SimilarityScorer)contextFeatures.getUserData(key);
            if (similarityScorer == null) break block0;
            SimilarityScorer similarityScorer2 = similarityScorer;
            boolean bl = false;
            List scores = similarityScorer2.score(lookupString);
            double avgScore = CollectionsKt.averageOfDouble((Iterable)scores);
            Double d = CollectionsKt.maxOrNull((Iterable)scores);
            double maxScore = d != null ? d : Double.NaN;
            this.addFeature($this$setSimilarityFeatures, baseName + "_mean", avgScore);
            this.addFeature($this$setSimilarityFeatures, baseName + "_max", maxScore);
            this.addFeature($this$setSimilarityFeatures, baseName + "_full", maxScore);
            this.addFeature($this$setSimilarityFeatures, baseName + "_stemmed_mean", avgScore);
            this.addFeature($this$setSimilarityFeatures, baseName + "_stemmed_max", maxScore);
        }
    }

    private final void addFeature(Map<String, MLFeatureValue> $this$addFeature, String name, double value) {
        if (!Double.isNaN(value) && !(value == 0.0)) {
            $this$addFeature.put(name, MLFeatureValue.Companion.float(value));
        }
    }
}

