/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.searcheverywhere.ActionSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.FileSearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchAdapter;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereManager;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereUI;
import com.intellij.ide.actions.searcheverywhere.SearchListener;
import com.intellij.ide.actions.searcheverywhere.SymbolSearchEverywhereContributor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.platform.diagnostic.telemetry.helpers.TraceUtil;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.performancePlugin.PerformanceTestSpan;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import java.awt.Component;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class SearchEverywhereCommand
extends AbstractCommand {
    public static final String PREFIX = "%searchEverywhere";
    private static final Logger LOG = Logger.getInstance(SearchEverywhereCommand.class);
    private final Options myOptions;

    public SearchEverywhereCommand(@NotNull String text, int line) {
        if (text == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
        this.myOptions = new Options();
        Args.parse((Object)this.myOptions, (String[])this.extractCommandArgument(PREFIX).split("\\|")[0].split(" "));
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context.getProject();
        String input = this.extractCommandArgument(PREFIX);
        String[] args = input.split("\\|");
        Args.parse((Object)this.myOptions, (String[])args[0].split(" "));
        String tab = this.myOptions.tab;
        String insertText = args.length > 1 ? args[1] : "";
        Ref tabId = new Ref();
        switch (tab) {
            case "file": {
                tabId.set((Object)FileSearchEverywhereContributor.class.getSimpleName());
                break;
            }
            case "class": {
                tabId.set((Object)ClassSearchEverywhereContributor.class.getSimpleName());
                break;
            }
            case "action": {
                tabId.set((Object)ActionSearchEverywhereContributor.class.getSimpleName());
                break;
            }
            case "symbol": {
                tabId.set((Object)SymbolSearchEverywhereContributor.class.getSimpleName());
                break;
            }
            case "all": {
                tabId.set((Object)"SearchEverywhereContributor.All");
                break;
            }
            default: {
                throw new RuntimeException("Tab is not set");
            }
        }
        Semaphore typingSemaphore = new Semaphore(0);
        TraceUtil.runWithSpanThrows((Tracer)PerformanceTestSpan.TRACER, (String)"searchEverywhere", globalSpan -> {
            ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
                try {
                    Component focusedComponent = IdeFocusManager.findInstance().getFocusOwner();
                    DataContext dataContext = DataManager.getInstance().getDataContext(focusedComponent);
                    IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
                    AnActionEvent actionEvent = AnActionEvent.createFromDataContext((String)"EditorPopup", null, (DataContext)dataContext);
                    if (actionEvent.getProject() == null) {
                        actionCallback.reject("Project is null");
                    }
                    TraceUtil.runWithSpanThrows((Tracer)PerformanceTestSpan.TRACER, (String)"searchEverywhere_dialog_shown", dialogSpan -> SearchEverywhereManager.getInstance((Project)project).show((String)tabId.get(), "", actionEvent));
                    if (!insertText.isEmpty()) {
                        SearchEverywhereCommand.insertText(context.getProject(), insertText, typingSemaphore);
                    }
                    if (!this.myOptions.typingText.isEmpty()) {
                        SearchEverywhereCommand.typeText(context.getProject(), this.myOptions.typingText, typingSemaphore);
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }));
            try {
                typingSemaphore.acquire();
                SearchEverywhereUI ui = SearchEverywhereManager.getInstance((Project)project).getCurrentlyShownUI();
                if (this.myOptions.close.booleanValue()) {
                    ApplicationManager.getApplication().invokeAndWait(() -> ui.closePopup());
                }
                if (this.myOptions.selectFirst.booleanValue()) {
                    WriteAction.runAndWait(() -> ApplicationManager.getApplication().invokeAndWait(() -> ui.selectFirst()));
                }
            }
            catch (InterruptedException e) {
                LOG.error((Throwable)e);
            }
            finally {
                actionCallback.setDone();
            }
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            SearchEverywhereCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private static void insertText(Project project, String insertText, Semaphore typingSemaphore) throws InterruptedException {
        SearchEverywhereUI ui = SearchEverywhereManager.getInstance((Project)project).getCurrentlyShownUI();
        Span insertSpan = PerformanceTestSpan.TRACER.spanBuilder("searchEverywhere_items_loaded").startSpan();
        Future elements = ui.findElementsForPattern(insertText);
        ApplicationManager.getApplication().executeOnPooledThread(Context.current().wrap(() -> {
            insertSpan.setAttribute("text", insertText);
            List result = (List)elements.get();
            insertSpan.end();
            insertSpan.setAttribute("number", (long)result.size());
            typingSemaphore.release();
            return result;
        }));
    }

    private static void typeText(Project project, String typingText, final Semaphore typingSemaphore) throws InterruptedException {
        SearchEverywhereUI ui = SearchEverywhereManager.getInstance((Project)project).getCurrentlyShownUI();
        Document document = ui.getSearchField().getDocument();
        final Semaphore oneLetterLock = new Semaphore(1);
        final ThreadPoolExecutor typing = ConcurrencyUtil.newSingleThreadExecutor((String)"Performance plugin delayed type");
        final Ref isTypingFinished = new Ref((Object)false);
        final Ref oneLetterSpan = new Ref();
        ui.addSearchListener((SearchListener)new SearchAdapter(){

            public void searchFinished(@NotNull Map<SearchEverywhereContributor<?>, Boolean> hasMoreContributors) {
                if (hasMoreContributors == null) {
                    1.$$$reportNull$$$0(0);
                }
                oneLetterLock.release();
                ((Span)oneLetterSpan.get()).end();
                if (((Boolean)isTypingFinished.get()).booleanValue()) {
                    typingSemaphore.release();
                    typing.shutdown();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hasMoreContributors", "com/jetbrains/performancePlugin/commands/SearchEverywhereCommand$1", "searchFinished"));
            }
        });
        int i = 0;
        while (i < typingText.length()) {
            int index = i++;
            typing.execute(Context.current().wrap(() -> {
                try {
                    oneLetterLock.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                ApplicationManager.getApplication().invokeAndWait(Context.current().wrap(() -> {
                    try {
                        char currentChar = typingText.charAt(index);
                        oneLetterSpan.set((Object)PerformanceTestSpan.TRACER.spanBuilder("searchEverywhere_items_loaded").startSpan().setAttribute("text", String.valueOf(currentChar)));
                        document.insertString(document.getLength(), String.valueOf(currentChar), null);
                        if (index == typingText.length() - 1) {
                            isTypingFinished.set((Object)true);
                        }
                    }
                    catch (BadLocationException e) {
                        throw new RuntimeException(e);
                    }
                }));
            }));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/SearchEverywhereCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/SearchEverywhereCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    static class Options {
        @Argument
        String tab = "all";
        @Argument
        Boolean close = false;
        @Argument
        Boolean selectFirst = false;
        @Argument(alias="type")
        String typingText = "";

        Options() {
        }
    }
}

