/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.SystemProperties;
import com.jetbrains.performancePlugin.profilers.Profiler;
import com.jetbrains.performancePlugin.profilers.ProfilerHandlerUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/jetbrains/performancePlugin/actions/CaptureMemorySnapshotAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.performanceTesting"})
public final class CaptureMemorySnapshotAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String snapshotFolder = System.getProperty("snapshots.path", SystemProperties.getUserHome());
        String snapshotName = Profiler.Companion.formatSnapshotName(true) + ".hprof";
        File snapshotFile = new File(snapshotFolder, snapshotName);
        try {
            MemoryDumpHelper.captureMemoryDump((String)snapshotFile.getAbsolutePath());
            ProfilerHandlerUtils.notify(e.getProject(), snapshotFile);
        }
        catch (Exception exception) {
            ProfilerHandlerUtils.notifyCapturingError(exception, e.getProject());
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(MemoryDumpHelper.memoryDumpAvailable());
    }
}

