/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.utils;

import com.intellij.internal.statistic.utils.PluginInfo;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0015\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000bH\u0007J\u001c\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010J\u0010\u0010\u0011\u001a\u00020\f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u0004H\u0002J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0017H\u0007J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0017H\u0007J\u0018\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/internal/statistic/utils/StatisticsUtil;", "", "()V", "kilo", "", "mega", "addPluginInfoTo", "", "info", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "data", "", "", "getCountingStepName", "value", "steps", "", "getCurrentHourInUTC", "calendar", "Ljava/util/Calendar;", "getNextPowerOfTwo", "getTimestampDateInUTC", "timestamp", "", "humanize", "number", "roundDuration", "durationMs", "roundToHighestDigit", "roundToPowerOfTwo", "roundToUpperBound", "bounds", "", "intellij.platform.statistics"})
public final class StatisticsUtil {
    @NotNull
    public static final StatisticsUtil INSTANCE = new StatisticsUtil();
    private static final int kilo = 1000;
    private static final int mega = 1000000;

    private StatisticsUtil() {
    }

    @JvmStatic
    public static final void addPluginInfoTo(@NotNull PluginInfo info, @NotNull Map<String, Object> data) {
        String version;
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        data.put("plugin_type", info.getType().name());
        if (!info.getType().isSafeToReport()) {
            return;
        }
        String id = info.getId();
        CharSequence charSequence2 = id;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            data.put("plugin", id);
        }
        if (!((charSequence = (CharSequence)(version = info.getVersion())) == null || charSequence.length() == 0)) {
            data.put("plugin_version", version);
        }
    }

    @JvmStatic
    @Deprecated(message="Use roundToPowerOfTwo instead", replaceWith=@ReplaceWith(expression="roundToPowerOfTwo", imports={}))
    @ApiStatus.ScheduledForRemoval
    public static final int getNextPowerOfTwo(int value) {
        return value <= 1 ? 1 : Integer.highestOneBit(value - 1) << 1;
    }

    @JvmStatic
    public static final int roundToPowerOfTwo(int value) {
        if (value == 0) {
            return 0;
        }
        int abs = Math.abs(value);
        if (abs == 1) {
            return value;
        }
        int nextPowerOfTwo = Integer.highestOneBit(abs - 1) << 1;
        if (nextPowerOfTwo < 0) {
            if (value > 0) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        return Integer.signum(value) * nextPowerOfTwo;
    }

    @JvmStatic
    public static final long roundToPowerOfTwo(long value) {
        if (value == 0L) {
            return 0L;
        }
        long abs = Math.abs(value);
        if (abs == 1L) {
            return value;
        }
        long nextPowerOfTwo = Long.highestOneBit(abs - 1L) << 1;
        if (nextPowerOfTwo < 0L) {
            if (value > 0L) {
                return Long.MAX_VALUE;
            }
            return Long.MIN_VALUE;
        }
        return (long)Long.signum(value) * nextPowerOfTwo;
    }

    @JvmStatic
    public static final int roundToHighestDigit(int value) {
        int abs;
        if (value == 0) {
            return 0;
        }
        int n = abs = value != Integer.MIN_VALUE ? Math.abs(value) : Integer.MAX_VALUE;
        if (abs <= 4) {
            return Integer.signum(value) * 1;
        }
        if (abs <= 10) {
            return Integer.signum(value) * 10;
        }
        float firstDigit = abs;
        int tenPowX = 1;
        while (firstDigit > 10.0f) {
            firstDigit /= (float)10;
            tenPowX *= 10;
        }
        return Integer.signum(value) * (MathKt.roundToInt((float)firstDigit) * tenPowX);
    }

    @JvmStatic
    public static final long roundToHighestDigit(long value) {
        long abs;
        if (value == 0L) {
            return 0L;
        }
        long l = abs = value != Long.MIN_VALUE ? Math.abs(value) : Long.MAX_VALUE;
        if (abs <= 4L) {
            return (long)Long.signum(value) * 1L;
        }
        if (abs <= 10L) {
            return (long)Long.signum(value) * 10L;
        }
        double firstDigit = abs;
        long tenPowX = 1L;
        while (firstDigit > 10.0) {
            firstDigit /= (double)10L;
            tenPowX *= 10L;
        }
        return (long)Long.signum(value) * (MathKt.roundToLong((double)firstDigit) * tenPowX);
    }

    @JvmStatic
    public static final int roundToUpperBound(int value, @NotNull int[] bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        if (bounds.length == 0) {
            return StatisticsUtil.roundToPowerOfTwo(value);
        }
        int n = bounds.length;
        for (int i = 0; i < n; ++i) {
            int bound = bounds[i];
            if (value > bound) continue;
            return bound;
        }
        return ArraysKt.last((int[])bounds);
    }

    @NotNull
    public final String getCountingStepName(int value, @NotNull List<Integer> steps) {
        int stepIndex;
        Intrinsics.checkNotNullParameter(steps, (String)"steps");
        if (steps.isEmpty()) {
            return String.valueOf(value);
        }
        if (value < ((Number)steps.get(0)).intValue()) {
            return "<" + steps.get(0);
        }
        for (stepIndex = 0; stepIndex < steps.size() - 1 && value >= ((Number)steps.get(stepIndex + 1)).intValue(); ++stepIndex) {
        }
        int step = ((Number)steps.get(stepIndex)).intValue();
        boolean addPlus = stepIndex == steps.size() - 1 || ((Number)steps.get(stepIndex + 1)).intValue() != step + 1;
        return this.humanize(step) + (addPlus ? "+" : "");
    }

    @NotNull
    public final String getCurrentHourInUTC(@NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        calendar.set(1, RangesKt.coerceIn((int)calendar.get(1), (int)2000, (int)2099));
        SimpleDateFormat format = new SimpleDateFormat("yyMMddHH", Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        String string = format.format(calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format.format(calendar.time)");
        return string;
    }

    public static /* synthetic */ String getCurrentHourInUTC$default(StatisticsUtil statisticsUtil, Calendar calendar, int n, Object object) {
        if ((n & 1) != 0) {
            Calendar calendar2 = Calendar.getInstance(Locale.ENGLISH);
            Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"getInstance(Locale.ENGLISH)");
            calendar = calendar2;
        }
        return statisticsUtil.getCurrentHourInUTC(calendar);
    }

    @NotNull
    public final String getTimestampDateInUTC(long timestamp, @NotNull Calendar calendar) {
        Intrinsics.checkNotNullParameter((Object)calendar, (String)"calendar");
        calendar.setTimeInMillis(timestamp);
        calendar.set(1, RangesKt.coerceIn((int)calendar.get(1), (int)2000, (int)2099));
        SimpleDateFormat format = new SimpleDateFormat("yyMMdd", Locale.ENGLISH);
        format.setTimeZone(TimeZone.getTimeZone(ZoneOffset.UTC));
        String string = format.format(calendar.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format.format(calendar.time)");
        return string;
    }

    public static /* synthetic */ String getTimestampDateInUTC$default(StatisticsUtil statisticsUtil, long l, Calendar calendar, int n, Object object) {
        if ((n & 2) != 0) {
            Calendar calendar2 = Calendar.getInstance(Locale.ENGLISH);
            Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"getInstance(Locale.ENGLISH)");
            calendar = calendar2;
        }
        return statisticsUtil.getTimestampDateInUTC(l, calendar);
    }

    private final String humanize(int number) {
        if (number == 0) {
            return "0";
        }
        int m = number / 1000000;
        int k = number % 1000000 / 1000;
        int r = number % 1000;
        Object ms = m > 0 ? m + "M" : "";
        Object ks = k > 0 ? k + "K" : "";
        String rs = r > 0 ? String.valueOf(r) : "";
        return (String)ms + (String)ks + rs;
    }

    public final long roundDuration(long durationMs) {
        if (durationMs >= 100L || durationMs < 0L) {
            return durationMs / (long)100 * (long)100;
        }
        return durationMs >= 50L ? 50L : 0L;
    }
}

