/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.project;

import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenAetherUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenAetherUtils.class);
    private static final String NO_SUCH_REALM_EXCEPTION = "org.codehaus.plexus.classworlds.realm.NoSuchRealmException";

    public static void importAetherLibrary() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (MavenAetherUtils.isClassRealm(classLoader)) {
            MavenAetherUtils.importAether(classLoader);
        }
    }

    private static void importAether(ClassLoader classLoader) {
        ClassRealm classRealm = (ClassRealm)classLoader;
        try {
            classRealm.importFrom("plexus.core", "org.eclipse.aether.util");
        }
        catch (Exception e) {
            if (NO_SUCH_REALM_EXCEPTION.equals(e.getClass().getCanonicalName())) {
                LOGGER.info("'plexus.core' ClassRealm could not be found. Ignore this message if you are using the library outside of a Maven execution.", e);
            }
            LOGGER.error("Unexpected exception when importing Aether library to the '{}' ClassRealm", (Object)classLoader, (Object)e);
        }
    }

    private static boolean isClassRealm(ClassLoader classLoader) {
        for (Class<?> clazz = classLoader.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            if (!"org.codehaus.plexus.classworlds.realm.ClassRealm".equals(clazz.getCanonicalName())) continue;
            return true;
        }
        return false;
    }
}

