/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.downloader;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.archetype.downloader.DownloadException;
import org.apache.maven.archetype.downloader.DownloadNotFoundException;
import org.apache.maven.archetype.downloader.Downloader;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=Downloader.class)
public class DefaultDownloader
implements Downloader {
    @Requirement
    private ArtifactResolver artifactResolver;

    @Override
    public File download(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ProjectBuildingRequest buildingRequest) throws DownloadException, DownloadNotFoundException {
        Artifact artifact;
        DefaultArtifactCoordinate jarCoordinate = new DefaultArtifactCoordinate();
        jarCoordinate.setGroupId(groupId);
        jarCoordinate.setArtifactId(artifactId);
        jarCoordinate.setVersion(version);
        DefaultArtifactCoordinate pomCoordinate = new DefaultArtifactCoordinate();
        pomCoordinate.setGroupId(groupId);
        pomCoordinate.setArtifactId(artifactId);
        pomCoordinate.setVersion(version);
        pomCoordinate.setExtension("pom");
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>(remoteRepositories);
        if (repositories.isEmpty() && archetypeRepository != null) {
            repositories.add(archetypeRepository);
        } else if (repositories.isEmpty() && localRepository != null) {
            repositories.add(localRepository);
        }
        ArtifactRepository localRepo = localRepository;
        buildingRequest.setLocalRepository(localRepo);
        buildingRequest.setRemoteRepositories(repositories);
        try {
            artifact = this.artifactResolver.resolveArtifact(buildingRequest, jarCoordinate).getArtifact();
        }
        catch (ArtifactResolverException e) {
            throw new DownloadException("Error downloading " + jarCoordinate + ".", e);
        }
        try {
            this.artifactResolver.resolveArtifact(buildingRequest, pomCoordinate);
        }
        catch (ArtifactResolverException e) {
            throw new DownloadException("Error downloading POM for " + artifact.getId() + ".", e);
        }
        return artifact.getFile();
    }

    @Override
    public File downloadOld(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories, ProjectBuildingRequest buildingRequest) throws DownloadException, DownloadNotFoundException {
        DefaultArtifactCoordinate jarCoordinate = new DefaultArtifactCoordinate();
        jarCoordinate.setGroupId(groupId);
        jarCoordinate.setArtifactId(artifactId);
        jarCoordinate.setVersion(version);
        try {
            return this.artifactResolver.resolveArtifact(buildingRequest, jarCoordinate).getArtifact().getFile();
        }
        catch (ArtifactResolverException e) {
            throw new DownloadException("Error downloading " + jarCoordinate + ".", e);
        }
    }
}

