/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.timeline;

import com.intellij.profiler.ui.timeline.TimelineColors;
import com.intellij.profiler.ui.timeline.TimelineComponent;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0016\u0017\u0018\u0019B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ \u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0016\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\nJ\r\u0010\u0014\u001a\u00020\fH \u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineSlider;", "", "colors", "Lcom/intellij/profiler/ui/timeline/TimelineSlider$Colors;", "(Lcom/intellij/profiler/ui/timeline/TimelineSlider$Colors;)V", "drawChartPart", "", "g", "Ljava/awt/Graphics2D;", "chartRect", "Ljava/awt/Rectangle;", "pointCenterY", "", "labels", "", "", "drawLine", "lineX", "drawPanelPart", "panelRect", "getDrawPosition", "getDrawPosition$intellij_profiler_common", "ChartInfoRenderer", "Colors", "Fixed", "Moving", "Lcom/intellij/profiler/ui/timeline/TimelineSlider$Fixed;", "Lcom/intellij/profiler/ui/timeline/TimelineSlider$Moving;", "intellij.profiler.common"})
public abstract class TimelineSlider {
    @NotNull
    private final Colors colors;

    private TimelineSlider(Colors colors) {
        this.colors = colors;
    }

    public abstract int getDrawPosition$intellij_profiler_common();

    public final void drawPanelPart(@NotNull Graphics2D g, @NotNull Rectangle panelRect) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)panelRect, (String)"panelRect");
        int lineX = this.getDrawPosition$intellij_profiler_common();
        if (lineX < 0) {
            return;
        }
        this.drawLine(g, panelRect, lineX + panelRect.x);
    }

    public final void drawChartPart(@NotNull Graphics2D g, @NotNull Rectangle chartRect, int pointCenterY, @NotNull List<String> labels) {
        ChartInfoRenderer chartInfoRenderer;
        boolean drawPoint;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)chartRect, (String)"chartRect");
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        int lineX = this.getDrawPosition$intellij_profiler_common();
        if (lineX < 0) {
            return;
        }
        this.drawLine(g, chartRect, lineX);
        boolean bl = drawPoint = pointCenterY >= 0;
        if (drawPoint) {
            int radius = 4;
            g.setColor(this.colors.getPointBackground());
            g.fillOval(lineX - radius, pointCenterY - radius, radius * 2, radius * 2);
            g.setColor(this.colors.getPointBorderColor());
            g.drawOval(lineX - radius, pointCenterY - radius, radius * 2, radius * 2);
        }
        ChartInfoRenderer $this$drawChartPart_u24lambda_u240 = chartInfoRenderer = new ChartInfoRenderer();
        boolean bl2 = false;
        $this$drawChartPart_u24lambda_u240.setHorizontalPadding(4);
        $this$drawChartPart_u24lambda_u240.setHorizontalMargin(5);
        $this$drawChartPart_u24lambda_u240.setVerticalPadding(2);
        $this$drawChartPart_u24lambda_u240.setVerticalMargin(5);
        $this$drawChartPart_u24lambda_u240.setCornerRadius(10);
        ChartInfoRenderer chartInfoRenderer2 = chartInfoRenderer;
        chartInfoRenderer2.draw(g, labels, this.colors, chartRect, lineX, drawPoint, pointCenterY);
    }

    public static /* synthetic */ void drawChartPart$default(TimelineSlider timelineSlider, Graphics2D graphics2D, Rectangle rectangle, int n, List list, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: drawChartPart");
        }
        if ((n2 & 4) != 0) {
            n = -1;
        }
        if ((n2 & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        timelineSlider.drawChartPart(graphics2D, rectangle, n, list);
    }

    private final void drawLine(Graphics2D g, Rectangle chartRect, int lineX) {
        g.setColor(this.colors.getLineColor());
        g.drawLine(lineX, chartRect.y, lineX, chartRect.y + chartRect.height);
    }

    public /* synthetic */ TimelineSlider(Colors colors, DefaultConstructorMarker $constructor_marker) {
        this(colors);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001a\u0010\u0012\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006$"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineSlider$ChartInfoRenderer;", "", "()V", "cornerRadius", "", "getCornerRadius", "()I", "setCornerRadius", "(I)V", "horizontalMargin", "getHorizontalMargin", "setHorizontalMargin", "horizontalPadding", "getHorizontalPadding", "setHorizontalPadding", "verticalMargin", "getVerticalMargin", "setVerticalMargin", "verticalPadding", "getVerticalPadding", "setVerticalPadding", "draw", "", "g", "Ljava/awt/Graphics2D;", "labels", "", "", "colors", "Lcom/intellij/profiler/ui/timeline/TimelineSlider$Colors;", "chartRect", "Ljava/awt/Rectangle;", "lineX", "drawPoint", "", "pointCenterY", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nTimelineSlider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelineSlider.kt\ncom/intellij/profiler/ui/timeline/TimelineSlider$ChartInfoRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,137:1\n1271#2,2:138\n1285#2,4:140\n1#3:144\n215#4,2:145\n*S KotlinDebug\n*F\n+ 1 TimelineSlider.kt\ncom/intellij/profiler/ui/timeline/TimelineSlider$ChartInfoRenderer\n*L\n100#1:138,2\n100#1:140,4\n129#1:145,2\n*E\n"})
    private static final class ChartInfoRenderer {
        private int horizontalPadding;
        private int verticalPadding;
        private int horizontalMargin;
        private int verticalMargin;
        private int cornerRadius;

        public final int getHorizontalPadding() {
            return this.horizontalPadding;
        }

        public final void setHorizontalPadding(int n) {
            this.horizontalPadding = n;
        }

        public final int getVerticalPadding() {
            return this.verticalPadding;
        }

        public final void setVerticalPadding(int n) {
            this.verticalPadding = n;
        }

        public final int getHorizontalMargin() {
            return this.horizontalMargin;
        }

        public final void setHorizontalMargin(int n) {
            this.horizontalMargin = n;
        }

        public final int getVerticalMargin() {
            return this.verticalMargin;
        }

        public final void setVerticalMargin(int n) {
            this.verticalMargin = n;
        }

        public final int getCornerRadius() {
            return this.cornerRadius;
        }

        public final void setCornerRadius(int n) {
            this.cornerRadius = n;
        }

        /*
         * WARNING - void declaration
         */
        public final void draw(@NotNull Graphics2D g, @NotNull List<String> labels, @NotNull Colors colors, @NotNull Rectangle chartRect, int lineX, boolean drawPoint, int pointCenterY) {
            int n;
            Object object;
            Map.Entry it;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter(labels, (String)"labels");
            Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
            Intrinsics.checkNotNullParameter((Object)chartRect, (String)"chartRect");
            if (labels.isEmpty()) {
                return;
            }
            FontMetrics $this$draw_u24lambda_u244 = g.getFontMetrics();
            boolean bl = false;
            Iterable $this$associateWith$iv = labels;
            boolean $i$f$associateWith = false;
            Object result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                String string = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = (Map)result$iv;
                boolean bl2 = false;
                Rectangle2D rectangle2D = $this$draw_u24lambda_u244.getStringBounds((String)((Object)it), null);
                map2.put(t, rectangle2D);
            }
            Map labels2Bounds = (Map)result$iv;
            if (!(result$iv = ((Iterable)labels2Bounds.entrySet()).iterator()).hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry it2 = (Map.Entry)result$iv.next();
            boolean $i$a$-maxOf-TimelineSlider$ChartInfoRenderer$draw$1$totalWidth$22 = false;
            double d = ((Rectangle2D)it2.getValue()).getWidth();
            while (result$iv.hasNext()) {
                it = (Map.Entry)result$iv.next();
                e = false;
                double d2 = ((Rectangle2D)it.getValue()).getWidth();
                d = Math.max(d, d2);
            }
            int hgap = this.horizontalMargin + this.horizontalPadding;
            int totalWidth = MathKt.roundToInt((double)d);
            int textX = lineX + hgap + totalWidth >= chartRect.width ? lineX - hgap - totalWidth : lineX + hgap;
            Iterable $i$a$-maxOf-TimelineSlider$ChartInfoRenderer$draw$1$totalWidth$22 = labels2Bounds.values();
            d = 0.0;
            for (Object e : $i$a$-maxOf-TimelineSlider$ChartInfoRenderer$draw$1$totalWidth$22) {
                void it3;
                object = (Rectangle2D)e;
                double d3 = d;
                boolean bl3 = false;
                double d4 = it3.getHeight();
                d = d3 + d4;
            }
            int totalHeight = MathKt.roundToInt((double)d);
            int vgap = this.verticalMargin + this.verticalPadding;
            int firstHeight = MathKt.roundToInt((double)((Rectangle2D)CollectionsKt.first((Iterable)labels2Bounds.values())).getHeight());
            int textY = 0;
            if (drawPoint && totalHeight <= chartRect.height) {
                int offset = totalHeight + vgap - pointCenterY;
                n = pointCenterY - vgap - totalHeight + firstHeight + Math.max(offset, 0);
            } else {
                n = chartRect.y + chartRect.height - vgap - totalHeight + firstHeight;
            }
            textY = n;
            g.setColor(TimelineColors.TimelineSlider.INSTANCE.getPaddingBackground());
            g.fillRoundRect(textX - this.horizontalPadding, textY - firstHeight, totalWidth + this.horizontalPadding * 2, totalHeight + this.verticalPadding * 2, this.cornerRadius, this.cornerRadius);
            g.setColor(colors.getForeground());
            Map $this$forEach$iv = labels2Bounds;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl4 = false;
                String label = (String)entry.getKey();
                Rectangle2D bound = (Rectangle2D)entry.getValue();
                g.drawString(label, textX, textY);
                textY += (int)bound.getHeight();
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0002\r\u000eB'\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineSlider$Colors;", "", "lineColor", "Ljava/awt/Color;", "foreground", "pointBackground", "pointBorderColor", "(Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;Ljava/awt/Color;)V", "getForeground", "()Ljava/awt/Color;", "getLineColor", "getPointBackground", "getPointBorderColor", "Hover", "Selected", "Lcom/intellij/profiler/ui/timeline/TimelineSlider$Colors$Hover;", "Lcom/intellij/profiler/ui/timeline/TimelineSlider$Colors$Selected;", "intellij.profiler.common"})
    private static abstract class Colors {
        @NotNull
        private final Color lineColor;
        @NotNull
        private final Color foreground;
        @NotNull
        private final Color pointBackground;
        @NotNull
        private final Color pointBorderColor;

        private Colors(Color lineColor, Color foreground, Color pointBackground, Color pointBorderColor) {
            this.lineColor = lineColor;
            this.foreground = foreground;
            this.pointBackground = pointBackground;
            this.pointBorderColor = pointBorderColor;
        }

        @NotNull
        public final Color getLineColor() {
            return this.lineColor;
        }

        @NotNull
        public final Color getForeground() {
            return this.foreground;
        }

        @NotNull
        public final Color getPointBackground() {
            return this.pointBackground;
        }

        @NotNull
        public final Color getPointBorderColor() {
            return this.pointBorderColor;
        }

        public /* synthetic */ Colors(Color lineColor, Color foreground, Color pointBackground, Color pointBorderColor, DefaultConstructorMarker $constructor_marker) {
            this(lineColor, foreground, pointBackground, pointBorderColor);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineSlider$Colors$Hover;", "Lcom/intellij/profiler/ui/timeline/TimelineSlider$Colors;", "()V", "intellij.profiler.common"})
        public static final class Hover
        extends Colors {
            public Hover() {
                super(TimelineColors.TimelineSlider.INSTANCE.getLineColor(), TimelineColors.TimelineSlider.INSTANCE.getForeground(), TimelineColors.TimelineSlider.INSTANCE.getPointBackground(), TimelineColors.TimelineSlider.INSTANCE.getPointBorderColor(), null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineSlider$Colors$Selected;", "Lcom/intellij/profiler/ui/timeline/TimelineSlider$Colors;", "()V", "intellij.profiler.common"})
        public static final class Selected
        extends Colors {
            public Selected() {
                super(TimelineColors.TimelineSlider.INSTANCE.getSelectionLineColor(), TimelineColors.TimelineSlider.INSTANCE.getSelectionForeground(), TimelineColors.TimelineSlider.INSTANCE.getSelectionPointBackground(), TimelineColors.TimelineSlider.INSTANCE.getSelectionPointBorderColor(), null);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000b\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\rR\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineSlider$Fixed;", "Lcom/intellij/profiler/ui/timeline/TimelineSlider;", "chart", "Lcom/intellij/profiler/ui/timeline/TimelineComponent;", "(Lcom/intellij/profiler/ui/timeline/TimelineComponent;)V", "time", "", "getTime$intellij_profiler_common", "()J", "setTime$intellij_profiler_common", "(J)V", "getDrawPosition", "", "getDrawPosition$intellij_profiler_common", "intellij.profiler.common"})
    public static final class Fixed
    extends TimelineSlider {
        @NotNull
        private final TimelineComponent<?, ?> chart;
        private long time;

        public Fixed(@NotNull TimelineComponent<?, ?> chart2) {
            Intrinsics.checkNotNullParameter(chart2, (String)"chart");
            super(new Colors.Selected(), null);
            this.chart = chart2;
            this.time = -1L;
        }

        public final long getTime$intellij_profiler_common() {
            return this.time;
        }

        public final void setTime$intellij_profiler_common(long l) {
            this.time = l;
        }

        @Override
        public int getDrawPosition$intellij_profiler_common() {
            return this.time < 0L ? -1 : this.chart.toScreenCoordinate(this.time) - this.chart.getVisibleRect().x;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\r\u0010\t\u001a\u00020\u0004H\u0010\u00a2\u0006\u0002\b\nR\u001a\u0010\u0003\u001a\u00020\u0004X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ui/timeline/TimelineSlider$Moving;", "Lcom/intellij/profiler/ui/timeline/TimelineSlider;", "()V", "positionX", "", "getPositionX$intellij_profiler_common", "()I", "setPositionX$intellij_profiler_common", "(I)V", "getDrawPosition", "getDrawPosition$intellij_profiler_common", "intellij.profiler.common"})
    public static final class Moving
    extends TimelineSlider {
        private int positionX = -1;

        public Moving() {
            super(new Colors.Hover(), null);
        }

        public final int getPositionX$intellij_profiler_common() {
            return this.positionX;
        }

        public final void setPositionX$intellij_profiler_common(int n) {
            this.positionX = n;
        }

        @Override
        public int getDrawPosition$intellij_profiler_common() {
            return this.positionX;
        }
    }
}

