/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.grouping;

import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.CallWithValue;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B'\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030'R \u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019R\u0011\u0010$\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0012\u00a8\u0006("}, d2={"Lcom/intellij/profiler/ui/grouping/FoldingNodesGroup;", "Call", "", "Lcom/intellij/profiler/model/CallTreeNode;", "groupStart", "groupEnd", "", "(Lcom/intellij/profiler/model/CallTreeNode;Ljava/util/List;)V", "children", "getChildren", "()Ljava/util/List;", "data", "Lcom/intellij/profiler/model/CallWithValue;", "getData", "()Lcom/intellij/profiler/model/CallWithValue;", "depth", "", "getDepth", "()I", "endToStartRatio", "", "getEndToStartRatio", "()Ljava/lang/Double;", "getGroupEnd", "getGroupStart", "()Lcom/intellij/profiler/model/CallTreeNode;", "isFolded", "", "()Z", "setFolded", "(Z)V", "length", "getLength", "()Ljava/lang/Integer;", "parent", "getParent", "size", "getSize", "nodes", "Lcom/intellij/util/containers/JBIterable;", "intellij.profiler.common"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nFoldingNodesGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FoldingNodesGroup.kt\ncom/intellij/profiler/ui/grouping/FoldingNodesGroup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1360#2:63\n1446#2,5:64\n1#3:69\n*S KotlinDebug\n*F\n+ 1 FoldingNodesGroup.kt\ncom/intellij/profiler/ui/grouping/FoldingNodesGroup\n*L\n26#1:63\n26#1:64,5\n*E\n"})
public final class FoldingNodesGroup<Call>
implements CallTreeNode<Call> {
    @NotNull
    private final CallTreeNode<Call> groupStart;
    @NotNull
    private final List<CallTreeNode<Call>> groupEnd;
    private boolean isFolded;

    public FoldingNodesGroup(@NotNull CallTreeNode<? extends Call> groupStart, @NotNull List<? extends CallTreeNode<? extends Call>> groupEnd) {
        Intrinsics.checkNotNullParameter(groupStart, (String)"groupStart");
        Intrinsics.checkNotNullParameter(groupEnd, (String)"groupEnd");
        this.groupStart = groupStart;
        this.groupEnd = groupEnd;
        this.isFolded = true;
    }

    @NotNull
    public final CallTreeNode<Call> getGroupStart() {
        return this.groupStart;
    }

    @NotNull
    public final List<CallTreeNode<Call>> getGroupEnd() {
        return this.groupEnd;
    }

    public final boolean isFolded() {
        return this.isFolded;
    }

    public final void setFolded(boolean bl) {
        this.isFolded = bl;
    }

    @Override
    @Nullable
    public CallWithValue<Call> getData() {
        return (CallWithValue)this.groupStart.getData();
    }

    @Override
    public int getDepth() {
        return this.groupStart.getDepth();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CallTreeNode<Call>> getChildren() {
        List list;
        if (this.isFolded) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = this.groupEnd;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                CallTreeNode it = (CallTreeNode)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getChildren();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = this.groupStart.getChildren();
        }
        return list;
    }

    @Override
    @Nullable
    public CallTreeNode<Call> getParent() {
        return this.groupStart.getParent();
    }

    @Nullable
    public final Integer getLength() {
        Comparable comparable;
        Iterator iterator2 = ((Iterable)this.groupEnd).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            CallTreeNode it = (CallTreeNode)iterator2.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.getDepth());
            while (iterator2.hasNext()) {
                CallTreeNode it2 = (CallTreeNode)iterator2.next();
                $i$a$-maxOfOrNull-FoldingNodesGroup$length$maxDepth$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.getDepth());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        if (n == null) {
            return null;
        }
        int maxDepth = n;
        return maxDepth - this.groupStart.getDepth() + 1;
    }

    @Nullable
    public final Double getEndToStartRatio() {
        CallWithValue callWithValue = (CallWithValue)this.groupStart.getData();
        if (callWithValue == null) {
            return null;
        }
        long startValue = callWithValue.getValue();
        Object object = (CallTreeNode)CollectionsKt.singleOrNull(this.groupEnd);
        if (object == null || (object = (CallWithValue)object.getData()) == null) {
            return null;
        }
        long endValue = object.getValue();
        return (double)endValue / (double)startValue;
    }

    public final int getSize() {
        return CollectionsKt.count((Iterable)((Iterable)this.nodes()));
    }

    @NotNull
    public final JBIterable<CallTreeNode<Call>> nodes() {
        JBIterable jBIterable = ((JBTreeTraverser)JBTreeTraverser.from(arg_0 -> FoldingNodesGroup.nodes$lambda$2((Function1)new Function1<CallTreeNode<? extends Call>, Iterable<? extends CallTreeNode<? extends Call>>>(this){
            final /* synthetic */ FoldingNodesGroup<Call> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Iterable<CallTreeNode<Call>> invoke(CallTreeNode<? extends Call> it) {
                return this.this$0.getGroupEnd().contains(it) ? (Iterable)CollectionsKt.emptyList() : (Iterable)it.getChildren();
            }
        }, arg_0)).withRoot(this.groupStart)).bfsTraversal();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"fun nodes(): JBIterable<\u2026Start).bfsTraversal()\n  }");
        return jBIterable;
    }

    private static final Iterable nodes$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }
}

