/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.model;

import com.intellij.profiler.model.BaseRichCallTreeModel;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.model.InnerMapStructures;
import com.intellij.profiler.model.RichCallTreeModelKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0014J#\u0010\u000f\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0005\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0012R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/model/RichCallTreeModelImpl;", "Call", "", "Lcom/intellij/profiler/model/BaseRichCallTreeModel;", "callTree", "Lcom/intellij/profiler/model/CallTreeNode;", "(Lcom/intellij/profiler/model/CallTreeNode;)V", "getCallTree", "()Lcom/intellij/profiler/model/CallTreeNode;", "innerMapStructures", "Lcom/intellij/profiler/model/InnerMapStructures;", "getInnerMapStructures", "()Lcom/intellij/profiler/model/InnerMapStructures;", "baseNode", "node", "getCallNodes", "", "call", "(Ljava/lang/Object;)Ljava/util/List;", "intellij.profiler.common"})
final class RichCallTreeModelImpl<Call>
extends BaseRichCallTreeModel<Call> {
    @NotNull
    private final CallTreeNode<Call> callTree;
    @NotNull
    private final InnerMapStructures<Call> innerMapStructures;

    public RichCallTreeModelImpl(@NotNull CallTreeNode<? extends Call> callTree) {
        Intrinsics.checkNotNullParameter(callTree, (String)"callTree");
        this.callTree = callTree;
        this.innerMapStructures = RichCallTreeModelKt.access$buildInnerMapStructures(this.getCallTree());
    }

    @Override
    @NotNull
    public CallTreeNode<Call> getCallTree() {
        return this.callTree;
    }

    @Override
    @NotNull
    protected InnerMapStructures<Call> getInnerMapStructures() {
        return this.innerMapStructures;
    }

    @Override
    @Nullable
    protected List<CallTreeNode<Call>> getCallNodes(@NotNull Call call) {
        Intrinsics.checkNotNullParameter(call, (String)"call");
        return this.getInnerMapStructures().getHorizontalMap().get(call);
    }

    @Override
    @NotNull
    protected CallTreeNode<Call> baseNode(@NotNull CallTreeNode<? extends Call> node2) {
        Intrinsics.checkNotNullParameter(node2, (String)"node");
        return node2;
    }
}

