/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.eventtrace.toolwindow;

import com.intellij.execution.filters.Filter;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ProfilerDumpPanel;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.eventtrace.parser.events.EventTraceParseData;
import com.intellij.profiler.eventtrace.parser.events.TraceEventParser;
import com.intellij.profiler.eventtrace.parser.panels.TraceEventPanel;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0004+,-.B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J9\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u001b\b\u0002\u0010\"\u001a\u0015\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u000b\u00a2\u0006\u0002\b$H\u0002JQ\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(2\u001b\b\u0002\u0010\"\u001a\u0015\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u000b\u00a2\u0006\u0002\b$H\u0004J\b\u0010)\u001a\u00020*H\u0002R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR$\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\r0\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0005\u00a8\u0006/"}, d2={"Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceToolWindowUi;", "MODEL_TYPE", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "panel", "Lcom/intellij/profiler/eventtrace/parser/panels/TraceEventPanel;", "getPanel", "()Lcom/intellij/profiler/eventtrace/parser/panels/TraceEventPanel;", "parser", "Lkotlin/Function1;", "", "Lcom/intellij/profiler/eventtrace/parser/events/TraceEventParser;", "getParser", "()Lkotlin/jvm/functions/Function1;", "parsingFailed", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "getParsingFailed", "()Lcom/intellij/internal/statistic/eventLog/events/EventId;", "parsingFileDurationLogger", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "getParsingFileDurationLogger", "()Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "getProject", "()Lcom/intellij/openapi/project/Project;", "setProject", "addTab", "", "name", "", "panelWithStatus", "Lcom/intellij/profiler/eventtrace/parser/panels/TraceEventPanel$PanelWithStatus;", "contentChanger", "Lcom/intellij/ui/content/Content;", "Lkotlin/ExtensionFunctionType;", "path", "Ljava/nio/file/Path;", "filter", "Lcom/intellij/execution/filters/Filter;", "getToolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "EventTraceFileContainer", "InvalidPathEventTraceFile", "OutputProfileOptionNotFoundEventTraceFile", "SuccessfulEventTraceFileContainer", "intellij.profiler.common"})
public abstract class EventTraceToolWindowUi<MODEL_TYPE> {
    @NotNull
    private Project project;
    @Nullable
    private final EventId1<Long> parsingFileDurationLogger;
    @Nullable
    private final EventId parsingFailed;

    public EventTraceToolWindowUi(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @Nullable
    public EventId1<Long> getParsingFileDurationLogger() {
        return this.parsingFileDurationLogger;
    }

    @Nullable
    public EventId getParsingFailed() {
        return this.parsingFailed;
    }

    private final ToolWindowManager getToolWindowManager() {
        return ToolWindowManager.Companion.getInstance(this.project);
    }

    @NotNull
    public abstract Function1<Integer, TraceEventParser<MODEL_TYPE>> getParser();

    @NotNull
    public abstract TraceEventPanel<MODEL_TYPE> getPanel();

    protected final void addTab(@NlsSafe @NotNull String name, @NotNull Path path, @NotNull TraceEventParser<MODEL_TYPE> parser2, @Nullable Filter filter, @Nullable Function1<? super Content, Unit> contentChanger) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(parser2, (String)"parser");
        Ref.ObjectRef dialogPanel = new Ref.ObjectRef();
        try {
            File file = path.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
            File json = file;
            if (!json.exists()) {
                throw new FileNotFoundException();
            }
            long start2 = System.currentTimeMillis();
            String string = path.toFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path.toFile().name");
            TraceEventPanel.ReloadResult<MODEL_TYPE> reloadResult = parser2.getResult(string, json, this.project);
            if (reloadResult == null) {
                return;
            }
            TraceEventPanel.ReloadResult<MODEL_TYPE> result2 = reloadResult;
            if (this.getParsingFailed() != null && result2.getException() != null) {
                EventId eventId = this.getParsingFailed();
                Intrinsics.checkNotNull((Object)eventId);
                eventId.log(this.project);
            }
            if (this.getParsingFileDurationLogger() != null) {
                EventId1<Long> eventId1 = this.getParsingFileDurationLogger();
                Intrinsics.checkNotNull(eventId1);
                eventId1.log(this.project, (Object)(System.currentTimeMillis() - start2));
            }
            ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>((Ref.ObjectRef<TraceEventPanel.PanelWithStatus>)dialogPanel, this, result2, filter){
                final /* synthetic */ Ref.ObjectRef<TraceEventPanel.PanelWithStatus> $dialogPanel;
                final /* synthetic */ EventTraceToolWindowUi<MODEL_TYPE> this$0;
                final /* synthetic */ TraceEventPanel.ReloadResult<MODEL_TYPE> $result;
                final /* synthetic */ Filter $filter;
                {
                    this.$dialogPanel = $dialogPanel;
                    this.this$0 = $receiver;
                    this.$result = $result;
                    this.$filter = $filter;
                    super(0);
                }

                public final void invoke() {
                    this.$dialogPanel.element = this.this$0.getPanel().getPanel(this.$result, this.$filter, this.this$0.getProject());
                }
            }), (int)1, null);
        }
        catch (Exception e) {
            dialogPanel.element = this.getPanel().getPanel(e);
        }
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, name, (Ref.ObjectRef<TraceEventPanel.PanelWithStatus>)dialogPanel, contentChanger){
            final /* synthetic */ EventTraceToolWindowUi<MODEL_TYPE> this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ Ref.ObjectRef<TraceEventPanel.PanelWithStatus> $dialogPanel;
            final /* synthetic */ Function1<Content, Unit> $contentChanger;
            {
                this.this$0 = $receiver;
                this.$name = $name;
                this.$dialogPanel = $dialogPanel;
                this.$contentChanger = $contentChanger;
                super(0);
            }

            public final void invoke() {
                EventTraceToolWindowUi.access$addTab(this.this$0, this.$name, (TraceEventPanel.PanelWithStatus)this.$dialogPanel.element, this.$contentChanger);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ void addTab$default(EventTraceToolWindowUi eventTraceToolWindowUi, String string, Path path, TraceEventParser traceEventParser, Filter filter, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addTab");
        }
        if ((n & 8) != 0) {
            filter = null;
        }
        if ((n & 0x10) != 0) {
            function1 = null;
        }
        eventTraceToolWindowUi.addTab(string, path, traceEventParser, filter, (Function1<Content, Unit>)function1);
    }

    private final void addTab(@NlsSafe String name, TraceEventPanel.PanelWithStatus panelWithStatus, Function1<? super Content, Unit> contentChanger) {
        if (panelWithStatus == null) {
            return;
        }
        AppUIUtil.invokeLaterIfProjectAlive((Project)this.project, () -> EventTraceToolWindowUi.addTab$lambda$1(this, panelWithStatus, name, contentChanger));
    }

    static /* synthetic */ void addTab$default(EventTraceToolWindowUi eventTraceToolWindowUi, String string, TraceEventPanel.PanelWithStatus panelWithStatus, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addTab");
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        eventTraceToolWindowUi.addTab(string, panelWithStatus, (Function1<Content, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    private static final void addTab$lambda$1(EventTraceToolWindowUi this$0, TraceEventPanel.PanelWithStatus $panelWithStatus, String $name, Function1 $contentChanger) {
        void $this$addTab_u24lambda_u241_u24lambda_u240;
        ProfilerDumpPanel profilerDumpPanel;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        ProfilerDumpPanel profilerDumpPanel2 = profilerDumpPanel = new ProfilerDumpPanel(this$0.project, new EventTraceParseData($panelWithStatus), $name, "profiler.eventtrace", null, $name);
        ProfilerToolWindowManager profilerToolWindowManager = ProfilerToolWindowManager.Companion.getInstance(this$0.project);
        boolean bl = false;
        if ($contentChanger != null) {
            $contentChanger.invoke((Object)$this$addTab_u24lambda_u241_u24lambda_u240.getContent());
        }
        if ($panelWithStatus.getStatus() == TraceEventPanel.PanelWithStatus.Status.EXCEPTION) {
            $this$addTab_u24lambda_u241_u24lambda_u240.getContent().putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
            $this$addTab_u24lambda_u241_u24lambda_u240.getContent().setIcon(AllIcons.General.BalloonError);
        } else {
            $this$addTab_u24lambda_u241_u24lambda_u240.getContent().putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)true);
            $this$addTab_u24lambda_u241_u24lambda_u240.getContent().setIcon(AllIcons.Toolwindows.ToolWindowJsonPath);
        }
        ProfilerToolWindowManager.addProfilerDumpTab$default(profilerToolWindowManager, profilerDumpPanel, false, 2, null);
    }

    public static final /* synthetic */ void access$addTab(EventTraceToolWindowUi $this, String name, TraceEventPanel.PanelWithStatus panelWithStatus, Function1 contentChanger) {
        $this.addTab(name, panelWithStatus, (Function1<Content, Unit>)contentChanger);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001J\r\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H&\u0082\u0001\u0003\u0005\u0006\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceToolWindowUi$EventTraceFileContainer;", "", "shortMessage", "", "Lorg/jetbrains/annotations/Nls;", "Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceToolWindowUi$InvalidPathEventTraceFile;", "Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceToolWindowUi$OutputProfileOptionNotFoundEventTraceFile;", "Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceToolWindowUi$SuccessfulEventTraceFileContainer;", "intellij.profiler.common"})
    public static interface EventTraceFileContainer {
        @NotNull
        public String shortMessage();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceToolWindowUi$InvalidPathEventTraceFile;", "Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceToolWindowUi$EventTraceFileContainer;", "()V", "shortMessage", "", "Lorg/jetbrains/annotations/Nls;", "intellij.profiler.common"})
    public static final class InvalidPathEventTraceFile
    implements EventTraceFileContainer {
        @NotNull
        public static final InvalidPathEventTraceFile INSTANCE = new InvalidPathEventTraceFile();

        private InvalidPathEventTraceFile() {
        }

        @Override
        @NotNull
        public String shortMessage() {
            return CommonProfilerBundleKt.profilerMessage("profiler.eventtracer.resultlogger.invalid.path.in.options", new Object[0]);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceToolWindowUi$OutputProfileOptionNotFoundEventTraceFile;", "Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceToolWindowUi$EventTraceFileContainer;", "()V", "shortMessage", "", "Lorg/jetbrains/annotations/Nls;", "intellij.profiler.common"})
    public static final class OutputProfileOptionNotFoundEventTraceFile
    implements EventTraceFileContainer {
        @NotNull
        public static final OutputProfileOptionNotFoundEventTraceFile INSTANCE = new OutputProfileOptionNotFoundEventTraceFile();

        private OutputProfileOptionNotFoundEventTraceFile() {
        }

        @Override
        @NotNull
        public String shortMessage() {
            return CommonProfilerBundleKt.profilerMessage("profiler.eventtracer.resultlogger.profiler.output.not.found", new Object[0]);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0005H&J\r\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceToolWindowUi$SuccessfulEventTraceFileContainer;", "Lcom/intellij/profiler/eventtrace/toolwindow/EventTraceToolWindowUi$EventTraceFileContainer;", "generatorDir", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "(Ljava/io/File;Ljava/nio/file/Path;)V", "getGeneratorDir", "()Ljava/io/File;", "userObject", "", "getUserObject", "()Ljava/lang/Object;", "setUserObject", "(Ljava/lang/Object;)V", "getHostMachinePath", "shortMessage", "", "Lorg/jetbrains/annotations/Nls;", "intellij.profiler.common"})
    public static abstract class SuccessfulEventTraceFileContainer
    implements EventTraceFileContainer {
        @NotNull
        private final File generatorDir;
        @NotNull
        private final Path path;
        @Nullable
        private Object userObject;

        public SuccessfulEventTraceFileContainer(@NotNull File generatorDir, @NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)generatorDir, (String)"generatorDir");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.generatorDir = generatorDir;
            this.path = path;
        }

        @NotNull
        public final File getGeneratorDir() {
            return this.generatorDir;
        }

        @Nullable
        public final Object getUserObject() {
            return this.userObject;
        }

        public final void setUserObject(@Nullable Object object) {
            this.userObject = object;
        }

        @NotNull
        public abstract Path getHostMachinePath();

        @Override
        @NotNull
        public String shortMessage() {
            Object[] objectArray = new Object[]{this.getHostMachinePath()};
            return CommonProfilerBundleKt.profilerMessage("profiler.eventtracer.resultlogger.path.to.file", objectArray);
        }
    }
}

