/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.eventtrace.intervals;

import com.intellij.profiler.eventtrace.abstractevent.TraceTimeEvent;
import com.intellij.profiler.eventtrace.event.CompleteGoogleTraceEvent;
import com.intellij.profiler.eventtrace.event.DurationGoogleTraceEvent;
import com.intellij.profiler.eventtrace.event.InstantGoogleTraceEvent;
import com.intellij.profiler.eventtrace.exception.IncompleteDurationEventException;
import com.intellij.profiler.eventtrace.intervals.EventToTreeGoogleEventParser;
import com.intellij.profiler.eventtrace.intervals.GoogleTraceIntervalEvent;
import com.intellij.profiler.eventtrace.intervals.TraceEventLineInterval;
import com.intellij.profiler.eventtrace.parser.IteratorCombinatorParser;
import com.intellij.profiler.eventtrace.parser.events.GoogleTraceEventParser;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010 \u001a\u00020\bH\u0002J\u001c\u0010!\u001a\u00020\b2\b\u0010\"\u001a\u0004\u0018\u00010\u001b2\b\u0010#\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'J\u0016\u0010$\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020+R3\u0010\f\u001a!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000f0\r\u00a2\u0006\u0002\b\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010\u0016\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000e\u0012\u0004\u0012\u00020\u00170\r\u00a2\u0006\u0002\b\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0012R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006,"}, d2={"Lcom/intellij/profiler/eventtrace/intervals/EventToTreeGoogleEventParser;", "Lcom/intellij/profiler/eventtrace/parser/IteratorCombinatorParser;", "Lcom/intellij/profiler/eventtrace/abstractevent/TraceTimeEvent;", "Lcom/intellij/profiler/eventtrace/intervals/TraceEventLineInterval;", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "colors", "", "Lcom/intellij/ui/JBColor;", "googleTraceEventParser", "Lcom/intellij/profiler/eventtrace/parser/events/GoogleTraceEventParser;", "(Ljava/util/concurrent/TimeUnit;[Lcom/intellij/ui/JBColor;Lcom/intellij/profiler/eventtrace/parser/events/GoogleTraceEventParser;)V", "apply", "Lkotlin/Function1;", "", "", "Lkotlin/ExtensionFunctionType;", "getApply", "()Lkotlin/jvm/functions/Function1;", "[Lcom/intellij/ui/JBColor;", "countColor", "", "enter", "", "getEnter", "nameColor", "", "", "getTimeUnit", "()Ljava/util/concurrent/TimeUnit;", "setTimeUnit", "(Ljava/util/concurrent/TimeUnit;)V", "generateNewColor", "getColor", "name", "color", "getInstance", "Lcom/intellij/profiler/eventtrace/intervals/GoogleTraceIntervalEvent;", "event", "Lcom/intellij/profiler/eventtrace/event/CompleteGoogleTraceEvent;", "eventStart", "Lcom/intellij/profiler/eventtrace/event/DurationGoogleTraceEvent;", "eventEnd", "Lcom/intellij/profiler/eventtrace/event/InstantGoogleTraceEvent;", "intellij.profiler.common"})
public final class EventToTreeGoogleEventParser
extends IteratorCombinatorParser<TraceTimeEvent, TraceEventLineInterval> {
    @NotNull
    private TimeUnit timeUnit;
    @NotNull
    private final JBColor[] colors;
    @NotNull
    private final GoogleTraceEventParser googleTraceEventParser;
    private int countColor;
    @NotNull
    private final Map<String, JBColor> nameColor;

    public EventToTreeGoogleEventParser(@NotNull TimeUnit timeUnit, @NotNull JBColor[] colors, @NotNull GoogleTraceEventParser googleTraceEventParser) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        Intrinsics.checkNotNullParameter((Object)googleTraceEventParser, (String)"googleTraceEventParser");
        this.timeUnit = timeUnit;
        this.colors = colors;
        this.googleTraceEventParser = googleTraceEventParser;
        this.nameColor = new HashMap();
    }

    public /* synthetic */ EventToTreeGoogleEventParser(TimeUnit timeUnit, JBColor[] jBColorArray, GoogleTraceEventParser googleTraceEventParser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            JBColor[] jBColorArray2 = new JBColor[2];
            Intrinsics.checkNotNullExpressionValue((Object)JBColor.ORANGE, (String)"ORANGE");
            Intrinsics.checkNotNullExpressionValue((Object)JBColor.YELLOW, (String)"YELLOW");
            jBColorArray = jBColorArray2;
        }
        this(timeUnit, jBColorArray, googleTraceEventParser);
    }

    @NotNull
    public final TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public final void setTimeUnit(@NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"<set-?>");
        this.timeUnit = timeUnit;
    }

    private final JBColor generateNewColor() {
        this.countColor = (this.countColor + 1) % this.colors.length;
        return this.colors[this.countColor];
    }

    private final JBColor getColor(String name, JBColor color2) {
        JBColor jBColor = color2;
        if (jBColor == null) {
            if (name != null) {
                JBColor newColor = this.nameColor.get(name);
                if (newColor == null) {
                    this.nameColor.put(name, this.generateNewColor());
                }
                JBColor jBColor2 = this.nameColor.get(name);
                Intrinsics.checkNotNull((Object)jBColor2);
                return jBColor2;
            }
            jBColor = this.generateNewColor();
        }
        return jBColor;
    }

    @NotNull
    public final GoogleTraceIntervalEvent getInstance(@NotNull CompleteGoogleTraceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getName();
        String string2 = event.getCat();
        long l = event.getTs();
        long l2 = event.getTs() + event.getDur();
        Long l3 = event.getPart().get("pid");
        Intrinsics.checkNotNull((Object)l3);
        long l4 = ((Number)l3).longValue();
        Long l5 = event.getPart().get("tid");
        Intrinsics.checkNotNull((Object)l5);
        return new GoogleTraceIntervalEvent(string, string2, l, l2, l4, ((Number)l5).longValue(), event.getArgs(), (Color)this.getColor(event.getName(), event.getColor()), this.timeUnit);
    }

    @NotNull
    public final GoogleTraceIntervalEvent getInstance(@NotNull DurationGoogleTraceEvent eventStart, @NotNull DurationGoogleTraceEvent eventEnd) {
        Intrinsics.checkNotNullParameter((Object)eventStart, (String)"eventStart");
        Intrinsics.checkNotNullParameter((Object)eventEnd, (String)"eventEnd");
        Long l = eventStart.getPart().get("pid");
        Intrinsics.checkNotNull((Object)l);
        long l2 = ((Number)l).longValue();
        Long l3 = eventEnd.getPart().get("pid");
        Intrinsics.checkNotNull((Object)l3);
        if (l2 != ((Number)l3).longValue()) {
            throw new IllegalArgumentException("Can't get start and end event with different pid");
        }
        Long l4 = eventStart.getPart().get("tid");
        Intrinsics.checkNotNull((Object)l4);
        long l5 = ((Number)l4).longValue();
        Long l6 = eventEnd.getPart().get("tid");
        Intrinsics.checkNotNull((Object)l6);
        if (l5 != ((Number)l6).longValue()) {
            throw new IllegalArgumentException("Can't get start and end event with different tid");
        }
        String string = eventStart.getName();
        String string2 = eventStart.getCat();
        long l7 = eventStart.getTs();
        long l8 = eventEnd.getTs();
        Long l9 = eventStart.getPart().get("pid");
        Intrinsics.checkNotNull((Object)l9);
        long l10 = ((Number)l9).longValue();
        Long l11 = eventStart.getPart().get("tid");
        Intrinsics.checkNotNull((Object)l11);
        return new GoogleTraceIntervalEvent(string, string2, l7, l8, l10, ((Number)l11).longValue(), eventStart.getArgs(), (Color)this.getColor(eventStart.getName(), eventStart.getColor()), this.timeUnit);
    }

    @NotNull
    public final GoogleTraceIntervalEvent getInstance(@NotNull InstantGoogleTraceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getName();
        String string2 = event.getCat();
        long l = event.getTs();
        long l2 = event.getTs() + 1L;
        Long l3 = event.getPart().get("pid");
        Intrinsics.checkNotNull((Object)l3);
        long l4 = ((Number)l3).longValue();
        Long l5 = event.getPart().get("tid");
        Intrinsics.checkNotNull((Object)l5);
        return new GoogleTraceIntervalEvent(string, string2, l, l2, l4, ((Number)l5).longValue(), event.getArgs(), (Color)this.getColor(event.getName(), event.getColor()), this.timeUnit);
    }

    @Override
    @NotNull
    public Function1<Iterator<? extends TraceTimeEvent>, Boolean> getEnter() {
        return enter.1.INSTANCE;
    }

    @Override
    @NotNull
    public Function1<Iterator<? extends TraceTimeEvent>, List<TraceEventLineInterval>> getApply() {
        return (Function1)new Function1<Iterator<? extends TraceTimeEvent>, List<TraceEventLineInterval>>(this){
            final /* synthetic */ EventToTreeGoogleEventParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<TraceEventLineInterval> invoke(@NotNull Iterator<? extends TraceTimeEvent> $this$null) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter($this$null, (String)"$this$null");
                List list = new ArrayList<E>();
                ListIterator<TraceEventLineInterval> iterator2 = list.listIterator();
                Deque openEvents = new LinkedList<E>();
                Iterator<? extends TraceTimeEvent> iterator3 = $this$null;
                EventToTreeGoogleEventParser eventToTreeGoogleEventParser = this.this$0;
                boolean $i$f$forEach = false;
                void var8_8 = $this$forEach$iv;
                while (var8_8.hasNext()) {
                    E element$iv = var8_8.next();
                    TraceTimeEvent it = (TraceTimeEvent)element$iv;
                    boolean bl = false;
                    TraceTimeEvent traceTimeEvent = it;
                    if (traceTimeEvent instanceof DurationGoogleTraceEvent) {
                        String string = ((DurationGoogleTraceEvent)it).getPh();
                        if (Intrinsics.areEqual((Object)string, (Object)"B")) {
                            openEvents.add(it);
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)string, (Object)"E")) continue;
                        if (openEvents.isEmpty()) {
                            throw new IncompleteDurationEventException();
                        }
                        DurationGoogleTraceEvent previous = (DurationGoogleTraceEvent)openEvents.removeLast();
                        Intrinsics.checkNotNullExpressionValue((Object)previous, (String)"previous");
                        iterator2.add(new TraceEventLineInterval(eventToTreeGoogleEventParser.getInstance(previous, (DurationGoogleTraceEvent)it)));
                        continue;
                    }
                    if (traceTimeEvent instanceof CompleteGoogleTraceEvent) {
                        iterator2.add(new TraceEventLineInterval(eventToTreeGoogleEventParser.getInstance((CompleteGoogleTraceEvent)it)));
                        continue;
                    }
                    if (traceTimeEvent instanceof InstantGoogleTraceEvent) {
                        iterator2.add(new TraceEventLineInterval(eventToTreeGoogleEventParser.getInstance((InstantGoogleTraceEvent)it)));
                        continue;
                    }
                    throw new IllegalStateException("Unsupported type of event: " + it);
                }
                return list;
            }
        };
    }
}

