/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.configurations;

import com.intellij.profiler.api.configurations.MigrationFailedException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0003\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/profiler/api/configurations/ExceptionDuringMigrateException;", "Lcom/intellij/profiler/api/configurations/MigrationFailedException;", "migratorName", "", "skippedMigratorNames", "", "underlyingException", "", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/Throwable;)V", "cause", "getCause", "()Ljava/lang/Throwable;", "description", "getDescription", "()Ljava/lang/String;", "intellij.profiler.common"})
public final class ExceptionDuringMigrateException
extends MigrationFailedException {
    @NotNull
    private final String description;
    @NotNull
    private final Throwable cause;

    public ExceptionDuringMigrateException(@NotNull String migratorName, @NotNull List<String> skippedMigratorNames, @NotNull Throwable underlyingException) {
        Intrinsics.checkNotNullParameter((Object)migratorName, (String)"migratorName");
        Intrinsics.checkNotNullParameter(skippedMigratorNames, (String)"skippedMigratorNames");
        Intrinsics.checkNotNullParameter((Object)underlyingException, (String)"underlyingException");
        super(migratorName, skippedMigratorNames);
        this.description = StringsKt.trimIndent((String)("\n    Exception thrown during migration: " + underlyingException.getMessage() + "\n  "));
        this.cause = underlyingException;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Throwable getCause() {
        return this.cause;
    }
}

