/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.JavaModuleTestCase;
import com.intellij.testFramework.PsiTestData;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.StringTokenizer;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class JavaPsiTestCase
extends JavaModuleTestCase {
    protected PsiManagerImpl myPsiManager;
    protected PsiFile myFile;
    private String myDataRoot;
    @Deprecated
    protected PsiTestData myTestDataBefore;
    @Deprecated
    protected PsiTestData myTestDataAfter;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myPsiManager = (PsiManagerImpl)PsiManager.getInstance((Project)this.myProject);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myPsiManager = null;
            this.myFile = null;
            this.myTestDataBefore = null;
            this.myTestDataAfter = null;
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @NotNull
    protected PsiFile createDummyFile(@NotNull String fileName, @NotNull String text) throws IncorrectOperationException {
        if (fileName == null) {
            JavaPsiTestCase.$$$reportNull$$$0(0);
        }
        if (text == null) {
            JavaPsiTestCase.$$$reportNull$$$0(1);
        }
        FileType type = FileTypeRegistry.getInstance().getFileTypeByFileName(fileName);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(fileName, type, (CharSequence)text);
        if (psiFile == null) {
            JavaPsiTestCase.$$$reportNull$$$0(2);
        }
        return psiFile;
    }

    @NotNull
    protected PsiFile createFile(@NonNls @NotNull String fileName, @NotNull String text) throws Exception {
        if (fileName == null) {
            JavaPsiTestCase.$$$reportNull$$$0(3);
        }
        if (text == null) {
            JavaPsiTestCase.$$$reportNull$$$0(4);
        }
        PsiFile psiFile = this.createFile(this.myModule, fileName, text);
        if (psiFile == null) {
            JavaPsiTestCase.$$$reportNull$$$0(5);
        }
        return psiFile;
    }

    @NotNull
    protected PsiFile createFile(@NotNull Module module2, @NotNull String fileName, @NotNull String text) throws Exception {
        if (module2 == null) {
            JavaPsiTestCase.$$$reportNull$$$0(6);
        }
        if (fileName == null) {
            JavaPsiTestCase.$$$reportNull$$$0(7);
        }
        if (text == null) {
            JavaPsiTestCase.$$$reportNull$$$0(8);
        }
        PsiFile psiFile = this.createFile(module2, this.getTempDir().createVirtualDir(), fileName, text);
        if (psiFile == null) {
            JavaPsiTestCase.$$$reportNull$$$0(9);
        }
        return psiFile;
    }

    @NotNull
    protected PsiFile createFile(@NotNull Module module2, @NotNull VirtualFile vDir, @NotNull String fileName, @NotNull String text) throws IOException {
        if (module2 == null) {
            JavaPsiTestCase.$$$reportNull$$$0(10);
        }
        if (vDir == null) {
            JavaPsiTestCase.$$$reportNull$$$0(11);
        }
        if (fileName == null) {
            JavaPsiTestCase.$$$reportNull$$$0(12);
        }
        if (text == null) {
            JavaPsiTestCase.$$$reportNull$$$0(13);
        }
        VirtualFile virtualFile = (VirtualFile)WriteAction.computeAndWait(() -> {
            if (!ModuleRootManager.getInstance((Module)module2).getFileIndex().isInSourceContent(vDir)) {
                this.addSourceContentToRoots(module2, vDir);
            }
            VirtualFile vFile = Objects.requireNonNull(vDir.createChildData((Object)vDir, fileName));
            VfsUtil.saveText((VirtualFile)vFile, (String)text);
            return vFile;
        });
        PsiFile psiFile = Objects.requireNonNull(this.myPsiManager.findFile(virtualFile));
        if (psiFile == null) {
            JavaPsiTestCase.$$$reportNull$$$0(14);
        }
        return psiFile;
    }

    protected void addSourceContentToRoots(@NotNull Module module2, @NotNull VirtualFile vDir) {
        if (module2 == null) {
            JavaPsiTestCase.$$$reportNull$$$0(15);
        }
        if (vDir == null) {
            JavaPsiTestCase.$$$reportNull$$$0(16);
        }
        PsiTestUtil.addSourceContentToRoots(module2, vDir);
    }

    protected PsiElement configureByFileWithMarker(@NotNull String filePath, @NotNull String marker) throws Exception {
        if (filePath == null) {
            JavaPsiTestCase.$$$reportNull$$$0(17);
        }
        if (marker == null) {
            JavaPsiTestCase.$$$reportNull$$$0(18);
        }
        VirtualFile vFile = VfsTestUtil.findFileByCaseSensitivePath(filePath);
        Object fileText = VfsUtilCore.loadText((VirtualFile)vFile);
        int offset = ((String)(fileText = StringUtil.convertLineSeparators((String)fileText))).indexOf(marker);
        JavaPsiTestCase.assertTrue((offset >= 0 ? 1 : 0) != 0);
        fileText = ((String)fileText).substring(0, offset) + ((String)fileText).substring(offset + marker.length());
        this.myFile = this.createFile(vFile.getName(), (String)fileText);
        return this.myFile.findElementAt(offset);
    }

    @Deprecated
    protected void configure(@NotNull String path, String dataName) throws Exception {
        if (path == null) {
            JavaPsiTestCase.$$$reportNull$$$0(19);
        }
        this.myDataRoot = this.getTestDataPath() + path;
        this.myTestDataBefore = this.loadData(dataName);
        PsiTestUtil.removeAllRoots(this.myModule, IdeaTestUtil.getMockJdk17());
        VirtualFile vDir = JavaPsiTestCase.createTestProjectStructure(this.myModule, this.myDataRoot, true, this.getTempDir());
        VirtualFile vFile = vDir.findChild(this.myTestDataBefore.getTextFile());
        this.myFile = this.myPsiManager.findFile(Objects.requireNonNull(vFile));
    }

    @NotNull
    protected String getTestDataPath() {
        String string = PathManagerEx.getTestDataPath();
        if (string == null) {
            JavaPsiTestCase.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    protected String loadFile(@NotNull String name) throws Exception {
        if (name == null) {
            JavaPsiTestCase.$$$reportNull$$$0(21);
        }
        String result2 = FileUtil.loadFile((File)new File(this.getTestDataPath() + File.separatorChar + name));
        String string = StringUtil.convertLineSeparators((String)result2);
        if (string == null) {
            JavaPsiTestCase.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private PsiTestData loadData(String dataName) throws Exception {
        PsiTestData data = this.createData();
        Element documentElement = JDOMUtil.load((Path)Paths.get(this.myDataRoot, "data.xml"));
        for (Element node2 : documentElement.getChildren("data")) {
            String value = node2.getAttributeValue("name");
            if (!value.equals(dataName)) continue;
            DefaultJDOMExternalizer.readExternal((Object)data, (Element)node2);
            data.loadText(this.myDataRoot);
            PsiTestData psiTestData = data;
            if (psiTestData == null) {
                JavaPsiTestCase.$$$reportNull$$$0(23);
            }
            return psiTestData;
        }
        throw new IllegalArgumentException("Cannot find data chunk '" + dataName + "'");
    }

    @Deprecated
    @NotNull
    protected PsiTestData createData() {
        return new PsiTestData();
    }

    @Deprecated
    protected void checkResult(String dataName) throws Exception {
        String actualText;
        this.myTestDataAfter = this.loadData(dataName);
        String textExpected = this.myTestDataAfter.getText();
        if (!textExpected.equals(actualText = this.myFile.getText())) {
            System.out.println("Text mismatch: " + this.getName() + "(" + ((Object)((Object)this)).getClass().getName() + ")");
            System.out.println("Text expected:");
            JavaPsiTestCase.printText(textExpected);
            System.out.println("Text found:");
            JavaPsiTestCase.printText(actualText);
            JavaPsiTestCase.fail((String)"text");
        }
    }

    @Deprecated
    protected static void printText(@NotNull String text) {
        if (text == null) {
            JavaPsiTestCase.$$$reportNull$$$0(24);
        }
        String q = "\"";
        System.out.print("\"");
        text = StringUtil.convertLineSeparators((String)text);
        StringTokenizer tokenizer = new StringTokenizer(text, "\n", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.equals("\n")) {
                System.out.print("\"");
                System.out.println();
                System.out.print("\"");
                continue;
            }
            System.out.print(token);
        }
        System.out.print("\"");
        System.out.println();
    }

    @Deprecated
    protected void addLibraryToRoots(@NotNull VirtualFile jarFile, @NotNull OrderRootType rootType) {
        if (jarFile == null) {
            JavaPsiTestCase.$$$reportNull$$$0(25);
        }
        if (rootType == null) {
            JavaPsiTestCase.$$$reportNull$$$0(26);
        }
        JavaPsiTestCase.addLibraryToRoots(this.myModule, jarFile, rootType);
    }

    @Deprecated
    protected static void addLibraryToRoots(@NotNull Module module2, @NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        if (module2 == null) {
            JavaPsiTestCase.$$$reportNull$$$0(27);
        }
        if (root == null) {
            JavaPsiTestCase.$$$reportNull$$$0(28);
        }
        if (rootType == null) {
            JavaPsiTestCase.$$$reportNull$$$0(29);
        }
        JavaPsiTestCase.assertEquals((Object)OrderRootType.CLASSES, (Object)rootType);
        ModuleRootModificationUtil.addModuleLibrary((Module)module2, (String)root.getUrl());
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public Document getDocument(@NotNull PsiFile file2) {
        if (file2 == null) {
            JavaPsiTestCase.$$$reportNull$$$0(30);
        }
        return PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
    }

    public Document getDocument(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JavaPsiTestCase.$$$reportNull$$$0(31);
        }
        return FileDocumentManager.getInstance().getDocument(file2);
    }

    public void commitDocument(@NotNull Document document) {
        if (document == null) {
            JavaPsiTestCase.$$$reportNull$$$0(32);
        }
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 9, 14, 20, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 14: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/JavaPsiTestCase";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarFile";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/JavaPsiTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyFile";
                break;
            }
            case 5: 
            case 9: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDataPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "loadData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDummyFile";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 14: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addSourceContentToRoots";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "configureByFileWithMarker";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "printText";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addLibraryToRoots";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "commitDocument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 9, 14, 20, 22, 23 -> new IllegalStateException(string);
        };
    }
}

