/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.values;

import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.types.MockType;
import com.intellij.debugger.mockJDI.values.MockPrimitiveValue;
import com.sun.jdi.FloatValue;
import com.sun.jdi.Type;

public class MockFloatValue
extends MockPrimitiveValue
implements FloatValue {
    private final float myValue;

    public MockFloatValue(MockVirtualMachine virtualMachine, float value) {
        super(virtualMachine);
        this.myValue = value;
    }

    @Override
    public Object getValue() {
        return Float.valueOf(this.value());
    }

    @Override
    public float floatValue() {
        return this.myValue;
    }

    @Override
    public Type type() {
        return MockType.createType(this.myVirtualMachine, Float.TYPE);
    }

    @Override
    public float value() {
        return this.myValue;
    }

    @Override
    public int compareTo(FloatValue o) {
        return Float.compare(this.value(), o.value());
    }
}

