/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.named.providers;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.kotlin.org.eclipse.aether.named.providers.FileLockNamedLockFactory$$Lambda$0;
import org.jetbrains.kotlin.org.eclipse.aether.named.providers.FileLockNamedLockFactory$$Lambda$1;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.FileLockNamedLock;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockFactorySupport;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.NamedLockSupport;
import org.jetbrains.kotlin.org.eclipse.aether.named.support.Retry;

@Singleton
@Named(value="file-lock")
public class FileLockNamedLockFactory
extends NamedLockFactorySupport {
    private static final boolean DELETE_LOCK_FILES = Boolean.parseBoolean(System.getProperty("aether.named.file-lock.deleteLockFiles", Boolean.TRUE.toString()));
    private static final int ATTEMPTS = Integer.parseInt(System.getProperty("aether.named.file-lock.attempts", "5"));
    private static final long SLEEP_MILLIS = Long.parseLong(System.getProperty("aether.named.file-lock.sleepMillis", "50"));
    private final ConcurrentMap<String, FileChannel> fileChannels = new ConcurrentHashMap<String, FileChannel>();

    @Override
    protected NamedLockSupport createLock(String name) {
        Path path = Paths.get(name, new String[0]);
        String string = name;
        Path path2 = path;
        FileChannel fileChannel = this.fileChannels.computeIfAbsent(name, new FileLockNamedLockFactory$$Lambda$0(path2, string));
        return new FileLockNamedLock(name, fileChannel, this);
    }

    @Override
    protected void destroyLock(String name) {
        FileChannel fileChannel = (FileChannel)this.fileChannels.remove(name);
        if (fileChannel == null) {
            throw new IllegalStateException("File channel expected, but does not exist: " + name);
        }
        try {
            fileChannel.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close file channel for '" + name + "'", e);
        }
    }

    private static /* synthetic */ FileChannel lambda$createLock$1(Path path, String name, String k) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Path path2 = path;
            FileChannel channel = Retry.retry(ATTEMPTS, SLEEP_MILLIS, new FileLockNamedLockFactory$$Lambda$1(path2), null, null);
            if (channel == null) {
                throw new IllegalStateException("Could not open file channel for '" + name + "' after " + ATTEMPTS + " attempts; giving up");
            }
            return channel;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while opening file channel for '" + name + "'", e);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to open file channel for '" + name + "'", e);
        }
    }

    private static /* synthetic */ FileChannel lambda$createLock$0(Path path) throws Exception {
        try {
            if (DELETE_LOCK_FILES) {
                return FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.DELETE_ON_CLOSE);
            }
            return FileChannel.open(path, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
        }
        catch (AccessDeniedException e) {
            return null;
        }
    }

    static /* synthetic */ FileChannel accessor$FileLockNamedLockFactory$lambda0(Path path, String string, String string2) {
        return FileLockNamedLockFactory.lambda$createLock$1(path, string, string2);
    }

    static /* synthetic */ FileChannel accessor$FileLockNamedLockFactory$lambda1(Path path) {
        return FileLockNamedLockFactory.lambda$createLock$0(path);
    }
}

