/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.testTracking;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.BranchesEnumerator;
import com.intellij.rt.coverage.instrumentation.BranchesInstrumenter;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.DataAccessUtil;
import com.intellij.rt.coverage.instrumentation.util.LocalVariableInserter;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

class TestTrackingClassDataInstrumenter
extends BranchesInstrumenter {
    protected static final String CLASS_DATA_LOCAL_VARIABLE_NAME = "__$classDataLocal$__";
    protected final CoverageDataAccess myDataAccess;

    public TestTrackingClassDataInstrumenter(ProjectData projectData, ClassVisitor classVisitor, ClassReader cr, String className, boolean shouldSaveSource, CoverageDataAccess dataAccess) {
        super(projectData, classVisitor, className, shouldSaveSource, dataAccess);
        this.myDataAccess = DataAccessUtil.createTestTrackingDataAccess(className, cr, false);
    }

    public MethodVisitor createInstrumentingVisitor(MethodVisitor mv, BranchesEnumerator enumerator, int access, String name, String desc) {
        mv = super.createInstrumentingVisitor(mv, enumerator, access, name, desc);
        return this.createMethodTransformer(mv, enumerator, access, name, desc);
    }

    protected MethodVisitor createMethodTransformer(MethodVisitor mv, BranchesEnumerator enumerator, int access, String name, String desc) {
        if (enumerator.hasNoLines()) {
            return this.myDataAccess.createMethodVisitor(mv, name, false);
        }
        LocalVariableInserter visitor = new LocalVariableInserter(mv, access, desc, CLASS_DATA_LOCAL_VARIABLE_NAME, "Ljava/lang/Object;"){

            public void visitLineNumber(int line, Label start) {
                LineData lineData = TestTrackingClassDataInstrumenter.this.getLineData(line);
                if (lineData != null) {
                    this.mv.visitVarInsn(25, this.getLVIndex());
                    InstrumentationUtils.pushInt(this.mv, line);
                    this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "traceLine", "(Ljava/lang/Object;I)V", false);
                }
                super.visitLineNumber(line, start);
            }

            public void visitCode() {
                TestTrackingClassDataInstrumenter.this.myDataAccess.onMethodStart(this.mv, this.getLVIndex());
                super.visitCode();
            }
        };
        return this.myDataAccess.createMethodVisitor(visitor, name, true);
    }

    public void visitEnd() {
        this.myDataAccess.onClassEnd(this);
        super.visitEnd();
    }
}

