/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.branches;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.KotlinUtils;
import com.intellij.rt.coverage.instrumentation.filters.branches.BranchesFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.Type;

public class KotlinDefaultArgsBranchFilter
extends BranchesFilter {
    public static final String DEFAULT_ARGS_SUFFIX = "$default";
    private int myMaxMaskIndex = -1;
    private int myMinMaskIndex = -1;
    private boolean myIgnoreNextIf = false;
    private boolean myAndVisited = false;
    private String myName;
    private String myDesc;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        this.myName = name;
        this.myDesc = desc;
        return KotlinDefaultArgsBranchFilter.isApplicable(context, access, name, desc);
    }

    public static boolean isApplicable(Instrumenter context, int access, String name, String desc) {
        return (access & 0x1000) != 0 && KotlinUtils.isKotlinClass(context) && (name.endsWith(DEFAULT_ARGS_SUFFIX) || KotlinDefaultArgsBranchFilter.isConstructorWithDefaultArgs(name, desc));
    }

    private static boolean isConstructorWithDefaultArgs(String name, String desc) {
        return "<init>".equals(name) && desc != null && desc.endsWith("ILkotlin/jvm/internal/DefaultConstructorMarker;)V");
    }

    static int sourceParametersCount(int z) {
        return z - 1 - (z - 1 + 32) / 33;
    }

    public void visitCode() {
        super.visitCode();
        int[] range = KotlinDefaultArgsBranchFilter.getMaskIndexRange(this.myName, this.myDesc);
        this.myMinMaskIndex = range[0];
        this.myMaxMaskIndex = range[1];
    }

    public static String getOriginalNameAndDesc(String name, String desc) {
        Type type = Type.getType(desc);
        Type[] parameters = type.getArgumentTypes();
        StringBuilder builder = new StringBuilder();
        if ("<init>".equals(name)) {
            builder.append(name);
        } else if (name.endsWith(DEFAULT_ARGS_SUFFIX)) {
            builder.append(name, 0, name.length() - DEFAULT_ARGS_SUFFIX.length());
        }
        int sourceCount = KotlinDefaultArgsBranchFilter.sourceParametersCount(parameters.length);
        builder.append('(');
        for (int i = 0; i < sourceCount; ++i) {
            builder.append(parameters[i].getDescriptor());
        }
        builder.append(')');
        builder.append(type.getReturnType().getDescriptor());
        return builder.toString();
    }

    public static int[] getMaskIndexRange(String name, String desc) {
        Type[] parameters = Type.getType(desc).getArgumentTypes();
        int sourceCount = KotlinDefaultArgsBranchFilter.sourceParametersCount(parameters.length);
        int size = 0;
        int minIndex = -1;
        for (int i = 0; i < parameters.length - 2; ++i) {
            size += parameters[i].getSize();
            if (i != sourceCount - 1) continue;
            minIndex = size;
        }
        if ("<init>".equals(name)) {
            // empty if block
        }
        return new int[]{++minIndex, ++size};
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        this.myIgnoreNextIf = this.myMinMaskIndex <= var && var <= this.myMaxMaskIndex;
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        this.myAndVisited |= this.myIgnoreNextIf && opcode == 126;
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        if (opcode == 153 && this.myIgnoreNextIf) {
            if (this.myAndVisited) {
                this.myBranchData.removeLastJump();
            }
            this.myIgnoreNextIf = false;
            this.myAndVisited = false;
        }
    }
}

