/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.branches;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.data.BranchDataContainer;
import com.intellij.rt.coverage.instrumentation.filters.KotlinCoroutinesFilter;
import com.intellij.rt.coverage.instrumentation.filters.branches.BranchesFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinCoroutinesBranchesFilter
extends BranchesFilter {
    public void initFilter(MethodVisitor mv, Instrumenter context, BranchDataContainer branchData) {
        super.initFilter(new InternalFilter(mv, context), context, branchData);
    }

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinCoroutinesFilter.isApplicable(context, name, desc);
    }

    private class InternalFilter
    extends KotlinCoroutinesFilter {
        public InternalFilter(MethodVisitor methodVisitor, Instrumenter context) {
            super(methodVisitor, context);
        }

        protected void onIgnoredJump() {
            KotlinCoroutinesBranchesFilter.this.myBranchData.removeLastJump();
        }

        protected void onIgnoredSwitch(Label dflt, Label ... labels) {
            KotlinCoroutinesBranchesFilter.this.myBranchData.removeLastSwitch(dflt, labels);
        }
    }
}

