/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Collections;
import java.util.stream.Collectors;
import org.gradle.api.tasks.testing.TestExecutionException;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.internal.RunDefaultTasksExecutionRequest;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.operations.BuildOperationAncestryTracker;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.tooling.internal.protocol.test.InternalTaskSpec;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionException;
import org.gradle.tooling.internal.provider.action.TestExecutionRequestAction;
import org.gradle.tooling.internal.provider.runner.TestExecutionBuildConfigurationAction;
import org.gradle.tooling.internal.provider.runner.TestExecutionResultEvaluator;

public class TestExecutionRequestActionRunner
implements BuildActionRunner {
    private final BuildOperationAncestryTracker ancestryTracker;
    private final BuildOperationListenerManager buildOperationListenerManager;

    public TestExecutionRequestActionRunner(BuildOperationAncestryTracker ancestryTracker, BuildOperationListenerManager buildOperationListenerManager) {
        this.ancestryTracker = ancestryTracker;
        this.buildOperationListenerManager = buildOperationListenerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        if (!(action instanceof TestExecutionRequestAction)) {
            return BuildActionRunner.Result.nothing();
        }
        try {
            TestExecutionRequestAction testExecutionRequestAction = (TestExecutionRequestAction)action;
            TestExecutionResultEvaluator testExecutionResultEvaluator = new TestExecutionResultEvaluator(this.ancestryTracker, testExecutionRequestAction);
            this.buildOperationListenerManager.addListener(testExecutionResultEvaluator);
            try {
                this.doRun(testExecutionRequestAction, buildController);
            }
            finally {
                this.buildOperationListenerManager.removeListener(testExecutionResultEvaluator);
            }
            testExecutionResultEvaluator.evaluate();
        }
        catch (RuntimeException e) {
            Throwable throwable = this.findRootCause(e);
            if (throwable instanceof TestExecutionException) {
                return BuildActionRunner.Result.failed(e, new InternalTestExecutionException("Error while running test(s)", throwable));
            }
            return BuildActionRunner.Result.failed(e);
        }
        return BuildActionRunner.Result.of(null);
    }

    private void doRun(TestExecutionRequestAction action, BuildTreeLifecycleController buildController) {
        if (!action.getTaskSpecs().isEmpty()) {
            action.getStartParameter().setTaskRequests(Collections.singletonList(new DefaultTaskExecutionRequest(action.getTaskSpecs().stream().map(InternalTaskSpec::getTaskPath).collect(Collectors.toList()))));
        } else if (action.isRunDefaultTasks()) {
            action.getStartParameter().setTaskRequests(Collections.singletonList(new RunDefaultTasksExecutionRequest()));
        } else {
            action.getStartParameter().setTaskRequests(Collections.emptyList());
        }
        buildController.scheduleAndRunTasks(new TestExecutionBuildConfigurationAction(action));
    }

    private Throwable findRootCause(Exception tex) {
        Throwable t = tex;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }
}

