/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.asm;

import java.util.List;
import org.gradle.internal.impldep.org.objectweb.asm.Handle;
import org.gradle.internal.impldep.org.objectweb.asm.Label;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Type;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.model.internal.asm.BytecodeFragment;

public class MethodVisitorScope
extends MethodVisitor {
    private static final String BOXED_BOOLEAN_TYPE = Type.getType(Boolean.class).getInternalName();
    private static final String BOXED_CHAR_TYPE = Type.getType(Character.class).getInternalName();
    private static final String BOXED_BYTE_TYPE = Type.getType(Byte.class).getInternalName();
    private static final String BOXED_SHORT_TYPE = Type.getType(Short.class).getInternalName();
    private static final String BOXED_INT_TYPE = Type.getType(Integer.class).getInternalName();
    private static final String BOXED_LONG_TYPE = Type.getType(Long.class).getInternalName();
    private static final String BOXED_FLOAT_TYPE = Type.getType(Float.class).getInternalName();
    private static final String BOXED_DOUBLE_TYPE = Type.getType(Double.class).getInternalName();
    private static final String RETURN_PRIMITIVE_BOOLEAN = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]);
    private static final String RETURN_CHAR = Type.getMethodDescriptor((Type)Type.CHAR_TYPE, (Type[])new Type[0]);
    private static final String RETURN_PRIMITIVE_BYTE = Type.getMethodDescriptor((Type)Type.BYTE_TYPE, (Type[])new Type[0]);
    private static final String RETURN_PRIMITIVE_SHORT = Type.getMethodDescriptor((Type)Type.SHORT_TYPE, (Type[])new Type[0]);
    private static final String RETURN_INT = Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]);
    private static final String RETURN_PRIMITIVE_LONG = Type.getMethodDescriptor((Type)Type.LONG_TYPE, (Type[])new Type[0]);
    private static final String RETURN_PRIMITIVE_FLOAT = Type.getMethodDescriptor((Type)Type.FLOAT_TYPE, (Type[])new Type[0]);
    private static final String RETURN_PRIMITIVE_DOUBLE = Type.getMethodDescriptor((Type)Type.DOUBLE_TYPE, (Type[])new Type[0]);

    public MethodVisitorScope(MethodVisitor methodVisitor) {
        super(589824, methodVisitor);
    }

    protected void emit(BytecodeFragment bytecode) {
        bytecode.emit(this.mv);
    }

    protected void _UNBOX(Type targetType) {
        switch (targetType.getSort()) {
            case 1: {
                this.unbox(BOXED_BOOLEAN_TYPE, "booleanValue", RETURN_PRIMITIVE_BOOLEAN);
                break;
            }
            case 2: {
                this.unbox(BOXED_CHAR_TYPE, "charValue", RETURN_CHAR);
                break;
            }
            case 3: {
                this.unbox(BOXED_BYTE_TYPE, "byteValue", RETURN_PRIMITIVE_BYTE);
                break;
            }
            case 4: {
                this.unbox(BOXED_SHORT_TYPE, "shortValue", RETURN_PRIMITIVE_SHORT);
                break;
            }
            case 5: {
                this.unbox(BOXED_INT_TYPE, "intValue", RETURN_INT);
                break;
            }
            case 7: {
                this.unbox(BOXED_LONG_TYPE, "longValue", RETURN_PRIMITIVE_LONG);
                break;
            }
            case 6: {
                this.unbox(BOXED_FLOAT_TYPE, "floatValue", RETURN_PRIMITIVE_FLOAT);
                break;
            }
            case 8: {
                this.unbox(BOXED_DOUBLE_TYPE, "doubleValue", RETURN_PRIMITIVE_DOUBLE);
                break;
            }
            default: {
                this._CHECKCAST(targetType);
            }
        }
    }

    private void unbox(String boxedType, String unboxMethod, String unboxMethodDescriptor) {
        this._CHECKCAST(boxedType);
        this._INVOKEVIRTUAL(boxedType, unboxMethod, unboxMethodDescriptor);
    }

    protected void _AUTOBOX(Class<?> valueClass, Type valueType) {
        if (valueClass.isPrimitive()) {
            Type boxedType = Type.getType(JavaReflectionUtil.getWrapperTypeForPrimitiveType(valueClass));
            this._INVOKESTATIC(boxedType, "valueOf", Type.getMethodDescriptor((Type)boxedType, (Type[])new Type[]{valueType}));
        }
    }

    protected void _F_SAME() {
        super.visitFrame(3, 0, new Object[0], 0, new Object[0]);
    }

    protected void _INVOKESPECIAL(Type owner, String name, String descriptor) {
        this._INVOKESPECIAL(owner.getInternalName(), name, descriptor);
    }

    protected void _INVOKESPECIAL(String owner, String name, String descriptor) {
        this._INVOKESPECIAL(owner, name, descriptor, false);
    }

    protected void _INVOKESPECIAL(Type owner, String name, String descriptor, boolean isInterface) {
        this._INVOKESPECIAL(owner.getInternalName(), name, descriptor, isInterface);
    }

    protected void _INVOKESPECIAL(String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(183, owner, name, descriptor, isInterface);
    }

    protected void _INVOKEINTERFACE(Type owner, String name, String descriptor) {
        this._INVOKEINTERFACE(owner.getInternalName(), name, descriptor);
    }

    protected void _INVOKEINTERFACE(String owner, String name, String descriptor) {
        super.visitMethodInsn(185, owner, name, descriptor, true);
    }

    protected void _INVOKESTATIC(Type owner, String name, String descriptor) {
        this._INVOKESTATIC(owner.getInternalName(), name, descriptor);
    }

    protected void _INVOKESTATIC(String owner, String name, String descriptor) {
        super.visitMethodInsn(184, owner, name, descriptor, false);
    }

    protected void _INVOKESTATIC(String owner, String name, String descriptor, boolean targetIsInterface) {
        super.visitMethodInsn(184, owner, name, descriptor, targetIsInterface);
    }

    protected void _INVOKEVIRTUAL(Type owner, String name, String descriptor) {
        this._INVOKEVIRTUAL(owner.getInternalName(), name, descriptor);
    }

    protected void _INVOKEVIRTUAL(String owner, String name, String descriptor) {
        super.visitMethodInsn(182, owner, name, descriptor, false);
    }

    protected void _INVOKEDYNAMIC(String name, String descriptor, Handle bootstrapMethodHandle, List<?> bootstrapMethodArguments) {
        super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments.toArray());
    }

    protected void _SWAP() {
        super.visitInsn(95);
    }

    protected void _POP() {
        super.visitInsn(87);
    }

    protected void _DUP() {
        super.visitInsn(89);
    }

    protected void _ICONST_0() {
        super.visitInsn(3);
    }

    protected void _ICONST_1() {
        super.visitInsn(4);
    }

    protected void _ACONST_NULL() {
        super.visitInsn(1);
    }

    protected void _LDC(Object value) {
        super.visitLdcInsn(value);
    }

    protected void _NEW(Type type) {
        super.visitTypeInsn(187, type.getInternalName());
    }

    protected void _CHECKCAST(Type type) {
        this._CHECKCAST(type.getInternalName());
    }

    private void _CHECKCAST(String internalName) {
        super.visitTypeInsn(192, internalName);
    }

    protected void _INSTANCEOF(Type type) {
        super.visitTypeInsn(193, type.getInternalName());
    }

    protected void _ILOAD_OF(Type type, int var) {
        super.visitVarInsn(type.getOpcode(21), var);
    }

    protected void _ALOAD(int var) {
        super.visitVarInsn(25, var);
    }

    protected void _ASTORE(int var) {
        super.visitVarInsn(58, var);
    }

    protected void _ANEWARRAY(Type type) {
        super.visitTypeInsn(189, type.getInternalName());
    }

    protected void _AALOAD() {
        super.visitInsn(50);
    }

    protected void _AASTORE() {
        super.visitInsn(83);
    }

    protected void _IFNONNULL(Label label) {
        super.visitJumpInsn(199, label);
    }

    protected void _IFNULL(Label label) {
        super.visitJumpInsn(198, label);
    }

    protected void _IFEQ(Label label) {
        super.visitJumpInsn(153, label);
    }

    protected void _GOTO(Label label) {
        super.visitJumpInsn(167, label);
    }

    protected void _ARETURN() {
        super.visitInsn(176);
    }

    protected void _IRETURN_OF(Type type) {
        super.visitInsn(type.getOpcode(172));
    }

    protected void _IRETURN() {
        super.visitInsn(172);
    }

    protected void _RETURN() {
        super.visitInsn(177);
    }

    protected void _PUTFIELD(String owner, String name, String descriptor) {
        super.visitFieldInsn(181, owner, name, descriptor);
    }

    protected void _PUTFIELD(String owner, String name, Type fieldType) {
        this._PUTFIELD(owner, name, fieldType.getDescriptor());
    }

    protected void _PUTFIELD(Type owner, String name, Type fieldType) {
        this._PUTFIELD(owner, name, fieldType.getDescriptor());
    }

    protected void _PUTFIELD(Type owner, String name, String descriptor) {
        this._PUTFIELD(owner.getInternalName(), name, descriptor);
    }

    protected void _GETFIELD(String owner, String name, String descriptor) {
        super.visitFieldInsn(180, owner, name, descriptor);
    }

    protected void _GETFIELD(String owner, String name, Type fieldType) {
        this._GETFIELD(owner, name, fieldType.getDescriptor());
    }

    protected void _GETFIELD(Type owner, String name, Type fieldType) {
        this._GETFIELD(owner, name, fieldType.getDescriptor());
    }

    protected void _GETFIELD(Type owner, String name, String descriptor) {
        this._GETFIELD(owner.getInternalName(), name, descriptor);
    }

    protected void _PUTSTATIC(String owner, String name, String descriptor) {
        super.visitFieldInsn(179, owner, name, descriptor);
    }

    protected void _PUTSTATIC(Type owner, String name, Type fieldType) {
        this._PUTSTATIC(owner, name, fieldType.getDescriptor());
    }

    protected void _PUTSTATIC(Type owner, String name, String descriptor) {
        this._PUTSTATIC(owner.getInternalName(), name, descriptor);
    }

    protected void _GETSTATIC(String owner, String name, String descriptor) {
        super.visitFieldInsn(178, owner, name, descriptor);
    }

    protected void _GETSTATIC(Type owner, String name, Type fieldType) {
        this._GETSTATIC(owner, name, fieldType.getDescriptor());
    }

    protected void _GETSTATIC(Type owner, String name, String descriptor) {
        this._GETSTATIC(owner.getInternalName(), name, descriptor);
    }
}

