/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationConverterToNotationParserAdapter;
import org.gradle.internal.typeconversion.TypeConversionException;

public class CrossBuildCachingNotationConverter<T>
implements NotationConverter<Object, T> {
    private final CrossBuildInMemoryCache<Object, T> cache;
    private final NotationConverterToNotationParserAdapter<Object, T> delegate;

    public CrossBuildCachingNotationConverter(NotationConverter<Object, T> delegate, CrossBuildInMemoryCache<Object, T> cache) {
        this.cache = cache;
        this.delegate = new NotationConverterToNotationParserAdapter<Object, T>(delegate);
    }

    @Override
    public void convert(Object notation, NotationConvertResult<? super T> result2) throws TypeConversionException {
        Object value = this.cache.get(notation, () -> this.delegate.parseNotation(notation));
        result2.converted(value);
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        this.delegate.describe(visitor);
    }
}

