/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.snapshot.AbstractFileSystemLocationSnapshot;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.ChildMap;
import org.gradle.internal.snapshot.ChildMapFactory;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemNode;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.MetadataSnapshot;
import org.gradle.internal.snapshot.PartialDirectoryNode;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.RelativePathTrackingFileSystemSnapshotHierarchyVisitor;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.internal.snapshot.VfsRelativePath;

public class DirectorySnapshot
extends AbstractFileSystemLocationSnapshot {
    private final ChildMap<FileSystemLocationSnapshot> children;
    private final HashCode contentHash;

    public DirectorySnapshot(String absolutePath, String name, FileMetadata.AccessType accessType, HashCode contentHash, List<FileSystemLocationSnapshot> children) {
        this(absolutePath, name, accessType, contentHash, ChildMapFactory.childMapFromSorted(children.stream().map(it -> new ChildMap.Entry<FileSystemLocationSnapshot>(it.getName(), (FileSystemLocationSnapshot)it)).collect(Collectors.toList())));
    }

    public DirectorySnapshot(String absolutePath, String name, FileMetadata.AccessType accessType, HashCode contentHash, ChildMap<FileSystemLocationSnapshot> children) {
        super(absolutePath, name, accessType);
        this.contentHash = contentHash;
        this.children = children;
    }

    @Override
    public HashCode getHash() {
        return this.contentHash;
    }

    @Override
    public FileType getType() {
        return FileType.Directory;
    }

    @Override
    public boolean isContentAndMetadataUpToDate(FileSystemLocationSnapshot other) {
        return this.isContentUpToDate(other);
    }

    @Override
    public boolean isContentUpToDate(FileSystemLocationSnapshot other) {
        return other instanceof DirectorySnapshot;
    }

    @Override
    public SnapshotVisitResult accept(FileSystemSnapshotHierarchyVisitor visitor) {
        SnapshotVisitResult result2 = visitor.visitEntry(this);
        switch (result2) {
            case CONTINUE: {
                visitor.enterDirectory(this);
                this.children.stream().map(ChildMap.Entry::getValue).forEach(child -> child.accept(visitor));
                visitor.leaveDirectory(this);
                return SnapshotVisitResult.CONTINUE;
            }
            case SKIP_SUBTREE: {
                return SnapshotVisitResult.CONTINUE;
            }
            case TERMINATE: {
                return SnapshotVisitResult.TERMINATE;
            }
        }
        throw new AssertionError();
    }

    @Override
    public SnapshotVisitResult accept(RelativePathTracker pathTracker, RelativePathTrackingFileSystemSnapshotHierarchyVisitor visitor) {
        pathTracker.enter(this.getName());
        try {
            SnapshotVisitResult result2 = visitor.visitEntry(this, pathTracker);
            switch (result2) {
                case CONTINUE: {
                    visitor.enterDirectory(this, pathTracker);
                    this.children.stream().map(ChildMap.Entry::getValue).forEach(child -> child.accept(pathTracker, visitor));
                    visitor.leaveDirectory(this, pathTracker);
                    SnapshotVisitResult snapshotVisitResult = SnapshotVisitResult.CONTINUE;
                    return snapshotVisitResult;
                }
                case SKIP_SUBTREE: {
                    SnapshotVisitResult snapshotVisitResult = SnapshotVisitResult.CONTINUE;
                    return snapshotVisitResult;
                }
                case TERMINATE: {
                    SnapshotVisitResult snapshotVisitResult = SnapshotVisitResult.TERMINATE;
                    return snapshotVisitResult;
                }
            }
            throw new AssertionError();
        }
        finally {
            pathTracker.leave();
        }
    }

    @Override
    public void accept(FileSystemLocationSnapshot.FileSystemLocationSnapshotVisitor visitor) {
        visitor.visitDirectory(this);
    }

    @Override
    public <T> T accept(FileSystemLocationSnapshot.FileSystemLocationSnapshotTransformer<T> transformer) {
        return transformer.visitDirectory(this);
    }

    @VisibleForTesting
    public ImmutableList<FileSystemLocationSnapshot> getChildren() {
        return (ImmutableList)this.children.stream().map(ChildMap.Entry::getValue).collect(ImmutableList.toImmutableList());
    }

    @Override
    protected Optional<MetadataSnapshot> getChildSnapshot(VfsRelativePath targetPath, CaseSensitivity caseSensitivity) {
        return Optional.of(SnapshotUtil.getMetadataFromChildren(this.children, targetPath, caseSensitivity, Optional::empty).orElseGet(() -> DirectorySnapshot.missingSnapshotForAbsolutePath(targetPath.getAbsolutePath())));
    }

    @Override
    protected FileSystemNode getChildNode(VfsRelativePath targetPath, CaseSensitivity caseSensitivity) {
        Optional<FileSystemNode> childNode = SnapshotUtil.getChild(this.children, targetPath, caseSensitivity);
        return childNode.orElseGet(() -> DirectorySnapshot.missingSnapshotForAbsolutePath(targetPath.getAbsolutePath()));
    }

    @Override
    public Optional<FileSystemNode> invalidate(VfsRelativePath targetPath, final CaseSensitivity caseSensitivity, final SnapshotHierarchy.NodeDiffListener diffListener) {
        ChildMap<FileSystemNode> newChildren = this.children.invalidate(targetPath, caseSensitivity, new ChildMap.InvalidationHandler<FileSystemLocationSnapshot, FileSystemNode>(){

            @Override
            public Optional<FileSystemNode> handleAsDescendantOfChild(VfsRelativePath pathInChild, FileSystemLocationSnapshot child) {
                diffListener.nodeRemoved(DirectorySnapshot.this);
                Optional<FileSystemNode> invalidated = child.invalidate(pathInChild, caseSensitivity, new SnapshotHierarchy.NodeDiffListener(){

                    @Override
                    public void nodeRemoved(FileSystemNode node) {
                    }

                    @Override
                    public void nodeAdded(FileSystemNode node) {
                        diffListener.nodeAdded(node);
                    }
                });
                DirectorySnapshot.this.children.stream().map(ChildMap.Entry::getValue).filter(existingChild -> existingChild != child).forEach(diffListener::nodeAdded);
                return invalidated;
            }

            @Override
            public void handleAsAncestorOfChild(String childPath, FileSystemLocationSnapshot child) {
                throw new IllegalStateException("Can't have an ancestor of a single path element");
            }

            @Override
            public void handleExactMatchWithChild(FileSystemLocationSnapshot child) {
                diffListener.nodeRemoved(DirectorySnapshot.this);
                DirectorySnapshot.this.children.stream().map(ChildMap.Entry::getValue).filter(existingChild -> existingChild != child).forEach(diffListener::nodeAdded);
            }

            @Override
            public void handleUnrelatedToAnyChild() {
                diffListener.nodeRemoved(DirectorySnapshot.this);
                DirectorySnapshot.this.children.stream().map(ChildMap.Entry::getValue).forEach(diffListener::nodeAdded);
            }
        });
        return Optional.of(new PartialDirectoryNode(newChildren));
    }

    @Override
    public String toString() {
        return String.format("%s@%s/%s(%s)", super.toString(), this.contentHash, this.getName(), this.children);
    }
}

