/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local.ivy;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.SingleIncludePatternFileTree;
import org.gradle.internal.Factory;
import org.gradle.internal.InternalTransformer;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.resource.local.AbstractLocallyAvailableResourceFinder;

public class PatternBasedLocallyAvailableResourceFinder
extends AbstractLocallyAvailableResourceFinder<ModuleComponentArtifactMetadata> {
    public PatternBasedLocallyAvailableResourceFinder(File baseDir, ResourcePattern pattern, ChecksumService checksumService) {
        super(PatternBasedLocallyAvailableResourceFinder.createProducer(baseDir, pattern), checksumService);
    }

    private static InternalTransformer<Factory<List<File>>, ModuleComponentArtifactMetadata> createProducer(final File baseDir, final ResourcePattern pattern) {
        return new InternalTransformer<Factory<List<File>>, ModuleComponentArtifactMetadata>(){

            @Override
            public Factory<List<File>> transform(ModuleComponentArtifactMetadata artifact) {
                return () -> {
                    final LinkedList files = new LinkedList();
                    if (artifact != null) {
                        this.getMatchingFiles(artifact).visit(new EmptyFileVisitor(){

                            @Override
                            public void visitFile(FileVisitDetails fileDetails) {
                                files.add(fileDetails.getFile());
                            }
                        });
                    }
                    return files;
                };
            }

            private MinimalFileTree getMatchingFiles(ModuleComponentArtifactMetadata artifact) {
                String patternString = pattern.getLocation(artifact).getPath();
                return new SingleIncludePatternFileTree(baseDir, patternString);
            }
        };
    }
}

