/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import java.util.List;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemLocation;
import org.gradle.model.internal.type.ModelType;
import org.gradle.plugin.use.PluginId;
import org.gradle.problems.Solution;
import org.gradle.util.internal.TextUtil;

public class TypeValidationProblemRenderer {
    public static String renderMinimalInformationAbout(TypeValidationProblem problem2) {
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(problem2, true);
    }

    public static String renderMinimalInformationAbout(TypeValidationProblem problem2, boolean renderDocLink) {
        return TypeValidationProblemRenderer.renderMinimalInformationAbout(problem2, renderDocLink, true);
    }

    public static String renderMinimalInformationAbout(TypeValidationProblem problem2, boolean renderDocLink, boolean renderSolutions) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node(TypeValidationProblemRenderer.introductionFor((TypeValidationProblemLocation)problem2.getWhere()) + TextUtil.endLineWithDot(problem2.getShortDescription()));
        problem2.getWhy().ifPresent(reason -> {
            formatter.blankLine();
            formatter.node("Reason: " + StringUtils.capitalize((String)TextUtil.endLineWithDot(reason)));
        });
        if (renderSolutions) {
            TypeValidationProblemRenderer.renderSolutions(formatter, problem2.getPossibleSolutions());
        }
        if (renderDocLink) {
            problem2.getDocumentationLink().ifPresent(docLink -> {
                formatter.blankLine();
                formatter.node((String)docLink);
            });
        }
        return formatter.toString();
    }

    public static void renderSolutions(TreeFormatter formatter, List<Solution> possibleSolutions) {
        int solutionCount = possibleSolutions.size();
        if (solutionCount > 0) {
            formatter.blankLine();
            if (solutionCount == 1) {
                formatter.node("Possible solution: " + StringUtils.capitalize((String)TextUtil.endLineWithDot(possibleSolutions.get(0).getShortDescription())));
            } else {
                formatter.node("Possible solutions");
                formatter.startNumberedChildren();
                possibleSolutions.forEach(solution -> formatter.node(StringUtils.capitalize((String)TextUtil.endLineWithDot(solution.getShortDescription()))));
                formatter.endChildren();
            }
        }
    }

    public static String convertToSingleLine(String message2) {
        return message2.replaceAll("(\\r?\\n *)+", ". ").replaceAll("[.]+", ".").replaceAll("[ ]+", " ").replaceAll(": ?[. ]", ": ");
    }

    private static String introductionFor(TypeValidationProblemLocation location) {
        String property2;
        StringBuilder builder = new StringBuilder();
        Class rootType = location.getType().filter(TypeValidationProblemRenderer::shouldRenderType).orElse(null);
        PluginId pluginId = location.getPlugin().orElse(null);
        if (rootType != null) {
            if (pluginId != null) {
                builder.append("In plugin '").append(pluginId).append("' type '");
            } else {
                builder.append("Type '");
            }
            builder.append(ModelType.of(rootType).getName()).append("' ");
        }
        if ((property2 = (String)location.getPropertyName().orElse(null)) != null) {
            if (rootType == null) {
                if (pluginId != null) {
                    builder.append("In plugin '").append(pluginId).append("' property '");
                } else {
                    builder.append("Property '");
                }
            } else {
                builder.append("property '");
            }
            location.getParentPropertyName().ifPresent(parentProperty -> {
                builder.append((String)parentProperty);
                builder.append('.');
            });
            builder.append(property2).append("' ");
        }
        return builder.toString();
    }

    private static boolean shouldRenderType(Class<?> clazz) {
        return !"org.gradle.api.DefaultTask".equals(clazz.getName());
    }
}

