/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.serializer;

import java.util.List;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class StyledTextOutputEventSerializer
implements Serializer<StyledTextOutputEvent> {
    private final Serializer<LogLevel> logLevelSerializer;
    private final Serializer<List<StyledTextOutputEvent.Span>> spanSerializer;

    public StyledTextOutputEventSerializer(Serializer<LogLevel> logLevelSerializer, Serializer<List<StyledTextOutputEvent.Span>> spanSerializer) {
        this.logLevelSerializer = logLevelSerializer;
        this.spanSerializer = spanSerializer;
    }

    @Override
    public void write(Encoder encoder, StyledTextOutputEvent event) throws Exception {
        encoder.writeLong(event.getTimestamp());
        encoder.writeString(event.getCategory());
        this.logLevelSerializer.write(encoder, event.getLogLevel());
        if (event.getBuildOperationId() == null) {
            encoder.writeBoolean(false);
        } else {
            encoder.writeBoolean(true);
            encoder.writeSmallLong(event.getBuildOperationId().getId());
        }
        this.spanSerializer.write(encoder, event.getSpans());
    }

    @Override
    public StyledTextOutputEvent read(Decoder decoder) throws Exception {
        long timestamp = decoder.readLong();
        String category = decoder.readString();
        LogLevel logLevel = this.logLevelSerializer.read(decoder);
        OperationIdentifier buildOperationId = decoder.readBoolean() ? new OperationIdentifier(decoder.readSmallLong()) : null;
        List<StyledTextOutputEvent.Span> spans = this.spanSerializer.read(decoder);
        return new StyledTextOutputEvent(timestamp, category, logLevel, buildOperationId, spans);
    }
}

