/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ArtifactIdentifier;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.HasAttributes;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDescriber;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.capabilities.CapabilitiesMetadataInternal;
import org.gradle.api.internal.capabilities.ShadowedCapability;
import org.gradle.internal.Cast;
import org.gradle.internal.component.AmbiguousConfigurationSelectionException;
import org.gradle.internal.component.NoMatchingCapabilitiesException;
import org.gradle.internal.component.NoMatchingConfigurationSelectionException;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.AttributeMatchingExplanationBuilder;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ConfigurationGraphResolveMetadata;
import org.gradle.internal.component.model.DescriberSelector;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveMetadata;
import org.gradle.internal.component.model.VariantSelectionResult;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public abstract class AttributeConfigurationSelector {
    public static VariantSelectionResult selectVariantsUsingAttributeMatching(ImmutableAttributes consumerAttributes, Collection<? extends Capability> explicitRequestedCapabilities, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema, List<IvyArtifactName> requestedArtifacts) {
        return AttributeConfigurationSelector.selectVariantsUsingAttributeMatching(consumerAttributes, explicitRequestedCapabilities, targetComponentState, consumerSchema, requestedArtifacts, AttributeMatchingExplanationBuilder.logging());
    }

    private static VariantSelectionResult selectVariantsUsingAttributeMatching(ImmutableAttributes consumerAttributes, Collection<? extends Capability> explicitRequestedCapabilities, ComponentGraphResolveState targetComponentState, AttributesSchemaInternal consumerSchema, List<IvyArtifactName> requestedArtifacts, AttributeMatchingExplanationBuilder explanationBuilder) {
        AttributeDescriber describer;
        ComponentGraphResolveMetadata targetComponent = targetComponentState.getMetadata();
        AttributeMatcher attributeMatcher = consumerSchema.withProducer(targetComponent.getAttributesSchema());
        Optional<List<? extends VariantGraphResolveMetadata>> variantsForGraphTraversal = targetComponent.getVariantsForGraphTraversal();
        boolean variantAware = variantsForGraphTraversal.isPresent();
        if (!variantAware || ((List)variantsForGraphTraversal.get()).isEmpty()) {
            return AttributeConfigurationSelector.selectDefaultConfiguration(consumerAttributes, consumerSchema, targetComponent, attributeMatcher, variantAware);
        }
        List allConsumableVariants = (List)variantsForGraphTraversal.get();
        ImmutableList<VariantGraphResolveMetadata> variantsProvidingRequestedCapabilities = AttributeConfigurationSelector.filterVariantsByRequestedCapabilities(targetComponent, explicitRequestedCapabilities, allConsumableVariants, true);
        if (variantsProvidingRequestedCapabilities.isEmpty()) {
            throw new NoMatchingCapabilitiesException(targetComponent, explicitRequestedCapabilities, allConsumableVariants);
        }
        List<VariantGraphResolveMetadata> matches = attributeMatcher.matches(variantsProvidingRequestedCapabilities, consumerAttributes, explanationBuilder);
        if (matches.size() > 1) {
            List<VariantGraphResolveMetadata> sameClassifier;
            String classifier;
            Object strictlyMatchingCapabilities = AttributeConfigurationSelector.filterVariantsByRequestedCapabilities(targetComponent, explicitRequestedCapabilities, matches, false);
            if (strictlyMatchingCapabilities.size() == 1) {
                return AttributeConfigurationSelector.singleVariant(true, strictlyMatchingCapabilities);
            }
            if (strictlyMatchingCapabilities.size() > 1 && (strictlyMatchingCapabilities = attributeMatcher.matches(strictlyMatchingCapabilities, consumerAttributes, explanationBuilder)).size() == 1) {
                return AttributeConfigurationSelector.singleVariant(true, (List<VariantGraphResolveMetadata>)strictlyMatchingCapabilities);
            }
            if (requestedArtifacts.size() == 1 && (classifier = requestedArtifacts.get(0).getClassifier()) != null && (sameClassifier = AttributeConfigurationSelector.findVariantsProvidingExactlySameClassifier(matches, classifier, targetComponentState)) != null && sameClassifier.size() == 1) {
                return AttributeConfigurationSelector.singleVariant(true, sameClassifier);
            }
        }
        if (matches.size() == 1) {
            return AttributeConfigurationSelector.singleVariant(true, matches);
        }
        if (!matches.isEmpty()) {
            describer = DescriberSelector.selectDescriber(consumerAttributes, consumerSchema);
            if (explanationBuilder instanceof TraceDiscardedConfigurations) {
                Set discarded = (Set)Cast.uncheckedCast(((TraceDiscardedConfigurations)explanationBuilder).discarded);
                throw new AmbiguousConfigurationSelectionException(describer, consumerAttributes, attributeMatcher, matches, targetComponent, true, discarded);
            }
            return AttributeConfigurationSelector.selectVariantsUsingAttributeMatching(consumerAttributes, explicitRequestedCapabilities, targetComponentState, consumerSchema, requestedArtifacts, new TraceDiscardedConfigurations());
        }
        describer = DescriberSelector.selectDescriber(consumerAttributes, consumerSchema);
        throw new NoMatchingConfigurationSelectionException(describer, consumerAttributes, attributeMatcher, targetComponent, true);
    }

    private static VariantSelectionResult selectDefaultConfiguration(ImmutableAttributes consumerAttributes, AttributesSchemaInternal consumerSchema, ComponentGraphResolveMetadata targetComponent, AttributeMatcher attributeMatcher, boolean variantAware) {
        ConfigurationGraphResolveMetadata fallbackConfiguration = targetComponent.getConfiguration("default");
        if (fallbackConfiguration != null && fallbackConfiguration.isCanBeConsumed() && attributeMatcher.isMatching(fallbackConfiguration.getAttributes(), consumerAttributes)) {
            return AttributeConfigurationSelector.singleVariant(variantAware, (List<VariantGraphResolveMetadata>)ImmutableList.of((Object)fallbackConfiguration));
        }
        AttributeDescriber describer = DescriberSelector.selectDescriber(consumerAttributes, consumerSchema);
        throw new NoMatchingConfigurationSelectionException(describer, consumerAttributes, attributeMatcher, targetComponent, variantAware);
    }

    @Nullable
    private static List<VariantGraphResolveMetadata> findVariantsProvidingExactlySameClassifier(List<VariantGraphResolveMetadata> matches, String classifier, ComponentGraphResolveState targetComponent) {
        ArrayList sameClassifier = null;
        for (VariantGraphResolveMetadata match : matches) {
            ArtifactIdentifier artifactIdentifier;
            ComponentArtifactMetadata componentArtifactMetadata;
            List<? extends ComponentArtifactMetadata> artifacts2 = targetComponent.resolveArtifactsFor(match).getArtifacts();
            if (artifacts2.size() != 1 || !((componentArtifactMetadata = artifacts2.get(0)) instanceof ModuleComponentArtifactMetadata) || !classifier.equals((artifactIdentifier = ((ModuleComponentArtifactMetadata)componentArtifactMetadata).toArtifactIdentifier()).getClassifier())) continue;
            if (sameClassifier == null) {
                sameClassifier = Collections.singletonList(match);
                continue;
            }
            sameClassifier = Lists.newArrayList(sameClassifier);
            sameClassifier.add(match);
        }
        return sameClassifier;
    }

    private static VariantSelectionResult singleVariant(boolean variantAware, List<VariantGraphResolveMetadata> matches) {
        assert (matches.size() == 1);
        return new VariantSelectionResult((List<? extends VariantGraphResolveMetadata>)ImmutableList.of((Object)matches.get(0)), variantAware);
    }

    private static ImmutableList<VariantGraphResolveMetadata> filterVariantsByRequestedCapabilities(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> explicitRequestedCapabilities, Collection<? extends VariantGraphResolveMetadata> consumableVariants, boolean lenient) {
        if (consumableVariants.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)consumableVariants.size());
        boolean explicitlyRequested = !explicitRequestedCapabilities.isEmpty();
        ModuleIdentifier moduleId = targetComponent.getModuleVersionId().getModule();
        for (VariantGraphResolveMetadata variantGraphResolveMetadata : consumableVariants) {
            MatchResult result2;
            CapabilitiesMetadata capabilitiesMetadata = variantGraphResolveMetadata.getCapabilities();
            List<? extends Capability> capabilities = capabilitiesMetadata.getCapabilities();
            if (explicitlyRequested) {
                MatchResult result22 = AttributeConfigurationSelector.providesAllCapabilities(targetComponent, explicitRequestedCapabilities, capabilities);
            } else {
                result2 = AttributeConfigurationSelector.containsImplicitCapability(capabilitiesMetadata, capabilities, moduleId.getGroup(), moduleId.getName());
            }
            if (!result2.matches || !lenient && result2 != MatchResult.EXACT_MATCH) continue;
            builder.add((Object)variantGraphResolveMetadata);
        }
        return builder.build();
    }

    private static MatchResult providesAllCapabilities(ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> explicitRequestedCapabilities, List<? extends Capability> providerCapabilities) {
        if (providerCapabilities.isEmpty() && explicitRequestedCapabilities.size() == 1) {
            Capability requested = explicitRequestedCapabilities.iterator().next();
            ModuleVersionIdentifier moduleVersionIdentifier = targetComponent.getModuleVersionId();
            if (requested.getGroup().equals(moduleVersionIdentifier.getGroup()) && requested.getName().equals(moduleVersionIdentifier.getName())) {
                return MatchResult.EXACT_MATCH;
            }
        }
        for (Capability capability : explicitRequestedCapabilities) {
            String requestedGroup = capability.getGroup();
            String requestedName = capability.getName();
            boolean found = false;
            for (Capability capability2 : providerCapabilities) {
                if (!capability2.getGroup().equals(requestedGroup) || !capability2.getName().equals(requestedName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return MatchResult.NO_MATCH;
        }
        boolean exactMatch = explicitRequestedCapabilities.size() == providerCapabilities.size();
        return exactMatch ? MatchResult.EXACT_MATCH : MatchResult.MATCHES_ALL;
    }

    private static MatchResult containsImplicitCapability(CapabilitiesMetadata capabilitiesMetadata, Collection<? extends Capability> capabilities, String group, String name) {
        if (AttributeConfigurationSelector.fastContainsImplicitCapability((CapabilitiesMetadataInternal)capabilitiesMetadata, capabilities)) {
            return MatchResult.EXACT_MATCH;
        }
        for (Capability capability : capabilities) {
            Capability capability2 = AttributeConfigurationSelector.unwrap(capability);
            if (!group.equals(capability2.getGroup()) || !name.equals(capability2.getName())) continue;
            boolean exactMatch = capabilities.size() == 1;
            return exactMatch ? MatchResult.EXACT_MATCH : MatchResult.MATCHES_ALL;
        }
        return MatchResult.NO_MATCH;
    }

    private static boolean fastContainsImplicitCapability(CapabilitiesMetadataInternal capabilitiesMetadata, Collection<? extends Capability> capabilities) {
        return capabilities.isEmpty() || capabilitiesMetadata.isShadowedCapabilityOnly();
    }

    private static Capability unwrap(Capability capability) {
        if (capability instanceof ShadowedCapability) {
            return ((ShadowedCapability)capability).getShadowedCapability();
        }
        return capability;
    }

    private static class TraceDiscardedConfigurations
    implements AttributeMatchingExplanationBuilder {
        private final Set<HasAttributes> discarded = Sets.newHashSet();

        private TraceDiscardedConfigurations() {
        }

        @Override
        public boolean canSkipExplanation() {
            return false;
        }

        @Override
        public <T extends HasAttributes> void candidateDoesNotMatchAttributes(T candidate, AttributeContainerInternal requested) {
            this.recordDiscardedCandidate(candidate);
        }

        public <T extends HasAttributes> void recordDiscardedCandidate(T candidate) {
            this.discarded.add(candidate);
        }

        @Override
        public <T extends HasAttributes> void candidateAttributeDoesNotMatch(T candidate, Attribute<?> attribute, Object requestedValue, AttributeValue<?> candidateValue) {
            this.recordDiscardedCandidate(candidate);
        }
    }

    private static enum MatchResult {
        NO_MATCH(false),
        MATCHES_ALL(true),
        EXACT_MATCH(true);

        private final boolean matches;

        private MatchResult(boolean match) {
            this.matches = match;
        }
    }
}

