/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build.event;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.tooling.events.OperationType;

public class BuildEventSubscriptions {
    private final Set<OperationType> operationTypes;

    public BuildEventSubscriptions(Set<OperationType> operationTypes) {
        this.operationTypes = ImmutableSet.copyOf(operationTypes);
    }

    public Set<OperationType> getOperationTypes() {
        return this.operationTypes;
    }

    public boolean isRequested(OperationType workItem) {
        return this.operationTypes.contains((Object)workItem);
    }

    public boolean isAnyOperationTypeRequested() {
        return !this.operationTypes.isEmpty();
    }

    public boolean isAnyRequested(OperationType ... types) {
        return !this.isNoneRequested(types);
    }

    private boolean isNoneRequested(OperationType ... types) {
        return Collections.disjoint(this.operationTypes, Arrays.asList(types));
    }
}

