/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.exception;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.exception.ExceptionCollector;

public class MultipleBuildFailuresExceptionAnalyser
implements ExceptionAnalyser {
    private final ExceptionCollector collector;

    public MultipleBuildFailuresExceptionAnalyser(ExceptionCollector collector) {
        this.collector = collector;
    }

    @Override
    public RuntimeException transform(Throwable failure) {
        return this.transform(Collections.singletonList(failure));
    }

    @Override
    @Nullable
    public RuntimeException transform(List<Throwable> failures) {
        if (failures.isEmpty()) {
            return null;
        }
        ArrayList result2 = new ArrayList(failures.size());
        for (Throwable failure : failures) {
            if (failure instanceof MultipleBuildFailures) {
                for (Throwable throwable : ((MultipleBuildFailures)failure).getCauses()) {
                    this.collector.collectFailures(throwable, result2);
                }
                continue;
            }
            this.collector.collectFailures(failure, result2);
        }
        if (result2.size() == 1 && result2.get(0) instanceof RuntimeException) {
            return (RuntimeException)result2.get(0);
        }
        return new MultipleBuildFailures(result2);
    }
}

