/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.Map;
import org.gradle.StartParameter;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.initialization.DefaultSettings;
import org.gradle.initialization.SettingsState;
import org.gradle.internal.extensibility.ExtensibleDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.service.scopes.SettingsScopeServices;

public class SettingsFactory {
    private final Instantiator instantiator;
    private final ServiceRegistry buildScopeServices;
    private final ScriptHandlerFactory scriptHandlerFactory;

    public SettingsFactory(Instantiator instantiator2, ServiceRegistry buildScopeServices, ScriptHandlerFactory scriptHandlerFactory) {
        this.instantiator = instantiator2;
        this.buildScopeServices = buildScopeServices;
        this.scriptHandlerFactory = scriptHandlerFactory;
    }

    public SettingsState createSettings(GradleInternal gradle, File settingsDir, ScriptSource settingsScript, GradleProperties gradleProperties2, StartParameter startParameter, ClassLoaderScope baseClassLoaderScope) {
        ClassLoaderScope classLoaderScope = baseClassLoaderScope.createChild("settings[" + gradle.getIdentityPath() + "]", null);
        SettingsServiceRegistryFactory serviceRegistryFactory2 = new SettingsServiceRegistryFactory();
        DefaultSettings settings = this.instantiator.newInstance(DefaultSettings.class, serviceRegistryFactory2, gradle, classLoaderScope, baseClassLoaderScope, this.scriptHandlerFactory.create(settingsScript, classLoaderScope), settingsDir, settingsScript, startParameter);
        Map<String, Object> properties = gradleProperties2.getProperties();
        DynamicObject dynamicObject = ((DynamicObjectAware)((Object)settings)).getAsDynamicObject();
        ((ExtensibleDynamicObject)dynamicObject).addProperties(properties);
        return new SettingsState(settings, serviceRegistryFactory2.services);
    }

    private class SettingsServiceRegistryFactory
    implements ServiceRegistryFactory {
        private SettingsScopeServices services;

        private SettingsServiceRegistryFactory() {
        }

        @Override
        public ServiceRegistry createFor(Object domainObject) {
            this.services = new SettingsScopeServices(SettingsFactory.this.buildScopeServices, (SettingsInternal)domainObject);
            return this.services;
        }
    }
}

