/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.NonNullApi;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.PlannedNodeInternal;
import org.gradle.execution.plan.ToPlannedNodeConverter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.taskgraph.NodeIdentity;

@NonNullApi
@ServiceScope(value=Scopes.UserHome.class)
@ThreadSafe
public class ToPlannedNodeConverterRegistry {
    private static final ToPlannedNodeConverter MISSING_MARKER = new MissingToPlannedNodeConverter();
    private final List<ToPlannedNodeConverter> converters;
    private final ConcurrentMap<Class<? extends Node>, ToPlannedNodeConverter> convertersByNodeType = new ConcurrentHashMap<Class<? extends Node>, ToPlannedNodeConverter>();

    public ToPlannedNodeConverterRegistry(List<ToPlannedNodeConverter> converters) {
        ToPlannedNodeConverterRegistry.validateConverters(converters);
        this.converters = ImmutableList.copyOf(converters);
        for (ToPlannedNodeConverter converter : this.converters) {
            this.convertersByNodeType.put(converter.getSupportedNodeType(), converter);
        }
    }

    public Set<NodeIdentity.NodeType> getConvertedNodeTypes() {
        return this.converters.stream().map(ToPlannedNodeConverter::getConvertedNodeType).collect(Collectors.toSet());
    }

    @Nullable
    public ToPlannedNodeConverter getConverter(Node node) {
        Class<?> nodeType = node.getClass();
        ToPlannedNodeConverter converter = this.convertersByNodeType.computeIfAbsent(nodeType, this::findConverter);
        return converter == MISSING_MARKER ? null : converter;
    }

    private ToPlannedNodeConverter findConverter(Class<? extends Node> nodeType) {
        for (ToPlannedNodeConverter converterCandidate : this.converters) {
            Class<? extends Node> supportedNodeType = converterCandidate.getSupportedNodeType();
            if (!supportedNodeType.isAssignableFrom(nodeType)) continue;
            return converterCandidate;
        }
        return MISSING_MARKER;
    }

    private static void validateConverters(List<ToPlannedNodeConverter> converters) {
        int converterCount = converters.size();
        for (int i = 0; i < converterCount; ++i) {
            ToPlannedNodeConverter converter1 = converters.get(i);
            for (int j = i + 1; j < converterCount; ++j) {
                ToPlannedNodeConverter converter2 = converters.get(j);
                ToPlannedNodeConverterRegistry.checkOverlappingConverters(converter1, converter2);
            }
        }
    }

    private static void checkOverlappingConverters(ToPlannedNodeConverter converter1, ToPlannedNodeConverter converter2) {
        Class<? extends Node> supportedNodeType2;
        Class<? extends Node> supportedNodeType1 = converter1.getSupportedNodeType();
        if (supportedNodeType1.isAssignableFrom(supportedNodeType2 = converter2.getSupportedNodeType()) || supportedNodeType2.isAssignableFrom(supportedNodeType1)) {
            throw new IllegalStateException("Converter " + converter1 + " overlaps by supported node type with converter " + converter2);
        }
    }

    private static final class MissingToPlannedNodeConverter
    implements ToPlannedNodeConverter {
        private MissingToPlannedNodeConverter() {
        }

        @Override
        public Class<? extends Node> getSupportedNodeType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NodeIdentity.NodeType getConvertedNodeType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NodeIdentity getNodeIdentity(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isInSamePlan(Node node) {
            throw new UnsupportedOperationException();
        }

        @Override
        public PlannedNodeInternal convert(Node node, List<? extends NodeIdentity> nodeDependencies) {
            throw new UnsupportedOperationException();
        }
    }
}

