/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.composite.internal.BuildController;
import org.gradle.composite.internal.BuildControllers;
import org.gradle.composite.internal.DefaultBuildController;
import org.gradle.execution.plan.PlanExecutor;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.work.WorkerLeaseService;

class DefaultBuildControllers
implements BuildControllers {
    private final Map<BuildIdentifier, BuildController> controllers = new TreeMap<BuildIdentifier, BuildController>(this.idComparator());
    private final ManagedExecutor executorService;
    private final WorkerLeaseService workerLeaseService;
    private final PlanExecutor planExecutor;
    private final int monitoringPollTime;
    private final TimeUnit monitoringPollTimeUnit;

    DefaultBuildControllers(ManagedExecutor executorService, WorkerLeaseService workerLeaseService, PlanExecutor planExecutor, int monitoringPollTime, TimeUnit monitoringPollTimeUnit) {
        this.executorService = executorService;
        this.workerLeaseService = workerLeaseService;
        this.planExecutor = planExecutor;
        this.monitoringPollTime = monitoringPollTime;
        this.monitoringPollTimeUnit = monitoringPollTimeUnit;
    }

    @Override
    public BuildController getBuildController(BuildState build) {
        BuildController buildController = this.controllers.get(build.getBuildIdentifier());
        if (buildController != null) {
            return buildController;
        }
        DefaultBuildController newBuildController = new DefaultBuildController(build, this.workerLeaseService);
        this.controllers.put(build.getBuildIdentifier(), newBuildController);
        return newBuildController;
    }

    @Override
    public void populateWorkGraphs() {
        boolean tasksDiscovered = true;
        while (tasksDiscovered) {
            tasksDiscovered = false;
            for (BuildController buildController : ImmutableList.copyOf(this.controllers.values())) {
                if (!buildController.scheduleQueuedTasks()) continue;
                tasksDiscovered = true;
            }
        }
        for (BuildController buildController : this.controllers.values()) {
            buildController.finalizeWorkGraph();
        }
    }

    @Override
    public ExecutionResult<Void> execute() {
        CountDownLatch complete = new CountDownLatch(this.controllers.size());
        ConcurrentHashMap results = new ConcurrentHashMap();
        for (BuildController buildController : this.controllers.values()) {
            buildController.startExecution(this.executorService, result2 -> {
                results.put(buildController, result2);
                complete.countDown();
            });
        }
        this.awaitCompletion(complete);
        ExecutionResult<Void> result3 = ExecutionResult.succeeded();
        for (BuildController buildController : this.controllers.values()) {
            result3 = result3.withFailures((ExecutionResult)results.get(buildController));
        }
        return result3;
    }

    private void awaitCompletion(CountDownLatch complete) {
        while (true) {
            AtomicBoolean done = new AtomicBoolean();
            this.workerLeaseService.blocking(() -> {
                try {
                    done.set(complete.await(this.monitoringPollTime, this.monitoringPollTimeUnit));
                }
                catch (InterruptedException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            });
            if (done.get()) {
                return;
            }
            this.planExecutor.assertHealthy();
        }
    }

    @Override
    public void close() {
        CompositeStoppable.stoppable(this.controllers.values()).stop();
    }

    private Comparator<BuildIdentifier> idComparator() {
        return (id1, id2) -> {
            if (id1.equals(DefaultBuildIdentifier.ROOT)) {
                if (id2.equals(DefaultBuildIdentifier.ROOT)) {
                    return 0;
                }
                return 1;
            }
            if (id2.equals(DefaultBuildIdentifier.ROOT)) {
                return -1;
            }
            return id1.getBuildPath().compareTo(id2.getBuildPath());
        };
    }
}

