/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.DefaultBuildCacheKey;
import org.gradle.caching.internal.NextGenBuildCacheService;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.CacheManifest;
import org.gradle.caching.internal.controller.NextGenBuildCacheAccess;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.packaging.impl.RelativePathParser;
import org.gradle.internal.file.BufferProvider;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.file.impl.DefaultFileMetadata;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.io.Closer;
import org.gradle.internal.impldep.com.google.gson.Gson;
import org.gradle.internal.impldep.com.google.gson.GsonBuilder;
import org.gradle.internal.impldep.com.google.gson.TypeAdapter;
import org.gradle.internal.impldep.com.google.gson.stream.JsonReader;
import org.gradle.internal.impldep.com.google.gson.stream.JsonWriter;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.impldep.org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.gradle.internal.impldep.org.apache.commons.io.output.NullOutputStream;
import org.gradle.internal.impldep.org.apache.commons.io.output.TeeOutputStream;
import org.gradle.internal.snapshot.DirectorySnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.internal.vfs.FileSystemAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NextGenBuildCacheController
implements BuildCacheController {
    private static final Logger LOGGER = LoggerFactory.getLogger(NextGenBuildCacheController.class);
    public static final String NEXT_GEN_CACHE_SYSTEM_PROPERTY = "org.gradle.unsafe.cache.ng";
    private final BufferProvider bufferProvider;
    private final NextGenBuildCacheAccess cacheAccess;
    private final FileSystemAccess fileSystemAccess;
    private final String buildInvocationId;
    private final Deleter deleter;
    private final StringInterner stringInterner;
    private final Gson gson;

    public NextGenBuildCacheController(String buildInvocationId, Deleter deleter, FileSystemAccess fileSystemAccess, BufferProvider bufferProvider, StringInterner stringInterner, NextGenBuildCacheAccess cacheAccess) {
        this.buildInvocationId = buildInvocationId;
        this.deleter = deleter;
        this.fileSystemAccess = fileSystemAccess;
        this.bufferProvider = bufferProvider;
        this.cacheAccess = cacheAccess;
        this.stringInterner = stringInterner;
        this.gson = new GsonBuilder().registerTypeAdapter(Duration.class, (Object)new TypeAdapter<Duration>(){

            public void write(JsonWriter out, Duration value) throws IOException {
                out.value(value.toMillis());
            }

            public Duration read(JsonReader in) throws IOException {
                return Duration.ofMillis(in.nextLong());
            }
        }).registerTypeAdapter(HashCode.class, (Object)new TypeAdapter<HashCode>(){

            public void write(JsonWriter out, HashCode value) throws IOException {
                out.value(value.toString());
            }

            public HashCode read(JsonReader in) throws IOException {
                return HashCode.fromString(in.nextString());
            }
        }).create();
        LOGGER.warn("Creating next-generation build cache controller");
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isEmitDebugLogging() {
        return false;
    }

    @Override
    public Optional<BuildCacheLoadResult> load(BuildCacheKey manifestCacheKey, CacheableEntity cacheableEntity) {
        AtomicReference manifestRef = new AtomicReference();
        this.cacheAccess.load(Collections.singletonMap(manifestCacheKey, null), (InputStream manifestStream, T __) -> manifestRef.set((CacheManifest)this.gson.fromJson((Reader)new InputStreamReader(manifestStream), CacheManifest.class)));
        final CacheManifest manifest = (CacheManifest)manifestRef.get();
        if (manifest == null) {
            return Optional.empty();
        }
        final AtomicLong loadedEntryCount = new AtomicLong(0L);
        ImmutableSortedMap.Builder snapshots = ImmutableSortedMap.naturalOrder();
        cacheableEntity.visitOutputTrees((propertyName, type, root) -> {
            this.fileSystemAccess.write(Collections.singleton(root.getAbsolutePath()), () -> {});
            try {
                this.cleanOutputDirectory(type, root);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ImmutableListMultimap.Builder filesBuilder = ImmutableListMultimap.builder();
            List<CacheManifest.ManifestEntry> manifestEntries = manifest.getPropertyManifests().get(propertyName);
            manifestEntries.forEach(entry -> {
                File file = new File(root, entry.getRelativePath());
                switch (entry.getType()) {
                    case Directory: {
                        file.mkdirs();
                        break;
                    }
                    case RegularFile: {
                        filesBuilder.put((Object)new DefaultBuildCacheKey(entry.getContentHash()), (Object)file);
                        break;
                    }
                    case Missing: {
                        FileUtils.deleteQuietly((File)file);
                    }
                }
            });
            this.cacheAccess.load(filesBuilder.build().asMap(), (InputStream input, T filesForHash) -> {
                loadedEntryCount.addAndGet(filesForHash.size());
                try (Closer closer = Closer.create();){
                    OutputStream output = filesForHash.stream().map(file -> {
                        try {
                            return (FileOutputStream)closer.register((Closeable)new FileOutputStream((File)file));
                        }
                        catch (FileNotFoundException e) {
                            throw new UncheckedIOException("Couldn't create " + file.getAbsolutePath(), e);
                        }
                    }).map(OutputStream.class::cast).reduce(TeeOutputStream::new).orElse((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                    IOUtils.copyLarge((InputStream)input, (OutputStream)output, (byte[])this.bufferProvider.getBuffer());
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            });
            this.createSnapshot(type, root, manifestEntries).ifPresent(snapshot -> {
                snapshots.put((Object)propertyName, snapshot);
                this.fileSystemAccess.record((FileSystemLocationSnapshot)snapshot);
            });
        });
        final ImmutableSortedMap resultingSnapshots = snapshots.build();
        return Optional.of(new BuildCacheLoadResult(){

            @Override
            public long getArtifactEntryCount() {
                return loadedEntryCount.get();
            }

            @Override
            public OriginMetadata getOriginMetadata() {
                return manifest.getOriginMetadata();
            }

            @Override
            public ImmutableSortedMap<String, FileSystemSnapshot> getResultingSnapshots() {
                return resultingSnapshots;
            }
        });
    }

    @VisibleForTesting
    Optional<FileSystemLocationSnapshot> createSnapshot(TreeType type, File root, List<CacheManifest.ManifestEntry> entries) {
        switch (type) {
            case DIRECTORY: {
                return Optional.of(this.createDirectorySnapshot(root, entries));
            }
            case FILE: {
                if (entries.size() != 1) {
                    throw new IllegalStateException("Expected a single manifest entry, found " + entries.size());
                }
                CacheManifest.ManifestEntry rootEntry = entries.get(0);
                switch (rootEntry.getType()) {
                    case Directory: {
                        throw new IllegalStateException("Directory manifest entry found for a file output");
                    }
                    case RegularFile: {
                        return Optional.of(this.createFileSnapshot(rootEntry, root));
                    }
                    case Missing: {
                        return Optional.empty();
                    }
                }
                throw new AssertionError((Object)("Unknown manifest entry type " + (Object)((Object)rootEntry.getType())));
            }
        }
        throw new AssertionError((Object)("Unknown output type " + (Object)((Object)type)));
    }

    private FileSystemLocationSnapshot createDirectorySnapshot(File root, List<CacheManifest.ManifestEntry> entries) {
        String rootPath = root.getName() + "/";
        RelativePathParser parser = new RelativePathParser(rootPath);
        DirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        builder.enterDirectory(FileMetadata.AccessType.DIRECT, this.stringInterner.intern(root.getAbsolutePath()), this.stringInterner.intern(root.getName()), DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS);
        for (CacheManifest.ManifestEntry entry : Iterables.skip(entries, (int)1)) {
            File file = new File(root, entry.getRelativePath());
            boolean isDirectory = entry.getType() == FileType.Directory;
            String relativePath = isDirectory ? rootPath + entry.getRelativePath() + "/" : rootPath + entry.getRelativePath();
            boolean outsideOfRoot = parser.nextPath(relativePath, isDirectory, builder::leaveDirectory);
            if (outsideOfRoot) break;
            switch (entry.getType()) {
                case Directory: {
                    String internedAbsolutePath = this.stringInterner.intern(file.getAbsolutePath());
                    String internedName = this.stringInterner.intern(parser.getName());
                    builder.enterDirectory(FileMetadata.AccessType.DIRECT, internedAbsolutePath, internedName, DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS);
                    break;
                }
                case RegularFile: {
                    RegularFileSnapshot fileSnapshot = this.createFileSnapshot(entry, file);
                    builder.visitLeafElement(fileSnapshot);
                    break;
                }
            }
        }
        parser.exitToRoot(builder::leaveDirectory);
        builder.leaveDirectory();
        return (FileSystemLocationSnapshot)Preconditions.checkNotNull((Object)builder.getResult());
    }

    private RegularFileSnapshot createFileSnapshot(CacheManifest.ManifestEntry entry, File file) {
        return new RegularFileSnapshot(this.stringInterner.intern(file.getAbsolutePath()), this.stringInterner.intern(file.getName()), entry.getContentHash(), DefaultFileMetadata.file(file.lastModified(), entry.getLength(), FileMetadata.AccessType.DIRECT));
    }

    @Override
    public void store(BuildCacheKey manifestCacheKey, CacheableEntity entity, Map<String, FileSystemSnapshot> snapshots, Duration executionTime) {
        ImmutableMap.Builder propertyManifests = ImmutableMap.builder();
        entity.visitOutputTrees((propertyName, type, root) -> {
            ImmutableList.Builder manifestEntries = ImmutableList.builder();
            FileSystemSnapshot rootSnapshot = (FileSystemSnapshot)snapshots.get(propertyName);
            rootSnapshot.accept(new RelativePathTracker(), (snapshot, relativePath) -> {
                if (relativePath.isRoot()) {
                    NextGenBuildCacheController.assertCorrectType(type, snapshot);
                }
                manifestEntries.add((Object)new CacheManifest.ManifestEntry(snapshot.getType(), relativePath.toRelativePath(), snapshot.getHash(), SnapshotUtil.getLength(snapshot)));
                return SnapshotVisitResult.CONTINUE;
            });
            propertyManifests.put((Object)propertyName, (Object)manifestEntries.build());
        });
        CacheManifest manifest = new CacheManifest(new OriginMetadata(this.buildInvocationId, executionTime), (Map<String, List<CacheManifest.ManifestEntry>>)propertyManifests.build());
        entity.visitOutputTrees((propertyName, type, root) -> {
            Map manifestIndex = (Map)manifest.getPropertyManifests().get(propertyName).stream().filter(entry -> entry.getType() == FileType.RegularFile).collect(ImmutableMap.toImmutableMap(manifestEntry -> new DefaultBuildCacheKey(manifestEntry.getContentHash()), Function.identity(), (a, b) -> a));
            this.cacheAccess.store(manifestIndex, manifestEntry -> new NextGenBuildCacheService.NextGenWriter((CacheManifest.ManifestEntry)manifestEntry){
                final /* synthetic */ CacheManifest.ManifestEntry val$manifestEntry;
                {
                    this.val$manifestEntry = manifestEntry;
                }

                @Override
                public InputStream openStream() throws IOException {
                    return new FileInputStream(new File(root, this.val$manifestEntry.getRelativePath()));
                }

                @Override
                public void writeTo(OutputStream output) throws IOException {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    try (InputStream input = this.openStream();){
                        IOUtils.copyLarge((InputStream)input, (OutputStream)output, (byte[])NextGenBuildCacheController.this.bufferProvider.getBuffer());
                    }
                }

                @Override
                public long getSize() {
                    return this.val$manifestEntry.getLength();
                }
            });
        });
        this.cacheAccess.store(Collections.singletonMap(manifestCacheKey, manifest), __ -> {
            String manifestJson = this.gson.toJson((Object)manifest);
            final byte[] bytes = manifestJson.getBytes(StandardCharsets.UTF_8);
            return new NextGenBuildCacheService.NextGenWriter(){

                @Override
                public InputStream openStream() {
                    return new UnsynchronizedByteArrayInputStream(bytes);
                }

                @Override
                public void writeTo(OutputStream output) throws IOException {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    output.write(bytes);
                }

                @Override
                public long getSize() {
                    return bytes.length;
                }
            };
        });
    }

    private static void assertCorrectType(TreeType type, FileSystemLocationSnapshot snapshot) {
        if (snapshot.getType() == FileType.Missing) {
            return;
        }
        switch (type) {
            case DIRECTORY: {
                if (snapshot.getType() == FileType.Directory) break;
                throw new IllegalArgumentException(String.format("Expected '%s' to be a directory", snapshot.getAbsolutePath()));
            }
            case FILE: {
                if (snapshot.getType() == FileType.RegularFile) break;
                throw new IllegalArgumentException(String.format("Expected '%s' to be a file", snapshot.getAbsolutePath()));
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public void close() throws IOException {
        LOGGER.warn("Closing next-generation build cache controller");
        this.cacheAccess.close();
    }

    private void cleanOutputDirectory(TreeType type, File root) throws IOException {
        switch (type) {
            case DIRECTORY: {
                this.deleter.ensureEmptyDirectory(root);
                break;
            }
            case FILE: {
                if (this.makeDirectory(root.getParentFile()) || !root.exists()) break;
                this.deleter.deleteRecursively(root);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private boolean makeDirectory(File target) throws IOException {
        if (target.isDirectory()) {
            return false;
        }
        if (target.isFile()) {
            this.deleter.delete(target);
        }
        FileUtils.forceMkdir((File)target);
        return true;
    }

    public static boolean isNextGenCachingEnabled() {
        return Boolean.getBoolean(NEXT_GEN_CACHE_SYSTEM_PROPERTY) == Boolean.TRUE;
    }
}

