/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publisher;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.XmlProvider;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.ExactVersionSelector;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyModuleDescriptorAuthor;
import org.gradle.api.publish.ivy.IvyModuleDescriptorDescription;
import org.gradle.api.publish.ivy.IvyModuleDescriptorLicense;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependencyInternal;
import org.gradle.api.publish.ivy.internal.dependency.IvyExcludeRule;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.publish.ivy.internal.publisher.NormalizedIvyArtifact;
import org.gradle.internal.impldep.com.google.common.base.Joiner;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.xml.SimpleXmlWriter;
import org.gradle.internal.xml.XmlTransformer;
import org.gradle.util.internal.CollectionUtils;

public class IvyDescriptorFileGenerator {
    private static final String IVY_FILE_ENCODING = "UTF-8";
    private static final String IVY_DATE_PATTERN = "yyyyMMddHHmmss";
    private static final Action<XmlProvider> ADD_GRADLE_METADATA_MARKER = new Action<XmlProvider>(){

        @Override
        public void execute(XmlProvider xmlProvider) {
            StringBuilder builder = xmlProvider.asString();
            int idx = builder.indexOf("<info");
            builder.insert(idx, IvyDescriptorFileGenerator.xmlComments(MetaDataParser.GRADLE_METADATA_MARKER_COMMENT_LINES) + "  " + IvyDescriptorFileGenerator.xmlComment("do_not_remove: published-with-gradle-metadata") + "  ");
        }
    };
    private final VersionMappingStrategyInternal versionMappingStrategy;
    private final XmlTransformer xmlTransformer = new XmlTransformer();
    private final Model model;

    public IvyDescriptorFileGenerator(IvyPublicationIdentity projectIdentity, boolean writeGradleRedirectionMarker, VersionMappingStrategyInternal versionMappingStrategy) {
        this.model = new Model(projectIdentity);
        this.versionMappingStrategy = versionMappingStrategy;
        if (writeGradleRedirectionMarker) {
            this.xmlTransformer.addFinalizer(ADD_GRADLE_METADATA_MARKER);
        }
    }

    public void setStatus(String status) {
        this.model.status = status;
    }

    public void setBranch(String branch) {
        this.model.branch = branch;
    }

    public IvyDescriptorFileGenerator addLicense(IvyModuleDescriptorLicense ivyLicense) {
        this.model.licenses.add(ivyLicense);
        return this;
    }

    public IvyDescriptorFileGenerator addAuthor(IvyModuleDescriptorAuthor ivyAuthor) {
        this.model.authors.add(ivyAuthor);
        return this;
    }

    public void setDescription(IvyModuleDescriptorDescription ivyDescription) {
        this.model.description = ivyDescription;
    }

    public Map<QName, String> getExtraInfo() {
        return this.model.extraInfo;
    }

    public void setExtraInfo(Map<QName, String> extraInfo) {
        this.model.extraInfo = extraInfo;
    }

    public IvyDescriptorFileGenerator addConfiguration(IvyConfiguration ivyConfiguration) {
        this.model.configurations.add(ivyConfiguration);
        return this;
    }

    public IvyDescriptorFileGenerator addArtifact(NormalizedIvyArtifact ivyArtifact) {
        this.model.artifacts.add(ivyArtifact);
        return this;
    }

    public IvyDescriptorFileGenerator addDependency(IvyDependencyInternal ivyDependency) {
        this.model.dependencies.add(ivyDependency);
        VariantVersionMappingStrategyInternal variantStrategy = this.versionMappingStrategy.findStrategyForVariant(ivyDependency.getAttributes());
        String org = ivyDependency.getOrganisation();
        String module = ivyDependency.getModule();
        String projectPath = ivyDependency.getProjectPath();
        ModuleVersionIdentifier resolvedVersion = variantStrategy.maybeResolveVersion(org, module, projectPath);
        if (resolvedVersion != null) {
            this.model.resolvedVersions.put(ivyDependency, resolvedVersion);
        }
        return this;
    }

    public IvyDescriptorFileGenerator addGlobalExclude(IvyExcludeRule excludeRule) {
        this.model.globalExcludes.add(excludeRule);
        return this;
    }

    public IvyDescriptorFileGenerator withXml(Action<XmlProvider> action) {
        this.xmlTransformer.addAction(action);
        return this;
    }

    public IvyDescriptorFileGenerator writeTo(File file) {
        this.toSpec().writeTo(file);
        return this;
    }

    public DescriptorFileSpec toSpec() {
        return new DescriptorFileSpec(this.model, this.xmlTransformer);
    }

    private static String xmlComments(String[] lines) {
        return Joiner.on((String)"  ").join(Iterables.transform(Arrays.asList(lines), IvyDescriptorFileGenerator::xmlComment));
    }

    private static String xmlComment(String content) {
        return "<!-- " + content + " -->\n";
    }

    public static class DescriptorFileSpec {
        private Model model;
        private XmlTransformer xmlTransformer;

        public DescriptorFileSpec(Model model, XmlTransformer xmlTransformer) {
            this.model = model;
            this.xmlTransformer = xmlTransformer;
        }

        public void writeTo(File destination) {
            new ModelWriter(this.model).writeTo(destination, this.xmlTransformer);
        }
    }

    public static class ModelWriter {
        private final SimpleDateFormat ivyDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        private final Model model;

        public ModelWriter(Model model) {
            this.model = model;
        }

        private void writeTo(File file, XmlTransformer xmlTransformer) {
            xmlTransformer.transform(file, IvyDescriptorFileGenerator.IVY_FILE_ENCODING, (Action<? super Writer>)new Action<Writer>(){

                @Override
                public void execute(Writer writer2) {
                    try {
                        this.writeDescriptor(writer2);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
            });
        }

        private void writeDescriptor(Writer writer2) throws IOException {
            OptionalAttributeXmlWriter xmlWriter = new OptionalAttributeXmlWriter(writer2, "  ", IvyDescriptorFileGenerator.IVY_FILE_ENCODING);
            xmlWriter.startElement("ivy-module").attribute("version", "2.0");
            if (this.model.usesClassifier()) {
                xmlWriter.attribute("xmlns:m", "http://ant.apache.org/ivy/maven");
            }
            xmlWriter.startElement("info").attribute("organisation", this.model.organisation).attribute("module", this.model.module).attribute("branch", this.model.branch).attribute("revision", this.model.revision).attribute("status", this.model.status).attribute("publication", this.ivyDateFormat.format(new Date()));
            for (IvyModuleDescriptorLicense ivyModuleDescriptorLicense : this.model.licenses) {
                xmlWriter.startElement("license").attribute("name", (String)ivyModuleDescriptorLicense.getName().getOrNull()).attribute("url", (String)ivyModuleDescriptorLicense.getUrl().getOrNull()).endElement();
            }
            for (IvyModuleDescriptorAuthor ivyModuleDescriptorAuthor : this.model.authors) {
                xmlWriter.startElement("ivyauthor").attribute("name", (String)ivyModuleDescriptorAuthor.getName().getOrNull()).attribute("url", (String)ivyModuleDescriptorAuthor.getUrl().getOrNull()).endElement();
            }
            if (this.model.description != null) {
                xmlWriter.startElement("description").attribute("homepage", (String)this.model.description.getHomepage().getOrNull()).characters(this.model.description.getText().getOrElse("")).endElement();
            }
            if (this.model.extraInfo != null) {
                for (Map.Entry entry : this.model.extraInfo.entrySet()) {
                    if (entry.getKey() == null) continue;
                    xmlWriter.startElement("ns:" + ((QName)entry.getKey()).getLocalPart()).attribute("xmlns:ns", ((QName)entry.getKey()).getNamespaceURI()).characters((CharSequence)entry.getValue()).endElement();
                }
            }
            xmlWriter.endElement();
            this.writeConfigurations(xmlWriter);
            this.writePublications(xmlWriter);
            this.writeDependencies(xmlWriter);
            xmlWriter.endElement();
        }

        private void writeConfigurations(OptionalAttributeXmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("configurations");
            for (IvyConfiguration configuration : this.model.configurations) {
                xmlWriter.startElement("conf").attribute("name", configuration.getName()).attribute("visibility", "public");
                if (configuration.getExtends().size() > 0) {
                    xmlWriter.attribute("extends", CollectionUtils.join(",", configuration.getExtends()));
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }

        private void writePublications(OptionalAttributeXmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("publications");
            for (IvyArtifact artifact : this.model.artifacts) {
                xmlWriter.startElement("artifact").attribute("name", artifact.getName()).attribute("type", artifact.getType()).attribute("ext", artifact.getExtension()).attribute("conf", artifact.getConf()).attribute("m:classifier", artifact.getClassifier()).endElement();
            }
            xmlWriter.endElement();
        }

        private void writeDependencies(OptionalAttributeXmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("dependencies");
            for (IvyDependencyInternal dependency : this.model.dependencies) {
                String org = dependency.getOrganisation();
                String module = dependency.getModule();
                ModuleVersionIdentifier resolvedVersion = (ModuleVersionIdentifier)this.model.resolvedVersions.get(dependency);
                if (resolvedVersion != null) {
                    org = resolvedVersion.getGroup();
                    module = resolvedVersion.getName();
                }
                xmlWriter.startElement("dependency").attribute("org", org).attribute("name", module).attribute("rev", resolvedVersion != null ? resolvedVersion.getVersion() : dependency.getRevision()).attribute("conf", dependency.getConfMapping());
                if (resolvedVersion != null && this.isDynamicVersion(dependency.getRevision())) {
                    xmlWriter.attribute("revConstraint", dependency.getRevision());
                }
                if (!dependency.isTransitive()) {
                    xmlWriter.attribute("transitive", "false");
                }
                for (DependencyArtifact dependencyArtifact : dependency.getArtifacts()) {
                    this.printDependencyArtifact(dependencyArtifact, xmlWriter);
                }
                for (ExcludeRule excludeRule : dependency.getExcludeRules()) {
                    this.writeDependencyExclude(excludeRule, xmlWriter);
                }
                xmlWriter.endElement();
            }
            for (IvyExcludeRule excludeRule : this.model.globalExcludes) {
                this.writeGlobalExclude(excludeRule, xmlWriter);
            }
            xmlWriter.endElement();
        }

        private boolean isDynamicVersion(String version) {
            return !ExactVersionSelector.isExact(version);
        }

        private void writeDependencyExclude(ExcludeRule excludeRule, OptionalAttributeXmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("exclude").attribute("org", excludeRule.getGroup()).attribute("module", excludeRule.getModule()).endElement();
        }

        private void printDependencyArtifact(DependencyArtifact dependencyArtifact, OptionalAttributeXmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("artifact").attribute("name", dependencyArtifact.getName()).attribute("type", dependencyArtifact.getType()).attribute("ext", dependencyArtifact.getExtension()).attribute("m:classifier", dependencyArtifact.getClassifier()).endElement();
        }

        private void writeGlobalExclude(IvyExcludeRule excludeRule, OptionalAttributeXmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("exclude").attribute("org", excludeRule.getOrg()).attribute("module", excludeRule.getModule()).attribute("conf", excludeRule.getConf()).endElement();
        }

        private static class OptionalAttributeXmlWriter
        extends SimpleXmlWriter {
            public OptionalAttributeXmlWriter(Writer writer2, String indent, String encoding) throws IOException {
                super(writer2, indent, encoding);
            }

            @Override
            public OptionalAttributeXmlWriter startElement(String name) throws IOException {
                super.startElement(name);
                return this;
            }

            @Override
            public OptionalAttributeXmlWriter attribute(String name, String value) throws IOException {
                if (value != null) {
                    super.attribute(name, value);
                }
                return this;
            }

            @Override
            public OptionalAttributeXmlWriter comment(String comment) throws IOException {
                super.comment(comment);
                return this;
            }
        }
    }

    static class Model {
        private String branch;
        private String status;
        private final String organisation;
        private final String module;
        private final String revision;
        private final List<IvyModuleDescriptorLicense> licenses = new ArrayList<IvyModuleDescriptorLicense>();
        private final List<IvyModuleDescriptorAuthor> authors = new ArrayList<IvyModuleDescriptorAuthor>();
        private IvyModuleDescriptorDescription description;
        private Map<QName, String> extraInfo;
        private final List<IvyConfiguration> configurations = new ArrayList<IvyConfiguration>();
        private final List<NormalizedIvyArtifact> artifacts = new ArrayList<NormalizedIvyArtifact>();
        private final List<IvyDependencyInternal> dependencies = new ArrayList<IvyDependencyInternal>();
        private final Map<IvyDependencyInternal, ModuleVersionIdentifier> resolvedVersions = new LinkedHashMap<IvyDependencyInternal, ModuleVersionIdentifier>();
        private List<IvyExcludeRule> globalExcludes = new ArrayList<IvyExcludeRule>();

        public Model(IvyPublicationIdentity projectIdentity) {
            this.organisation = projectIdentity.getOrganisation();
            this.module = projectIdentity.getModule();
            this.revision = projectIdentity.getRevision();
        }

        private boolean usesClassifier() {
            for (IvyArtifact ivyArtifact : this.artifacts) {
                if (ivyArtifact.getClassifier() == null) continue;
                return true;
            }
            for (IvyDependencyInternal ivyDependencyInternal : this.dependencies) {
                for (DependencyArtifact dependencyArtifact : ivyDependencyInternal.getArtifacts()) {
                    if (dependencyArtifact.getClassifier() == null) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

