/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import groovy.lang.Closure;
import java.io.File;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.quality.CodeNarcReports;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.plugins.quality.internal.CodeNarcAction;
import org.gradle.api.plugins.quality.internal.CodeNarcActionParameters;
import org.gradle.api.plugins.quality.internal.CodeNarcReportsImpl;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.util.internal.ClosureBackedAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class CodeNarc
extends SourceTask
implements VerificationTask,
Reporting<CodeNarcReports> {
    private FileCollection codenarcClasspath;
    private FileCollection compilationClasspath;
    private TextResource config;
    private int maxPriority1Violations;
    private int maxPriority2Violations;
    private int maxPriority3Violations;
    private final CodeNarcReports reports = this.getObjectFactory().newInstance(CodeNarcReportsImpl.class, this);
    private boolean ignoreFailures;
    private final Property<JavaLauncher> javaLauncher;

    public CodeNarc() {
        this.compilationClasspath = this.getProject().files(new Object[0]);
        this.javaLauncher = CodeNarc.configureFromCurrentJvmLauncher(this.getToolchainService(), this.getObjectFactory());
    }

    private static Property<JavaLauncher> configureFromCurrentJvmLauncher(JavaToolchainService toolchainService, ObjectFactory objectFactory) {
        Provider<JavaLauncher> currentJvmLauncherProvider = toolchainService.launcherFor(new CurrentJvmToolchainSpec(objectFactory));
        return objectFactory.property(JavaLauncher.class).convention(currentJvmLauncherProvider);
    }

    @Internal
    public File getConfigFile() {
        return this.getConfig() == null ? null : this.getConfig().asFile();
    }

    @Override
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    public void setConfigFile(File configFile) {
        this.setConfig(this.getProject().getResources().getText().fromFile(configFile));
    }

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    @Inject
    protected abstract JavaToolchainService getToolchainService();

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @Incubating
    @Nested
    public Property<JavaLauncher> getJavaLauncher() {
        return this.javaLauncher;
    }

    @TaskAction
    public void run() {
        WorkQueue workQueue = this.getWorkerExecutor().processIsolation(spec -> {
            spec.getForkOptions().setExecutable(((JavaLauncher)this.javaLauncher.get()).getExecutablePath().getAsFile().getAbsolutePath());
            AbstractCodeQualityPlugin.maybeAddOpensJvmArgs((JavaLauncher)this.javaLauncher.get(), spec);
        });
        workQueue.submit(CodeNarcAction.class, this::setupParameters);
    }

    private void setupParameters(CodeNarcActionParameters parameters) {
        parameters.getAntLibraryClasspath().setFrom(this.getCodenarcClasspath());
        parameters.getCompilationClasspath().setFrom(this.getCompilationClasspath());
        parameters.getConfig().set(this.getConfigFile());
        parameters.getMaxPriority1Violations().set(this.getMaxPriority1Violations());
        parameters.getMaxPriority2Violations().set(this.getMaxPriority2Violations());
        parameters.getMaxPriority3Violations().set(this.getMaxPriority3Violations());
        parameters.getEnabledReports().set(this.getReports().getEnabled().stream().map(report2 -> {
            CodeNarcActionParameters.EnabledReport newReport = this.getObjectFactory().newInstance(CodeNarcActionParameters.EnabledReport.class, new Object[0]);
            newReport.getName().set(report2.getName());
            newReport.getOutputLocation().set(report2.getOutputLocation());
            return newReport;
        }).collect(Collectors.toList()));
        parameters.getIgnoreFailures().set(this.getIgnoreFailures());
        parameters.getSource().setFrom(this.getSource());
    }

    @Override
    public CodeNarcReports reports(Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    @Override
    public CodeNarcReports reports(Action<? super CodeNarcReports> configureAction) {
        configureAction.execute(this.reports);
        return this.reports;
    }

    @Classpath
    public FileCollection getCodenarcClasspath() {
        return this.codenarcClasspath;
    }

    public void setCodenarcClasspath(FileCollection codenarcClasspath) {
        this.codenarcClasspath = codenarcClasspath;
    }

    @Classpath
    public FileCollection getCompilationClasspath() {
        return this.compilationClasspath;
    }

    public void setCompilationClasspath(FileCollection compilationClasspath) {
        this.compilationClasspath = compilationClasspath;
    }

    @Nested
    public TextResource getConfig() {
        return this.config;
    }

    public void setConfig(TextResource config) {
        this.config = config;
    }

    @Input
    public int getMaxPriority1Violations() {
        return this.maxPriority1Violations;
    }

    public void setMaxPriority1Violations(int maxPriority1Violations) {
        this.maxPriority1Violations = maxPriority1Violations;
    }

    @Input
    public int getMaxPriority2Violations() {
        return this.maxPriority2Violations;
    }

    public void setMaxPriority2Violations(int maxPriority2Violations) {
        this.maxPriority2Violations = maxPriority2Violations;
    }

    @Input
    public int getMaxPriority3Violations() {
        return this.maxPriority3Violations;
    }

    public void setMaxPriority3Violations(int maxPriority3Violations) {
        this.maxPriority3Violations = maxPriority3Violations;
    }

    @Override
    @Nested
    public CodeNarcReports getReports() {
        return this.reports;
    }

    @Override
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Override
    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }
}

