/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.util.Set;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.configurations.Configurations;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.component.AbstractSoftwareComponentVariant;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class ConfigurationSoftwareComponentVariant
extends AbstractSoftwareComponentVariant {
    protected final String name;
    private final Configuration configuration;
    private DomainObjectSet<ModuleDependency> dependencies;
    private DomainObjectSet<DependencyConstraint> dependencyConstraints;
    private Set<? extends Capability> capabilities;
    private Set<ExcludeRule> excludeRules;

    public ConfigurationSoftwareComponentVariant(SoftwareComponentVariant base, Set<? extends PublishArtifact> artifacts2, Configuration configuration) {
        this(base.getName(), base.getAttributes(), artifacts2, configuration);
    }

    public ConfigurationSoftwareComponentVariant(String name, AttributeContainer attributes, Set<? extends PublishArtifact> artifacts2, Configuration configuration) {
        super(((AttributeContainerInternal)attributes).asImmutable(), artifacts2);
        this.configuration = configuration;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Set<ModuleDependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = this.configuration.getIncoming().getDependencies().withType(ModuleDependency.class);
        }
        return this.dependencies;
    }

    @Override
    public Set<? extends DependencyConstraint> getDependencyConstraints() {
        if (this.dependencyConstraints == null) {
            this.dependencyConstraints = this.configuration.getIncoming().getDependencyConstraints();
        }
        return this.dependencyConstraints;
    }

    @Override
    public Set<? extends Capability> getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = ImmutableSet.copyOf(Configurations.collectCapabilities(this.configuration, Sets.newHashSet(), Sets.newHashSet()));
        }
        return this.capabilities;
    }

    @Override
    public Set<ExcludeRule> getGlobalExcludes() {
        if (this.excludeRules == null) {
            this.excludeRules = ImmutableSet.copyOf(((ConfigurationInternal)this.configuration).getAllExcludeRules());
        }
        return this.excludeRules;
    }
}

