/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.type.ArtifactTypeDefinition;
import org.gradle.api.attributes.AttributesSchema;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.artifacts.JavaEcosystemSupport;
import org.gradle.api.internal.artifacts.dsl.ComponentMetadataHandlerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.jvm.internal.JvmPluginServices;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.component.external.model.JavaEcosystemVariantDerivationStrategy;

public abstract class JvmEcosystemPlugin
implements Plugin<Project> {
    private final ObjectFactory objectFactory;
    private final JvmPluginServices jvmPluginServices;
    private final SourceSetContainer sourceSets;

    @Inject
    public JvmEcosystemPlugin(ObjectFactory objectFactory, JvmPluginServices jvmPluginServices, SourceSetContainer sourceSets) {
        this.objectFactory = objectFactory;
        this.jvmPluginServices = jvmPluginServices;
        this.sourceSets = sourceSets;
    }

    @Override
    public void apply(Project project) {
        ProjectInternal p = (ProjectInternal)project;
        project.getExtensions().add(SourceSetContainer.class, "sourceSets", this.sourceSets);
        this.configureVariantDerivationStrategy(p);
        this.configureSchema(p);
        this.jvmPluginServices.inject(p);
    }

    private void configureVariantDerivationStrategy(ProjectInternal project) {
        ComponentMetadataHandlerInternal metadataHandler = (ComponentMetadataHandlerInternal)((Object)project.getDependencies().getComponents());
        metadataHandler.setVariantDerivationStrategy(JavaEcosystemVariantDerivationStrategy.getInstance());
    }

    private void configureSchema(ProjectInternal project) {
        AttributesSchema attributesSchema = project.getDependencies().getAttributesSchema();
        JavaEcosystemSupport.configureSchema(attributesSchema, this.objectFactory);
        ((ArtifactTypeDefinition)project.getDependencies().getArtifactTypes().create("jar")).getAttributes().attribute(Usage.USAGE_ATTRIBUTE, this.objectFactory.named(Usage.class, "java-runtime")).attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, this.objectFactory.named(LibraryElements.class, "jar"));
    }
}

