/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.daemon;

import java.util.Set;
import org.gradle.api.internal.tasks.compile.daemon.CompilerWorkerExecutor;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.BaseForkOptions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.process.internal.util.MergeOptionsUtil;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.DefaultWorkResult;

public abstract class AbstractDaemonCompiler<T extends CompileSpec>
implements Compiler<T> {
    private final CompilerWorkerExecutor compilerWorkerExecutor;

    public AbstractDaemonCompiler(CompilerWorkerExecutor compilerWorkerExecutor) {
        this.compilerWorkerExecutor = compilerWorkerExecutor;
    }

    @Override
    public WorkResult execute(T spec) {
        DefaultWorkResult result2 = this.compilerWorkerExecutor.execute(this.getCompilerParameters(spec), this.toDaemonForkOptions(spec));
        if (result2.isSuccess()) {
            return result2;
        }
        throw UncheckedException.throwAsUncheckedException(result2.getException());
    }

    protected abstract DaemonForkOptions toDaemonForkOptions(T var1);

    protected abstract CompilerWorkerExecutor.CompilerParameters getCompilerParameters(T var1);

    protected BaseForkOptions mergeForkOptions(BaseForkOptions left, BaseForkOptions right) {
        BaseForkOptions merged = new BaseForkOptions();
        merged.setMemoryInitialSize(MergeOptionsUtil.mergeHeapSize(left.getMemoryInitialSize(), right.getMemoryInitialSize()));
        merged.setMemoryMaximumSize(MergeOptionsUtil.mergeHeapSize(left.getMemoryMaximumSize(), right.getMemoryMaximumSize()));
        Set<String> mergedJvmArgs = MergeOptionsUtil.normalized(left.getJvmArgs());
        mergedJvmArgs.addAll(MergeOptionsUtil.normalized(right.getJvmArgs()));
        merged.setJvmArgs(Lists.newArrayList(mergedJvmArgs));
        return merged;
    }
}

