/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskMutator;
import org.gradle.api.internal.tasks.TaskPropertyUtils;
import org.gradle.api.internal.tasks.TaskRequiredServices;
import org.gradle.api.internal.tasks.properties.GetServiceReferencesVisitor;
import org.gradle.api.internal.tasks.properties.ServiceReferenceSpec;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.internal.BuildServiceProvider;
import org.gradle.api.services.internal.ConsumedBuildServiceProvider;
import org.gradle.api.services.internal.RegisteredBuildServiceProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.properties.bean.PropertyWalker;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public class DefaultTaskRequiredServices
implements TaskRequiredServices {
    private final TaskInternal task;
    private final TaskMutator taskMutator;
    private final PropertyWalker propertyWalker;
    @Nullable
    private Set<RegisteredBuildServiceProvider<?, ?>> registeredServices;
    @Nullable
    private Collection<? extends BuildServiceProvider<?, ?>> consumedServices;

    public DefaultTaskRequiredServices(TaskInternal task, TaskMutator taskMutator, PropertyWalker propertyWalker) {
        this.task = task;
        this.taskMutator = taskMutator;
        this.propertyWalker = propertyWalker;
    }

    @Override
    public Set<Provider<? extends BuildService<?>>> getElements() {
        return this.getElements(false);
    }

    @Override
    public Set<Provider<? extends BuildService<?>>> searchServices() {
        return this.getElements(true);
    }

    private Set<Provider<? extends BuildService<?>>> getElements(boolean search) {
        ImmutableSet.Builder allServicesUsed = ImmutableSet.builder();
        if (this.registeredServices != null) {
            allServicesUsed.addAll(this.registeredServices);
        }
        if (search && this.consumedServices == null) {
            this.collectConsumedServices();
        }
        if (this.consumedServices != null) {
            this.consumedServices.stream().map(it -> ((ConsumedBuildServiceProvider)it).resolveIfPossible()).filter(Objects::nonNull).forEach(arg_0 -> ((ImmutableSet.Builder)allServicesUsed).add(arg_0));
        }
        ImmutableSet build = allServicesUsed.build();
        return (Set)Cast.uncheckedCast(build);
    }

    private void collectConsumedServices() {
        GetServiceReferencesVisitor collector = new GetServiceReferencesVisitor();
        TaskPropertyUtils.visitAnnotatedProperties(this.propertyWalker, this.task, TypeValidationContext.NOOP, collector);
        this.task.acceptServiceReferences((Set<ServiceReferenceSpec>)collector.getServiceReferences());
    }

    @Override
    public boolean isServiceRequired(Provider<? extends BuildService<?>> toCheck) {
        return this.getElements(false).stream().anyMatch(it -> BuildServiceProvider.isSameService(toCheck, it));
    }

    @Override
    public void registerServiceUsage(Provider<? extends BuildService<?>> service) {
        this.taskMutator.mutate("Task.usesService(Provider)", () -> this.addRegisteredService((RegisteredBuildServiceProvider)Cast.uncheckedNonnullCast(service)));
    }

    private void addRegisteredService(RegisteredBuildServiceProvider<?, ?> service) {
        if (this.registeredServices == null) {
            this.registeredServices = new LinkedHashSet();
        }
        this.registeredServices.add(service);
    }

    @Override
    public void acceptServiceReferences(List<? extends BuildServiceProvider<?, ?>> serviceReferences) {
        this.consumedServices = serviceReferences;
    }

    @Override
    public boolean hasServiceReferences() {
        return this.consumedServices != null;
    }
}

