/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider.sources.process;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.provider.sources.process.DelegatingBaseExecSpec;
import org.gradle.api.internal.provider.sources.process.ProcessOutputValueSource;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.ProcessForkOptions;

abstract class ProviderCompatibleBaseExecSpec
implements DelegatingBaseExecSpec {
    private final Map<String, Object> additionalEnvVars = new HashMap<String, Object>();
    @Nullable
    private Map<String, Object> fullEnvironment;
    @Nullable
    private File workingDirectory;

    ProviderCompatibleBaseExecSpec() {
    }

    @Override
    public BaseExecSpec setStandardInput(InputStream inputStream) {
        throw new UnsupportedOperationException("Standard streams cannot be configured for exec output provider");
    }

    @Override
    public InputStream getStandardInput() {
        throw new UnsupportedOperationException("Standard streams cannot be configured for exec output provider");
    }

    @Override
    public BaseExecSpec setStandardOutput(OutputStream outputStream) {
        throw new UnsupportedOperationException("Standard streams cannot be configured for exec output provider");
    }

    @Override
    public OutputStream getStandardOutput() {
        throw new UnsupportedOperationException("Standard streams cannot be configured for exec output provider");
    }

    @Override
    public BaseExecSpec setErrorOutput(OutputStream outputStream) {
        throw new UnsupportedOperationException("Standard streams cannot be configured for exec output provider");
    }

    @Override
    public OutputStream getErrorOutput() {
        throw new UnsupportedOperationException("Standard streams cannot be configured for exec output provider");
    }

    @Override
    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.fullEnvironment = new HashMap(environmentVariables);
        this.additionalEnvVars.clear();
        DelegatingBaseExecSpec.super.setEnvironment(this.fullEnvironment);
    }

    @Override
    public ProcessForkOptions environment(Map<String, ?> environmentVariables) {
        this.getMapForAppends().putAll(environmentVariables);
        DelegatingBaseExecSpec.super.environment(environmentVariables);
        return this;
    }

    @Override
    public ProcessForkOptions environment(String name, Object value) {
        this.getMapForAppends().put(name, value);
        DelegatingBaseExecSpec.super.environment(name, value);
        return this;
    }

    private Map<String, Object> getMapForAppends() {
        return this.fullEnvironment != null ? this.fullEnvironment : this.additionalEnvVars;
    }

    @Override
    public void setWorkingDir(File dir) {
        DelegatingBaseExecSpec.super.setWorkingDir(dir);
        this.workingDirectory = this.getWorkingDir();
    }

    @Override
    public void setWorkingDir(Object dir) {
        DelegatingBaseExecSpec.super.setWorkingDir(dir);
        this.workingDirectory = this.getWorkingDir();
    }

    @Override
    public ProcessForkOptions workingDir(Object dir) {
        DelegatingBaseExecSpec.super.workingDir(dir);
        this.workingDirectory = this.getWorkingDir();
        return this;
    }

    @Override
    public ProcessForkOptions copyTo(ProcessForkOptions options) {
        return DelegatingBaseExecSpec.super.copyTo(options);
    }

    public void copyToParameters(ProcessOutputValueSource.Parameters parameters) {
        parameters.getCommandLine().set(this.getCommandLine());
        parameters.getFullEnvironment().set(this.fullEnvironment);
        parameters.getAdditionalEnvironmentVariables().set(this.additionalEnvVars.isEmpty() ? null : this.additionalEnvVars);
        parameters.getWorkingDirectory().set(this.workingDirectory);
        parameters.getIgnoreExitValue().set(this.isIgnoreExitValue());
    }
}

