/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AbstractAttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.provider.Provider;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public class HierarchicalAttributeContainer
extends AbstractAttributeContainer {
    private final ImmutableAttributesFactory attributesFactory;
    private final AttributeContainerInternal fallback;
    private final AttributeContainerInternal primary;

    public HierarchicalAttributeContainer(ImmutableAttributesFactory attributesFactory, AttributeContainerInternal fallback, AttributeContainerInternal primary) {
        this.attributesFactory = attributesFactory;
        this.fallback = fallback;
        this.primary = primary;
    }

    @Override
    public Set<Attribute<?>> keySet() {
        return Sets.union(this.fallback.keySet(), this.primary.keySet());
    }

    @Override
    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        this.primary.attribute(key, value);
        return this;
    }

    @Override
    public <T> AttributeContainer attributeProvider(Attribute<T> key, Provider<? extends T> provider) {
        this.primary.attributeProvider(key, provider);
        return this;
    }

    @Override
    @Nullable
    public <T> T getAttribute(Attribute<T> key) {
        T attribute = this.primary.getAttribute(key);
        if (attribute != null) {
            return attribute;
        }
        return this.fallback.getAttribute(key);
    }

    @Override
    public ImmutableAttributes asImmutable() {
        if (this.primary.isEmpty()) {
            return this.fallback.asImmutable();
        }
        if (this.fallback.isEmpty()) {
            return this.primary.asImmutable();
        }
        return this.attributesFactory.concat(this.fallback.asImmutable(), this.primary.asImmutable());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HierarchicalAttributeContainer that = (HierarchicalAttributeContainer)o;
        return this.fallback.equals(that.fallback) && this.primary.equals(that.primary);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fallback, this.primary);
    }

    public String toString() {
        TreeMap sorted = new TreeMap(Comparator.comparing(Attribute::getName));
        this.fallback.keySet().forEach(key -> sorted.put((Attribute)key, this.fallback.getAttribute(key)));
        this.primary.keySet().forEach(key -> sorted.put((Attribute)key, this.primary.getAttribute(key)));
        return ((Object)sorted).toString();
    }
}

